/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.TxnLogProposalIterator;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileSnap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.TxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.SerializeUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CheckedInputStream;

public class ZKDatabase {
    private static final foe LOG = goe.a(ZKDatabase.class);
    protected DataTree dataTree;
    protected ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    protected FileTxnSnapLog snapLog;
    protected long minCommittedLog;
    protected long maxCommittedLog;
    public static final String SNAPSHOT_SIZE_FACTOR = "zookeeper.snapshotSizeFactor";
    public static final double DEFAULT_SNAPSHOT_SIZE_FACTOR = 0.33;
    private double snapshotSizeFactor;
    public static final String COMMIT_LOG_COUNT = "zookeeper.commitLogCount";
    public static final int DEFAULT_COMMIT_LOG_COUNT = 500;
    public int commitLogCount;
    protected Queue<Leader.Proposal> committedLog = new ArrayDeque<Leader.Proposal>();
    protected ReentrantReadWriteLock logLock = new ReentrantReadWriteLock();
    private volatile boolean initialized = false;
    private AtomicInteger txnCount = new AtomicInteger(0);
    private final FileTxnSnapLog.PlayBackListener commitProposalPlaybackListener = new FileTxnSnapLog.PlayBackListener(){

        @Override
        public void onTxnLoaded(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
            ZKDatabase.this.addCommittedProposal(txnHeader, mme2, txnDigest);
        }
    };

    public ZKDatabase(FileTxnSnapLog fileTxnSnapLog) {
        this.dataTree = this.createDataTree();
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.snapLog = fileTxnSnapLog;
        try {
            this.snapshotSizeFactor = Double.parseDouble(System.getProperty(SNAPSHOT_SIZE_FACTOR, Double.toString(0.33)));
            if (this.snapshotSizeFactor > 1.0) {
                this.snapshotSizeFactor = 0.33;
                LOG.d("The configured {} is invalid, going to use the default {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)0.33);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.e("Error parsing {}, using default value {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)0.33);
            this.snapshotSizeFactor = 0.33;
        }
        LOG.c("{} = {}", (Object)SNAPSHOT_SIZE_FACTOR, (Object)this.snapshotSizeFactor);
        try {
            this.commitLogCount = Integer.parseInt(System.getProperty(COMMIT_LOG_COUNT, Integer.toString(500)));
            if (this.commitLogCount < 500) {
                this.commitLogCount = 500;
                LOG.d("The configured commitLogCount {} is less than the recommended {}, going to use the recommended one", (Object)COMMIT_LOG_COUNT, (Object)500);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.e("Error parsing {} - use default value {}", (Object)COMMIT_LOG_COUNT, (Object)500);
            this.commitLogCount = 500;
        }
        LOG.c("{}={}", (Object)COMMIT_LOG_COUNT, (Object)this.commitLogCount);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void clear() {
        this.minCommittedLog = 0L;
        this.maxCommittedLog = 0L;
        this.dataTree.shutdownWatcher();
        this.dataTree = this.createDataTree();
        this.sessionsWithTimeouts.clear();
        ReentrantReadWriteLock.WriteLock writeLock = this.logLock.writeLock();
        try {
            writeLock.lock();
            this.committedLog.clear();
        }
        finally {
            writeLock.unlock();
        }
        this.initialized = false;
    }

    public DataTree getDataTree() {
        return this.dataTree;
    }

    public long getmaxCommittedLog() {
        return this.maxCommittedLog;
    }

    public long getminCommittedLog() {
        return this.minCommittedLog;
    }

    public ReentrantReadWriteLock getLogLock() {
        return this.logLock;
    }

    public synchronized Collection<Leader.Proposal> getCommittedLog() {
        Collection<Leader.Proposal> collection;
        ReentrantReadWriteLock.ReadLock readLock = this.logLock.readLock();
        if (this.logLock.getReadHoldCount() > 0) {
            collection = this.committedLog;
        } else {
            readLock.lock();
            try {
                collection = new ArrayList<Leader.Proposal>(this.committedLog);
            }
            finally {
                readLock.unlock();
            }
        }
        return Collections.unmodifiableCollection(collection);
    }

    public long getDataTreeLastProcessedZxid() {
        return this.dataTree.lastProcessedZxid;
    }

    public Collection<Long> getSessions() {
        return this.dataTree.getSessions();
    }

    public long getSessionCount() {
        return this.sessionsWithTimeouts.size();
    }

    public ConcurrentHashMap<Long, Integer> getSessionWithTimeOuts() {
        return this.sessionsWithTimeouts;
    }

    public long loadDataBase() throws IOException {
        long l2 = Time.currentElapsedTime();
        long l3 = this.snapLog.restore(this.dataTree, this.sessionsWithTimeouts, this.commitProposalPlaybackListener);
        this.initialized = true;
        long l4 = Time.currentElapsedTime() - l2;
        ServerMetrics.getMetrics().DB_INIT_TIME.add(l4);
        LOG.c("Snapshot loaded in {} ms, highest zxid is 0x{}, digest is {}", l4, Long.toHexString(l3), this.dataTree.getTreeDigest());
        return l3;
    }

    public long fastForwardDataBase() throws IOException {
        long l2 = this.snapLog.fastForwardFromEdits(this.dataTree, this.sessionsWithTimeouts, this.commitProposalPlaybackListener);
        this.initialized = true;
        return l2;
    }

    private void addCommittedProposal(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        Request request = new Request(0L, txnHeader.getCxid(), txnHeader.getType(), txnHeader, mme2, txnHeader.getZxid());
        request.setTxnDigest(txnDigest);
        this.addCommittedProposal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommittedProposal(Request request) {
        ReentrantReadWriteLock.WriteLock writeLock = this.logLock.writeLock();
        try {
            writeLock.lock();
            if (this.committedLog.size() > this.commitLogCount) {
                this.committedLog.remove();
                this.minCommittedLog = this.committedLog.peek().getZxid();
            }
            if (this.committedLog.isEmpty()) {
                this.minCommittedLog = request.zxid;
                this.maxCommittedLog = request.zxid;
            }
            Leader.PureRequestProposal pureRequestProposal = new Leader.PureRequestProposal(request);
            this.committedLog.add(pureRequestProposal);
            this.maxCommittedLog = pureRequestProposal.getZxid();
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isTxnLogSyncEnabled() {
        boolean bl2;
        boolean bl3 = bl2 = this.snapshotSizeFactor >= 0.0;
        if (bl2) {
            LOG.c("On disk txn sync enabled with snapshotSizeFactor {}", (Object)this.snapshotSizeFactor);
        } else {
            LOG.c("On disk txn sync disabled");
        }
        return bl2;
    }

    public long calculateTxnLogSizeLimit() {
        long l2 = 0L;
        try {
            File file = this.snapLog.findMostRecentSnapshot();
            if (file != null) {
                l2 = file.length();
            }
        }
        catch (IOException iOException) {
            LOG.e("Unable to get size of most recent snapshot");
        }
        return (long)((double)l2 * this.snapshotSizeFactor);
    }

    public Iterator<Leader.Proposal> getProposalsFromTxnLog(long l2, long l3) {
        if (l3 < 0L) {
            LOG.b("Negative size limit - retrieving proposal via txnlog is disabled");
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        TxnLog.TxnIterator txnIterator = null;
        try {
            long l4;
            txnIterator = this.snapLog.readTxnLog(l2, false);
            if (txnIterator.getHeader() != null && txnIterator.getHeader().getZxid() > l2) {
                LOG.d("Unable to find proposals from txnlog for zxid: 0x{}", (Object)Long.toHexString(l2));
                txnIterator.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
            if (l3 > 0L && (l4 = txnIterator.getStorageSize()) > l3) {
                LOG.c("Txnlog size: {} exceeds sizeLimit: {}", (Object)l4, (Object)l3);
                txnIterator.close();
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
        }
        catch (IOException iOException) {
            LOG.d("Unable to read txnlog from disk", iOException);
            try {
                if (txnIterator != null) {
                    txnIterator.close();
                }
            }
            catch (IOException iOException2) {
                LOG.c("Error closing file iterator", iOException2);
            }
            return TxnLogProposalIterator.EMPTY_ITERATOR;
        }
        return new TxnLogProposalIterator(txnIterator);
    }

    public List<ACL> aclForNode(DataNode dataNode) {
        return this.dataTree.getACL(dataNode);
    }

    public void removeCnxn(ServerCnxn serverCnxn) {
        this.dataTree.removeCnxn(serverCnxn);
    }

    public void killSession(long l2, long l3) {
        this.dataTree.killSession(l2, l3);
    }

    public void dumpEphemerals(PrintWriter printWriter) {
        this.dataTree.dumpEphemerals(printWriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.dataTree.getEphemerals();
    }

    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    public Set<String> getEphemerals(long l2) {
        return this.dataTree.getEphemerals(l2);
    }

    public void setlastProcessedZxid(long l2) {
        this.dataTree.lastProcessedZxid = l2;
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        return this.dataTree.processTxn(txnHeader, mme2, txnDigest);
    }

    public Stat statNode(String string, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
        return this.dataTree.statNode(string, serverCnxn);
    }

    public DataNode getNode(String string) {
        return this.dataTree.getNode(string);
    }

    public byte[] getData(String string, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getData(string, stat, watcher);
    }

    public void setWatches(long l2, List<String> list, List<String> list2, List<String> list3, List<String> list4, List<String> list5, Watcher watcher) {
        this.dataTree.setWatches(l2, list, list2, list3, list4, list5, watcher);
    }

    public void addWatch(String string, Watcher watcher, int n2) {
        this.dataTree.addWatch(string, watcher, n2);
    }

    public List<ACL> getACL(String string, Stat stat) throws KeeperException.NoNodeException {
        return this.dataTree.getACL(string, stat);
    }

    public List<String> getChildren(String string, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        return this.dataTree.getChildren(string, stat, watcher);
    }

    public int getAllChildrenNumber(String string) throws KeeperException.NoNodeException {
        return this.dataTree.getAllChildrenNumber(string);
    }

    public boolean isSpecialPath(String string) {
        return this.dataTree.isSpecialPath(string);
    }

    public int getAclSize() {
        return this.dataTree.aclCacheSize();
    }

    public boolean truncateLog(long l2) throws IOException {
        this.clear();
        boolean bl2 = this.snapLog.truncateLog(l2);
        if (!bl2) {
            return false;
        }
        this.loadDataBase();
        return true;
    }

    public void deserializeSnapshot(kme kme2) throws IOException {
        this.clear();
        SerializeUtils.deserializeSnapshot(this.getDataTree(), kme2, this.getSessionWithTimeOuts());
        this.initialized = true;
    }

    public void deserializeSnapshot(kme kme2, CheckedInputStream checkedInputStream) throws IOException {
        this.clear();
        DataTree dataTree = this.getDataTree();
        FileSnap.deserialize(dataTree, this.getSessionWithTimeOuts(), kme2);
        SnapStream.checkSealIntegrity(checkedInputStream, kme2);
        if (dataTree.deserializeZxidDigest(kme2, 0L)) {
            SnapStream.checkSealIntegrity(checkedInputStream, kme2);
        }
        if (dataTree.deserializeLastProcessedZxid(kme2)) {
            SnapStream.checkSealIntegrity(checkedInputStream, kme2);
        }
        if (dataTree.getDigestFromLoadedSnapshot() != null) {
            dataTree.compareSnapshotDigests(dataTree.lastProcessedZxid);
        }
        this.initialized = true;
    }

    public void serializeSnapshot(lme lme2) throws IOException, InterruptedException {
        SerializeUtils.serializeSnapshot(this.getDataTree(), lme2, this.getSessionWithTimeOuts());
    }

    public boolean append(Request request) throws IOException {
        if (this.snapLog.append(request)) {
            this.txnCount.incrementAndGet();
            return true;
        }
        return false;
    }

    public void rollLog() throws IOException {
        this.snapLog.rollLog();
        this.resetTxnCount();
    }

    public void commit() throws IOException {
        this.snapLog.commit();
    }

    public void close() throws IOException {
        this.snapLog.close();
    }

    public synchronized void initConfigInZKDatabase(QuorumVerifier quorumVerifier) {
        if (quorumVerifier == null) {
            return;
        }
        try {
            if (this.dataTree.getNode("/zookeeper/config") == null) {
                LOG.d("configuration znode missing (should only happen during upgrade), creating the node");
                this.dataTree.addConfigNode();
            }
            this.dataTree.setData("/zookeeper/config", quorumVerifier.toString().getBytes(StandardCharsets.UTF_8), -1, quorumVerifier.getVersion(), Time.currentWallTime());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            System.out.println("configuration node missing - should not happen");
        }
    }

    public void setSnapshotSizeFactor(double d2) {
        this.snapshotSizeFactor = d2;
    }

    public boolean containsWatcher(String string, Watcher.WatcherType watcherType, Watcher watcher) {
        return this.dataTree.containsWatcher(string, watcherType, watcher);
    }

    public boolean removeWatch(String string, Watcher.WatcherType watcherType, Watcher watcher) {
        return this.dataTree.removeWatch(string, watcherType, watcher);
    }

    public DataTree createDataTree() {
        return new DataTree();
    }

    public void resetTxnCount() {
        this.txnCount.set(0);
        this.snapLog.setTotalLogSize(0L);
    }

    public int getTxnCount() {
        return this.txnCount.get();
    }

    public long getTxnSize() {
        return this.snapLog.getTotalLogSize();
    }

    public boolean compareDigest(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        return this.dataTree.compareDigest(txnHeader, mme2, txnDigest);
    }
}

