/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.TxnLog;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Leader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPacket;
import java.io.IOException;
import java.util.Iterator;

public class TxnLogProposalIterator
implements Iterator<Leader.Proposal> {
    private static final foe LOG = goe.a(TxnLogProposalIterator.class);
    public static final TxnLogProposalIterator EMPTY_ITERATOR = new TxnLogProposalIterator();
    private boolean hasNext = false;
    private TxnLog.TxnIterator itr;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Leader.Proposal next() {
        Leader.Proposal proposal;
        try {
            byte[] byArray = Util.marshallTxnEntry(this.itr.getHeader(), this.itr.getTxn(), this.itr.getDigest());
            QuorumPacket quorumPacket = new QuorumPacket(2, this.itr.getHeader().getZxid(), byArray, null);
            proposal = new Leader.Proposal(quorumPacket);
            this.hasNext = this.itr.next();
        }
        catch (IOException iOException) {
            LOG.d("Unable to read txnlog from disk", iOException);
            this.hasNext = false;
            proposal = new Leader.Proposal();
        }
        return proposal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.itr != null) {
            try {
                this.itr.close();
            }
            catch (IOException iOException) {
                LOG.c("Error closing file iterator", iOException);
            }
        }
    }

    private TxnLogProposalIterator() {
    }

    public TxnLogProposalIterator(TxnLog.TxnIterator txnIterator) {
        if (txnIterator != null) {
            this.itr = txnIterator;
            this.hasNext = txnIterator.getHeader() != null;
        }
    }
}

