/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.hme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.FileSnap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.SnapStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.CheckedInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SnapshotComparer {
    private final Options options = new Options();
    private static final String leftOption = "left";
    private static final String rightOption = "right";
    private static final String byteThresholdOption = "bytes";
    private static final String nodeThresholdOption = "nodes";
    private static final String debugOption = "debug";
    private static final String interactiveOption = "interactive";

    private SnapshotComparer() {
        this.options.addOption(Option.builder((String)"l").hasArg().required(true).longOpt(leftOption).desc("(Required) The left snapshot file.").argName("LEFT").type(File.class).build());
        this.options.addOption(Option.builder((String)"r").hasArg().required(true).longOpt(rightOption).desc("(Required) The right snapshot file.").argName("RIGHT").type(File.class).build());
        this.options.addOption(Option.builder((String)"b").hasArg().required(true).longOpt(byteThresholdOption).desc("(Required) The node data delta size threshold, in bytes, for printing the node.").argName("BYTETHRESHOLD").type(String.class).build());
        this.options.addOption(Option.builder((String)"n").hasArg().required(true).longOpt(nodeThresholdOption).desc("(Required) The descendant node delta size threshold, in nodes, for printing the node.").argName("NODETHRESHOLD").type(String.class).build());
        this.options.addOption("d", debugOption, false, "Use debug output.");
        this.options.addOption("i", interactiveOption, false, "Enter interactive mode.");
    }

    private void usage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(120, "java -cp <classPath> " + SnapshotComparer.class.getName(), "", this.options, "");
    }

    public static void main(String[] stringArray) throws Exception {
        SnapshotComparer snapshotComparer = new SnapshotComparer();
        snapshotComparer.compareSnapshots(stringArray);
    }

    private void compareSnapshots(String[] stringArray) throws Exception {
        CommandLine commandLine;
        try {
            commandLine = new DefaultParser().parse(this.options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            this.usage();
            ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
            return;
        }
        File file = (File)commandLine.getParsedOptionValue(leftOption);
        File file2 = (File)commandLine.getParsedOptionValue(rightOption);
        int n2 = Integer.parseInt((String)commandLine.getParsedOptionValue(byteThresholdOption));
        int n3 = Integer.parseInt((String)commandLine.getParsedOptionValue(nodeThresholdOption));
        boolean bl2 = commandLine.hasOption(debugOption);
        boolean bl3 = commandLine.hasOption(interactiveOption);
        System.out.println("Successfully parsed options!");
        TreeInfo treeInfo = new TreeInfo(file);
        TreeInfo treeInfo2 = new TreeInfo(file2);
        System.out.println(treeInfo.toString());
        System.out.println(treeInfo2.toString());
        SnapshotComparer.compareTrees(treeInfo, treeInfo2, n2, n3, bl2, bl3);
    }

    private static DataTree getSnapshot(File file) throws Exception {
        DataTree dataTree = new DataTree();
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        CheckedInputStream checkedInputStream = SnapStream.getInputStream(file);
        long l2 = System.nanoTime();
        hme hme2 = hme.a(checkedInputStream);
        FileSnap.deserialize(dataTree, hashMap, hme2);
        long l3 = System.nanoTime();
        System.out.println(String.format("Deserialized snapshot in %s in %f seconds", file.getName(), (double)(l3 - l2) / 1000000.0 / 1000.0));
        return dataTree;
    }

    private static void printThresholdInfo(int n2, int n3) {
        System.out.println(String.format("Printing analysis for nodes difference larger than %d bytes or node count difference larger than %d.", n2, n3));
    }

    private static void compareTrees(TreeInfo treeInfo, TreeInfo treeInfo2, int n2, int n3, boolean bl2, boolean bl3) {
        int n4 = Math.max(treeInfo.nodesAtDepths.size(), treeInfo2.nodesAtDepths.size());
        if (!bl3) {
            SnapshotComparer.printThresholdInfo(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                System.out.println(String.format("Analysis for depth %d", i2));
                SnapshotComparer.compareLine(treeInfo, treeInfo2, i2, n2, n3, bl2, bl3);
            }
        } else {
            Scanner scanner = new Scanner(System.in);
            int n5 = 0;
            while (n5 < n4) {
                System.out.println(String.format("Current depth is %d", n5));
                System.out.println("- Press enter to move to print current depth layer;\n- Type a number to jump to and print all nodes at a given depth;\n- Enter an ABSOLUTE path to print the immediate subtree of a node. Path must start with '/'.");
                String string = scanner.nextLine();
                SnapshotComparer.printThresholdInfo(n2, n3);
                if (string.isEmpty()) {
                    System.out.println(String.format("Analysis for depth %d", n5));
                    SnapshotComparer.compareLine(treeInfo, treeInfo2, n5, n2, n3, bl2, bl3);
                    ++n5;
                } else if (string.startsWith("/")) {
                    System.out.println(String.format("Analysis for node %s", string));
                    SnapshotComparer.compareSubtree(treeInfo, treeInfo2, string, n2, n3, bl2, bl3);
                } else {
                    try {
                        int n6 = Integer.parseInt(string);
                        if (n6 < 0 || n6 >= n4) {
                            System.out.println(String.format("Depth must be in range [%d, %d]", 0, n4 - 1));
                            continue;
                        }
                        n5 = n6;
                        System.out.println(String.format("Analysis for depth %d", n5));
                        SnapshotComparer.compareLine(treeInfo, treeInfo2, n5, n2, n3, bl2, bl3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(String.format("Input %s is not valid. Depth must be in range [%d, %d]. Path must be an absolute path which starts with '/'.", string, 0, n4 - 1));
                    }
                }
                System.out.println("");
            }
        }
        System.out.println("All layers compared.");
    }

    private static void compareSubtree(TreeInfo treeInfo, TreeInfo treeInfo2, String string, int n2, int n3, boolean bl2, boolean bl3) {
        ArrayList<TreeInfo.TreeNode> arrayList;
        TreeInfo.TreeNode treeNode = treeInfo.nodesByName.get(string);
        TreeInfo.TreeNode treeNode2 = treeInfo2.nodesByName.get(string);
        ArrayList<TreeInfo.TreeNode> arrayList2 = treeNode == null ? new ArrayList() : treeNode.children;
        List<Object> list = arrayList = treeNode2 == null ? new ArrayList() : treeNode2.children;
        if (treeNode == null && treeNode2 == null) {
            System.out.println(String.format("Path %s is neither found in left tree nor right tree.", string));
        } else {
            SnapshotComparer.compareNodes(arrayList2, arrayList, n2, n3, bl2, bl3);
        }
    }

    private static void compareLine(TreeInfo treeInfo, TreeInfo treeInfo2, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        ArrayList<TreeInfo.TreeNode> arrayList = n2 >= treeInfo.nodesAtDepths.size() ? new ArrayList<TreeInfo.TreeNode>() : (List)treeInfo.nodesAtDepths.get(n2);
        ArrayList<TreeInfo.TreeNode> arrayList2 = n2 >= treeInfo2.nodesAtDepths.size() ? new ArrayList<TreeInfo.TreeNode>() : (List)treeInfo2.nodesAtDepths.get(n2);
        SnapshotComparer.compareNodes(arrayList, arrayList2, n3, n4, bl2, bl3);
    }

    private static void compareNodes(List<TreeInfo.TreeNode> list, List<TreeInfo.TreeNode> list2, int n2, int n3, boolean bl2, boolean bl3) {
        boolean bl4;
        Comparator<TreeInfo.TreeNode> comparator = TreeInfo.MakeAlphabeticComparator();
        Collections.sort(list, comparator);
        Collections.sort(list2, comparator);
        int n4 = 0;
        int n5 = 0;
        boolean bl5 = list.size() > n4;
        boolean bl6 = bl4 = list2.size() > n5;
        while (bl5 || bl4) {
            TreeInfo.TreeNode treeNode = null;
            if (bl5) {
                treeNode = list.get(n4);
            }
            TreeInfo.TreeNode treeNode2 = null;
            if (bl4) {
                treeNode2 = list2.get(n5);
            }
            if (treeNode != null && treeNode2 != null) {
                int n6;
                if (bl2) {
                    System.out.println(String.format("Comparing %s to %s", treeNode.label, treeNode2.label));
                }
                if ((n6 = treeNode.label.compareTo(treeNode2.label)) < 0) {
                    if (bl2) {
                        System.out.println("left is less");
                    }
                    SnapshotComparer.printLeftOnly(treeNode, n2, n3, bl2, bl3);
                    ++n4;
                } else if (n6 > 0) {
                    if (bl2) {
                        System.out.println("right is less");
                    }
                    SnapshotComparer.printRightOnly(treeNode2, n2, n3, bl2, bl3);
                    ++n5;
                } else {
                    if (bl2) {
                        System.out.println("same");
                    }
                    SnapshotComparer.printBoth(treeNode, treeNode2, n2, n3, bl2, bl3);
                    ++n4;
                    ++n5;
                }
            } else if (treeNode != null) {
                SnapshotComparer.printLeftOnly(treeNode, n2, n3, bl2, bl3);
                ++n4;
            } else {
                SnapshotComparer.printRightOnly(treeNode2, n2, n3, bl2, bl3);
                ++n5;
            }
            bl5 = list.size() > n4;
            bl4 = list2.size() > n5;
        }
    }

    static void printLeftOnly(TreeInfo.TreeNode treeNode, int n2, int n3, boolean bl2, boolean bl3) {
        if (treeNode.descendantSize > (long)n2 || treeNode.descendantCount > (long)n3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Node %s found only in left tree. ", treeNode.label));
            SnapshotComparer.printNode(treeNode, stringBuilder);
            System.out.println(stringBuilder.toString());
        } else if (bl2 || bl3) {
            System.out.println(String.format("Filtered left node %s of size %d", treeNode.label, treeNode.descendantSize));
        }
    }

    static void printRightOnly(TreeInfo.TreeNode treeNode, int n2, int n3, boolean bl2, boolean bl3) {
        if (treeNode.descendantSize > (long)n2 || treeNode.descendantCount > (long)n3) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Node %s found only in right tree. ", treeNode.label));
            SnapshotComparer.printNode(treeNode, stringBuilder);
            System.out.println(stringBuilder.toString());
        } else if (bl2 || bl3) {
            System.out.println(String.format("Filtered right node %s of size %d", treeNode.label, treeNode.descendantSize));
        }
    }

    static void printBoth(TreeInfo.TreeNode treeNode, TreeInfo.TreeNode treeNode2, int n2, int n3, boolean bl2, boolean bl3) {
        if (Math.abs(treeNode2.descendantSize - treeNode.descendantSize) > (long)n2 || Math.abs(treeNode2.descendantCount - treeNode.descendantCount) > (long)n3) {
            System.out.println(String.format("Node %s found in both trees. Delta: %d bytes, %d descendants", treeNode.label, treeNode2.descendantSize - treeNode.descendantSize, treeNode2.descendantCount - treeNode.descendantCount));
        } else if (bl2 || bl3) {
            System.out.println(String.format("Filtered node %s of left size %d, right size %d", treeNode.label, treeNode.descendantSize, treeNode2.descendantSize));
        }
    }

    static void printNode(TreeInfo.TreeNode treeNode, StringBuilder stringBuilder) {
        stringBuilder.append(String.format("Descendant size: %d. Descendant count: %d", treeNode.descendantSize, treeNode.descendantCount));
    }

    static class TreeInfo {
        final TreeNode root;
        long count;
        List<ArrayList<TreeNode>> nodesAtDepths = new ArrayList<ArrayList<TreeNode>>();
        Map<String, TreeNode> nodesByName = new HashMap<String, TreeNode>();

        TreeInfo(File file) throws Exception {
            DataTree dataTree = SnapshotComparer.getSnapshot(file);
            this.count = 0L;
            long l2 = System.nanoTime();
            DataNode dataNode = dataTree.getNode("");
            long l3 = dataNode.data == null ? 0L : (long)dataNode.data.length;
            this.root = new TreeNode("", l3);
            this.root.populateChildren("", dataTree, this);
            long l4 = System.nanoTime();
            System.out.println(String.format("Processed data tree in %f seconds", ((double)l4 - (double)l2) / 1000000.0 / 1000.0));
        }

        void registerNode(TreeNode treeNode, int n2) {
            while (n2 > this.nodesAtDepths.size()) {
                this.nodesAtDepths.add(new ArrayList());
            }
            this.nodesAtDepths.get(n2 - 1).add(treeNode);
            this.nodesByName.put(treeNode.label, treeNode);
            ++this.count;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("Node count: %d%n", this.count));
            stringBuilder.append(String.format("Total size: %d%n", this.root.descendantSize));
            stringBuilder.append(String.format("Max depth: %d%n", this.nodesAtDepths.size()));
            for (int i2 = 0; i2 < this.nodesAtDepths.size(); ++i2) {
                stringBuilder.append(String.format("Count of nodes at depth %d: %d%n", i2, this.nodesAtDepths.get(i2).size()));
            }
            return stringBuilder.toString();
        }

        public static Comparator<TreeNode> MakeAlphabeticComparator() {
            return new TreeNode.AlphabeticComparator();
        }

        public static class TreeNode {
            final String label;
            final long size;
            final List<TreeNode> children;
            long descendantSize;
            long descendantCount;

            public TreeNode(String string, long l2) {
                this.label = string;
                this.size = l2;
                this.children = new ArrayList<TreeNode>();
            }

            void populateChildren(String string, DataTree dataTree, TreeInfo treeInfo) throws Exception {
                this.populateChildren(string, dataTree, treeInfo, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void populateChildren(String string, DataTree dataTree, TreeInfo treeInfo, int n2) throws Exception {
                List<String> list = null;
                list = dataTree.getChildren(string, null, null);
                if (list != null && !list.isEmpty()) {
                    for (String object : list) {
                        long l2;
                        String string2 = string + "/" + object;
                        DataNode dataNode = dataTree.getNode(string2);
                        Object object2 = dataNode;
                        synchronized (object2) {
                            l2 = dataNode.data == null ? 0L : (long)dataNode.data.length;
                        }
                        object2 = new TreeNode(string2, l2);
                        ((TreeNode)object2).populateChildren(string2, dataTree, treeInfo, n2 + 1);
                        this.children.add((TreeNode)object2);
                    }
                }
                this.descendantSize = 0L;
                this.descendantCount = 0L;
                for (TreeNode treeNode : this.children) {
                    this.descendantSize += treeNode.descendantSize;
                    this.descendantCount += treeNode.descendantCount;
                }
                this.descendantSize += this.size;
                this.descendantCount += (long)this.children.size();
                treeInfo.registerNode(this, n2);
            }

            public static class AlphabeticComparator
            implements Serializable,
            Comparator<TreeNode> {
                private static final long serialVersionUID = 2601197766392565593L;

                @Override
                public int compare(TreeNode treeNode, TreeNode treeNode2) {
                    if (treeNode == treeNode2) {
                        return 0;
                    }
                    if (treeNode == null) {
                        return -1;
                    }
                    if (treeNode2 == null) {
                        return 1;
                    }
                    return treeNode.label.compareTo(treeNode2.label);
                }
            }
        }
    }
}

