/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExpiryQueue;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.SessionTracker;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerListener;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class SessionTrackerImpl
extends ZooKeeperCriticalThread
implements SessionTracker {
    private static final foe LOG = goe.a(SessionTrackerImpl.class);
    protected final ConcurrentHashMap<Long, SessionImpl> sessionsById = new ConcurrentHashMap();
    private final ExpiryQueue<SessionImpl> sessionExpiryQueue;
    public final ConcurrentMap<Long, Integer> sessionsWithTimeout;
    private final AtomicLong nextSessionId = new AtomicLong();
    private final SessionTracker.SessionExpirer expirer;
    volatile boolean running = true;

    public static long initializeNextSessionId(long l2) {
        long l3 = Time.currentElapsedTime() << 24 >>> 8;
        if ((l3 |= l2 << 56) == Long.MIN_VALUE) {
            ++l3;
        }
        return l3;
    }

    public SessionTrackerImpl(SessionTracker.SessionExpirer sessionExpirer, ConcurrentMap<Long, Integer> concurrentMap, int n2, long l2, ZooKeeperServerListener zooKeeperServerListener) {
        super("SessionTracker", zooKeeperServerListener);
        this.expirer = sessionExpirer;
        this.sessionExpiryQueue = new ExpiryQueue(n2);
        this.sessionsWithTimeout = concurrentMap;
        this.nextSessionId.set(SessionTrackerImpl.initializeNextSessionId(l2));
        for (Map.Entry entry : concurrentMap.entrySet()) {
            this.trackSession((Long)entry.getKey(), (Integer)entry.getValue());
        }
        EphemeralType.validateServerId(l2);
    }

    @Override
    public void dumpSessions(PrintWriter printWriter) {
        printWriter.print("Session ");
        this.sessionExpiryQueue.dump(printWriter);
    }

    @Override
    public synchronized Map<Long, Set<Long>> getSessionExpiryMap() {
        Map<Long, Set<SessionImpl>> map = this.sessionExpiryQueue.getExpiryMap();
        TreeMap<Long, Set<Long>> treeMap = new TreeMap<Long, Set<Long>>();
        for (Map.Entry<Long, Set<SessionImpl>> entry : map.entrySet()) {
            HashSet<Long> hashSet = new HashSet<Long>();
            treeMap.put(entry.getKey(), hashSet);
            for (SessionImpl sessionImpl : entry.getValue()) {
                hashSet.add(sessionImpl.sessionId);
            }
        }
        return treeMap;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dumpSessions(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                long l2 = this.sessionExpiryQueue.getWaitTime();
                if (l2 > 0L) {
                    Thread.sleep(l2);
                    continue;
                }
                for (SessionImpl sessionImpl : this.sessionExpiryQueue.poll()) {
                    ServerMetrics.getMetrics().STALE_SESSIONS_EXPIRED.add(1L);
                    this.setSessionClosing(sessionImpl.sessionId);
                    this.expirer.expire(sessionImpl);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.handleException(this.getName(), interruptedException);
        }
        LOG.c("SessionTrackerImpl exited loop!");
    }

    @Override
    public synchronized boolean touchSession(long l2, int n2) {
        SessionImpl sessionImpl = this.sessionsById.get(l2);
        if (sessionImpl == null) {
            this.logTraceTouchInvalidSession(l2, n2);
            return false;
        }
        if (sessionImpl.isClosing()) {
            this.logTraceTouchClosingSession(l2, n2);
            return false;
        }
        this.updateSessionExpiry(sessionImpl, n2);
        return true;
    }

    private void updateSessionExpiry(SessionImpl sessionImpl, int n2) {
        this.logTraceTouchSession(sessionImpl.sessionId, n2, "");
        this.sessionExpiryQueue.update(sessionImpl, n2);
    }

    private void logTraceTouchSession(long l2, int n2, String string) {
        if (LOG.b()) {
            String string2 = MessageFormat.format("SessionTrackerImpl --- Touch {0}session: 0x{1} with timeout {2}", string, Long.toHexString(l2), Integer.toString(n2));
            ZooTrace.logTraceMessage(LOG, 8L, string2);
        }
    }

    private void logTraceTouchInvalidSession(long l2, int n2) {
        this.logTraceTouchSession(l2, n2, "invalid ");
    }

    private void logTraceTouchClosingSession(long l2, int n2) {
        this.logTraceTouchSession(l2, n2, "closing ");
    }

    public int getSessionTimeout(long l2) {
        return (Integer)this.sessionsWithTimeout.get(l2);
    }

    @Override
    public synchronized void setSessionClosing(long l2) {
        SessionImpl sessionImpl;
        if (LOG.b()) {
            LOG.a("Session closing: 0x{}", (Object)Long.toHexString(l2));
        }
        if ((sessionImpl = this.sessionsById.get(l2)) == null) {
            return;
        }
        sessionImpl.isClosing = true;
    }

    @Override
    public synchronized void removeSession(long l2) {
        LOG.b("Removing session 0x{}", (Object)Long.toHexString(l2));
        SessionImpl sessionImpl = this.sessionsById.remove(l2);
        this.sessionsWithTimeout.remove(l2);
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Removing session 0x" + Long.toHexString(l2));
        }
        if (sessionImpl != null) {
            this.sessionExpiryQueue.remove(sessionImpl);
        }
    }

    @Override
    public void shutdown() {
        LOG.c("Shutting down");
        this.running = false;
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "Shutdown SessionTrackerImpl!");
        }
    }

    @Override
    public long createSession(int n2) {
        long l2 = this.nextSessionId.getAndIncrement();
        this.trackSession(l2, n2);
        return l2;
    }

    @Override
    public synchronized boolean trackSession(long l2, int n2) {
        SessionImpl sessionImpl;
        boolean bl2 = false;
        SessionImpl sessionImpl2 = this.sessionsById.get(l2);
        if (sessionImpl2 == null) {
            sessionImpl2 = new SessionImpl(l2, n2);
        }
        if ((sessionImpl = this.sessionsById.putIfAbsent(l2, sessionImpl2)) != null) {
            sessionImpl2 = sessionImpl;
        } else {
            bl2 = true;
            LOG.b("Adding session 0x{}", (Object)Long.toHexString(l2));
        }
        if (LOG.b()) {
            String string = bl2 ? "Adding" : "Existing";
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- " + string + " session 0x" + Long.toHexString(l2) + " " + n2);
        }
        this.updateSessionExpiry(sessionImpl2, n2);
        return bl2;
    }

    @Override
    public synchronized boolean commitSession(long l2, int n2) {
        return this.sessionsWithTimeout.put(l2, n2) == null;
    }

    @Override
    public boolean isTrackingSession(long l2) {
        return this.sessionsById.containsKey(l2);
    }

    @Override
    public synchronized void checkSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException, KeeperException.UnknownSessionException {
        LOG.b("Checking session 0x{}", (Object)Long.toHexString(l2));
        SessionImpl sessionImpl = this.sessionsById.get(l2);
        if (sessionImpl == null) {
            throw new KeeperException.UnknownSessionException();
        }
        if (sessionImpl.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        if (sessionImpl.owner == null) {
            sessionImpl.owner = object;
        } else if (sessionImpl.owner != object) {
            throw new KeeperException.SessionMovedException();
        }
    }

    @Override
    public synchronized void setOwner(long l2, Object object) throws KeeperException.SessionExpiredException {
        SessionImpl sessionImpl = this.sessionsById.get(l2);
        if (sessionImpl == null || sessionImpl.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        sessionImpl.owner = object;
    }

    @Override
    public void checkGlobalSession(long l2, Object object) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        try {
            this.checkSession(l2, object);
        }
        catch (KeeperException.UnknownSessionException unknownSessionException) {
            throw new KeeperException.SessionExpiredException();
        }
    }

    @Override
    public long getLocalSessionCount() {
        return 0L;
    }

    @Override
    public boolean isLocalSessionsEnabled() {
        return false;
    }

    @Override
    public Set<Long> globalSessions() {
        return this.sessionsById.keySet();
    }

    @Override
    public Set<Long> localSessions() {
        return Collections.emptySet();
    }

    public static class SessionImpl
    implements SessionTracker.Session {
        final long sessionId;
        final int timeout;
        boolean isClosing;
        Object owner;

        SessionImpl(long l2, int n2) {
            this.sessionId = l2;
            this.timeout = n2;
            this.isClosing = false;
        }

        @Override
        public long getSessionId() {
            return this.sessionId;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public boolean isClosing() {
            return this.isClosing;
        }

        public String toString() {
            return "0x" + Long.toHexString(this.sessionId);
        }
    }
}

