/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.impl.DefaultMetricsProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Properties;

public class ServerConfig {
    protected InetSocketAddress clientPortAddress;
    protected InetSocketAddress secureClientPortAddress;
    protected File dataDir;
    protected File dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected String metricsProviderClassName = DefaultMetricsProvider.class.getName();
    protected Properties metricsProviderConfiguration = new Properties();
    protected int listenBacklog = -1;
    protected String initialConfig;
    protected boolean jvmPauseMonitorToRun = false;
    protected long jvmPauseWarnThresholdMs;
    protected long jvmPauseInfoThresholdMs;
    protected long jvmPauseSleepTimeMs;

    public void parse(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 4) {
            throw new IllegalArgumentException("Invalid number of arguments:" + Arrays.toString(stringArray));
        }
        this.clientPortAddress = new InetSocketAddress(Integer.parseInt(stringArray[0]));
        this.dataLogDir = this.dataDir = new File(stringArray[1]);
        if (stringArray.length >= 3) {
            this.tickTime = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length == 4) {
            this.maxClientCnxns = Integer.parseInt(stringArray[3]);
        }
    }

    public void parse(String string) throws QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        quorumPeerConfig.parse(string);
        this.readFrom(quorumPeerConfig);
    }

    public void readFrom(QuorumPeerConfig quorumPeerConfig) {
        this.clientPortAddress = quorumPeerConfig.getClientPortAddress();
        this.secureClientPortAddress = quorumPeerConfig.getSecureClientPortAddress();
        this.dataDir = quorumPeerConfig.getDataDir();
        this.dataLogDir = quorumPeerConfig.getDataLogDir();
        this.tickTime = quorumPeerConfig.getTickTime();
        this.maxClientCnxns = quorumPeerConfig.getMaxClientCnxns();
        this.minSessionTimeout = quorumPeerConfig.getMinSessionTimeout();
        this.maxSessionTimeout = quorumPeerConfig.getMaxSessionTimeout();
        this.jvmPauseMonitorToRun = quorumPeerConfig.isJvmPauseMonitorToRun();
        this.jvmPauseInfoThresholdMs = quorumPeerConfig.getJvmPauseInfoThresholdMs();
        this.jvmPauseWarnThresholdMs = quorumPeerConfig.getJvmPauseWarnThresholdMs();
        this.jvmPauseSleepTimeMs = quorumPeerConfig.getJvmPauseSleepTimeMs();
        this.metricsProviderClassName = quorumPeerConfig.getMetricsProviderClassName();
        this.metricsProviderConfiguration = quorumPeerConfig.getMetricsProviderConfiguration();
        this.listenBacklog = quorumPeerConfig.getClientPortListenBacklog();
        this.initialConfig = quorumPeerConfig.getInitialConfig();
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public InetSocketAddress getSecureClientPortAddress() {
        return this.secureClientPortAddress;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public long getJvmPauseInfoThresholdMs() {
        return this.jvmPauseInfoThresholdMs;
    }

    public long getJvmPauseWarnThresholdMs() {
        return this.jvmPauseWarnThresholdMs;
    }

    public long getJvmPauseSleepTimeMs() {
        return this.jvmPauseSleepTimeMs;
    }

    public boolean isJvmPauseMonitorToRun() {
        return this.jvmPauseMonitorToRun;
    }

    public String getMetricsProviderClassName() {
        return this.metricsProviderClassName;
    }

    public Properties getMetricsProviderConfiguration() {
        return this.metricsProviderConfiguration;
    }

    public int getClientPortListenBacklog() {
        return this.listenBacklog;
    }
}

