/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Login;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ConnectionBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NIOServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.SaslServerCallbackHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;

public abstract class ServerCnxnFactory {
    public static final String ZOOKEEPER_SERVER_CNXN_FACTORY = "zookeeper.serverCnxnFactory";
    private static final String ZOOKEEPER_MAX_CONNECTION = "zookeeper.maxCnxns";
    public static final int ZOOKEEPER_MAX_CONNECTION_DEFAULT = 0;
    private static final foe LOG = goe.a(ServerCnxnFactory.class);
    protected boolean secure;
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    protected int maxCnxns;
    final ConcurrentHashMap<Long, ServerCnxn> sessionMap = new ConcurrentHashMap();
    private static String loginUser = Login.SYSTEM_USER;
    protected SaslServerCallbackHandler saslServerCallbackHandler;
    public Login login;
    public ZooKeeperServer zkServer;
    private final ConcurrentHashMap<ServerCnxn, ConnectionBean> connectionBeans = new ConcurrentHashMap();
    protected final Set<ServerCnxn> cnxns = Collections.newSetFromMap(new ConcurrentHashMap());

    public void addSession(long l2, ServerCnxn serverCnxn) {
        this.sessionMap.put(l2, serverCnxn);
    }

    public void removeCnxnFromSessionMap(ServerCnxn serverCnxn) {
        long l2 = serverCnxn.getSessionId();
        if (l2 != 0L) {
            this.sessionMap.remove(l2);
        }
    }

    public boolean closeSession(long l2, ServerCnxn.DisconnectReason disconnectReason) {
        ServerCnxn serverCnxn = this.sessionMap.remove(l2);
        if (serverCnxn != null) {
            try {
                serverCnxn.close(disconnectReason);
            }
            catch (Exception exception) {
                LOG.c("exception during session close", exception);
            }
            return true;
        }
        return false;
    }

    public abstract int getLocalPort();

    public abstract Iterable<ServerCnxn> getConnections();

    public int getNumAliveConnections() {
        return this.cnxns.size();
    }

    public final ZooKeeperServer getZooKeeperServer() {
        return this.zkServer;
    }

    public void configure(InetSocketAddress inetSocketAddress, int n2) throws IOException {
        this.configure(inetSocketAddress, n2, -1);
    }

    public void configure(InetSocketAddress inetSocketAddress, int n2, int n3) throws IOException {
        this.configure(inetSocketAddress, n2, n3, false);
    }

    public abstract void configure(InetSocketAddress var1, int var2, int var3, boolean var4) throws IOException;

    public abstract void reconfigure(InetSocketAddress var1);

    public abstract int getMaxClientCnxnsPerHost();

    public abstract void setMaxClientCnxnsPerHost(int var1);

    public boolean isSecure() {
        return this.secure;
    }

    public void startup(ZooKeeperServer zooKeeperServer) throws IOException, InterruptedException {
        this.startup(zooKeeperServer, true);
    }

    public abstract void startup(ZooKeeperServer var1, boolean var2) throws IOException, InterruptedException;

    public abstract int getSocketListenBacklog();

    public abstract void join() throws InterruptedException;

    public abstract void shutdown();

    public abstract void start();

    public final void setZooKeeperServer(ZooKeeperServer zooKeeperServer) {
        this.zkServer = zooKeeperServer;
        if (zooKeeperServer != null) {
            if (this.secure) {
                zooKeeperServer.setSecureServerCnxnFactory(this);
            } else {
                zooKeeperServer.setServerCnxnFactory(this);
            }
        }
    }

    public abstract void closeAll(ServerCnxn.DisconnectReason var1);

    public static ServerCnxnFactory createFactory() throws IOException {
        String string = System.getProperty(ZOOKEEPER_SERVER_CNXN_FACTORY);
        if (string == null) {
            string = NIOServerCnxnFactory.class.getName();
        }
        try {
            ServerCnxnFactory serverCnxnFactory = (ServerCnxnFactory)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOG.c("Using {} as server connection factory", (Object)string);
            return serverCnxnFactory;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Couldn't instantiate " + string, exception);
            throw iOException;
        }
    }

    public static ServerCnxnFactory createFactory(int n2, int n3) throws IOException {
        return ServerCnxnFactory.createFactory(new InetSocketAddress(n2), n3, -1);
    }

    public static ServerCnxnFactory createFactory(int n2, int n3, int n4) throws IOException {
        return ServerCnxnFactory.createFactory(new InetSocketAddress(n2), n3, n4);
    }

    public static ServerCnxnFactory createFactory(InetSocketAddress inetSocketAddress, int n2) throws IOException {
        return ServerCnxnFactory.createFactory(inetSocketAddress, n2, -1);
    }

    public static ServerCnxnFactory createFactory(InetSocketAddress inetSocketAddress, int n2, int n3) throws IOException {
        ServerCnxnFactory serverCnxnFactory = ServerCnxnFactory.createFactory();
        serverCnxnFactory.configure(inetSocketAddress, n2, n3);
        return serverCnxnFactory;
    }

    public abstract InetSocketAddress getLocalAddress();

    public abstract void resetAllConnectionStats();

    public abstract Iterable<Map<String, Object>> getAllConnectionInfo(boolean var1);

    public void unregisterConnection(ServerCnxn serverCnxn) {
        ConnectionBean connectionBean = this.connectionBeans.remove(serverCnxn);
        if (connectionBean != null) {
            MBeanRegistry.getInstance().unregister(connectionBean);
        }
    }

    public void registerConnection(ServerCnxn serverCnxn) {
        if (this.zkServer != null) {
            ConnectionBean connectionBean = new ConnectionBean(serverCnxn, this.zkServer);
            try {
                MBeanRegistry.getInstance().register(connectionBean, this.zkServer.jmxServerBean);
                this.connectionBeans.put(serverCnxn, connectionBean);
            }
            catch (JMException jMException) {
                LOG.c("Could not register connection", jMException);
            }
        }
    }

    protected void configureSaslLogin() throws IOException {
        String string = System.getProperty("zookeeper.sasl.serverconfig", "Server");
        AppConfigurationEntry[] appConfigurationEntryArray = null;
        SecurityException securityException = null;
        try {
            appConfigurationEntryArray = Configuration.getConfiguration().getAppConfigurationEntry(string);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
        }
        if (appConfigurationEntryArray == null) {
            String string2 = System.getProperty("java.security.auth.login.config");
            String string3 = System.getProperty("zookeeper.sasl.serverconfig");
            if (securityException != null && (string3 != null || string2 != null)) {
                String string4 = "No JAAS configuration section named '" + string + "' was found";
                if (string2 != null) {
                    string4 = string4 + " in '" + string2 + "'.";
                }
                if (string3 != null) {
                    string4 = string4 + " But zookeeper.sasl.serverconfig was set.";
                }
                LOG.e(string4);
                throw new IOException(string4);
            }
            return;
        }
        try {
            this.saslServerCallbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration());
            this.login = new Login(string, this.saslServerCallbackHandler, new ZKConfig());
            ServerCnxnFactory.setLoginUser(this.login.getUserName());
            this.login.startThreadIfNeeded();
        }
        catch (LoginException loginException) {
            throw new IOException("Could not configure server because SASL configuration did not allow the  ZooKeeper server to authenticate itself properly: " + loginException);
        }
    }

    private static void setLoginUser(String string) {
        loginUser = string;
    }

    public static String getUserName() {
        return loginUser;
    }

    public int getMaxCnxns() {
        return this.maxCnxns;
    }

    protected void initMaxCnxns() {
        this.maxCnxns = Integer.getInteger(ZOOKEEPER_MAX_CONNECTION, 0);
        if (this.maxCnxns < 0) {
            this.maxCnxns = 0;
            LOG.d("maxCnxns should be greater than or equal to 0, using default value {}.", (Object)0);
        } else if (this.maxCnxns == 0) {
            LOG.d("maxCnxns is not configured, using default value {}.", (Object)0);
        } else {
            LOG.c("maxCnxns configured value is {}.", (Object)this.maxCnxns);
        }
    }

    protected boolean limitTotalNumberOfCnxns() {
        if (this.maxCnxns <= 0) {
            return false;
        }
        int n2 = this.getNumAliveConnections();
        if (n2 >= this.maxCnxns) {
            LOG.e("Too many connections " + n2 + " - max is " + this.maxCnxns);
            return true;
        }
        return false;
    }
}

