/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.compat.ProtocolManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Counter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RequestHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ResponseCache;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerStats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerWatcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Stats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperSaslServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ServerCnxn
implements ServerWatcher,
Stats {
    public static final Object me = new Object();
    private static final foe LOG = goe.a(ServerCnxn.class);
    public final ProtocolManager protocolManager = new ProtocolManager();
    private final Set<Id> authInfo = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong outstandingCount = new AtomicLong();
    final ZooKeeperServer zkServer;
    private volatile boolean stale = false;
    private volatile boolean invalid = false;
    protected ZooKeeperSaslServer zooKeeperSaslServer = null;
    protected final Date established = new Date();
    protected final AtomicLong packetsReceived = new AtomicLong();
    protected final AtomicLong packetsSent = new AtomicLong();
    protected long minLatency;
    protected long maxLatency;
    protected String lastOp;
    protected long lastCxid;
    protected long lastZxid;
    protected long lastResponseTime;
    protected long lastLatency;
    protected long count;
    protected long totalLatency;
    protected DisconnectReason disconnectReason = DisconnectReason.UNKNOWN;

    public ServerCnxn(ZooKeeperServer zooKeeperServer) {
        this.zkServer = zooKeeperServer;
    }

    abstract int getSessionTimeout();

    public void incrOutstandingAndCheckThrottle(RequestHeader requestHeader) {
        if (requestHeader.getXid() <= 0) {
            return;
        }
        if (this.zkServer.shouldThrottle(this.outstandingCount.incrementAndGet())) {
            this.disableRecv(false);
        }
    }

    public void decrOutstandingAndCheckThrottle(ReplyHeader replyHeader) {
        if (replyHeader.getXid() <= 0) {
            return;
        }
        if (!this.zkServer.shouldThrottle(this.outstandingCount.decrementAndGet())) {
            this.enableRecv();
        }
    }

    public abstract void close(DisconnectReason var1);

    public abstract int sendResponse(ReplyHeader var1, mme var2, String var3, String var4, Stat var5, int var6) throws IOException;

    public int sendResponse(ReplyHeader replyHeader, mme mme2, String string) throws IOException {
        return this.sendResponse(replyHeader, mme2, string, null, null, -1);
    }

    protected byte[] serializeRecord(mme mme2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(ZooKeeperServer.intBufferStartingSizeBytes);
        ime ime2 = ime.a(byteArrayOutputStream);
        ime2.a(mme2, null);
        return byteArrayOutputStream.toByteArray();
    }

    protected ByteBuffer[] serialize(ReplyHeader replyHeader, mme mme2, String string, String string2, Stat stat, int n2) throws IOException {
        Object object;
        byte[] byArray = this.serializeRecord(replyHeader);
        byte[] byArray2 = null;
        if (mme2 != null) {
            ResponseCache responseCache = null;
            Counter counter = null;
            object = null;
            switch (n2) {
                case 4: {
                    responseCache = this.zkServer.getReadResponseCache();
                    counter = ServerMetrics.getMetrics().RESPONSE_PACKET_CACHE_HITS;
                    object = ServerMetrics.getMetrics().RESPONSE_PACKET_CACHE_MISSING;
                    break;
                }
                case 12: {
                    responseCache = this.zkServer.getGetChildrenResponseCache();
                    counter = ServerMetrics.getMetrics().RESPONSE_PACKET_GET_CHILDREN_CACHE_HITS;
                    object = ServerMetrics.getMetrics().RESPONSE_PACKET_GET_CHILDREN_CACHE_MISSING;
                    break;
                }
            }
            if (responseCache != null && stat != null && string2 != null && !string2.endsWith("zookeeper_stats")) {
                byArray2 = responseCache.get(string2, stat);
                if (byArray2 == null) {
                    byArray2 = this.serializeRecord(mme2);
                    responseCache.put(string2, byArray2, stat);
                    object.add(1L);
                } else {
                    counter.add(1L);
                }
            } else {
                byArray2 = this.serializeRecord(mme2);
            }
        }
        int n3 = byArray2 == null ? 0 : byArray2.length;
        int n4 = byArray.length + n3;
        object = this.serverStats();
        if (object != null) {
            ((ServerStats)object).updateClientResponseSize(n4);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).putInt(n4);
        byteBuffer.rewind();
        int n5 = byArray2 != null ? 3 : 2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n5];
        byteBufferArray[0] = byteBuffer;
        byteBufferArray[1] = ByteBuffer.wrap(byArray);
        if (byArray2 != null) {
            byteBufferArray[2] = ByteBuffer.wrap(byArray2);
        }
        return byteBufferArray;
    }

    public abstract void sendCloseSession();

    @Override
    public void process(WatchedEvent watchedEvent) {
        this.process(watchedEvent, null);
    }

    @Override
    public abstract void process(WatchedEvent var1, List<ACL> var2);

    public abstract long getSessionId();

    abstract void setSessionId(long var1);

    public List<Id> getAuthInfo() {
        return Collections.unmodifiableList(new ArrayList<Id>(this.authInfo));
    }

    public void addAuthInfo(Id id2) {
        this.authInfo.add(id2);
    }

    public boolean removeAuthInfo(Id id2) {
        return this.authInfo.remove(id2);
    }

    abstract void sendBuffer(ByteBuffer ... var1);

    abstract void enableRecv();

    void disableRecv() {
        this.disableRecv(true);
    }

    abstract void disableRecv(boolean var1);

    abstract void setSessionTimeout(int var1);

    public boolean isStale() {
        return this.stale;
    }

    public void setStale() {
        this.stale = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid() {
        if (!this.invalid) {
            if (!this.stale) {
                this.sendCloseSession();
            }
            this.invalid = true;
        }
    }

    protected void packetReceived(long l2) {
        this.incrPacketsReceived();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            this.serverStats().incrementPacketsReceived();
        }
        ServerMetrics.getMetrics().BYTES_RECEIVED_COUNT.add(l2);
    }

    protected void packetSent() {
        this.incrPacketsSent();
        ServerStats serverStats = this.serverStats();
        if (serverStats != null) {
            serverStats.incrementPacketsSent();
        }
    }

    protected abstract ServerStats serverStats();

    @Override
    public synchronized void resetStats() {
        this.disconnectReason = DisconnectReason.RESET_COMMAND;
        this.packetsReceived.set(0L);
        this.packetsSent.set(0L);
        this.minLatency = Long.MAX_VALUE;
        this.maxLatency = 0L;
        this.lastOp = "NA";
        this.lastCxid = -1L;
        this.lastZxid = -1L;
        this.lastResponseTime = 0L;
        this.lastLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
    }

    protected long incrPacketsReceived() {
        return this.packetsReceived.incrementAndGet();
    }

    protected long incrPacketsSent() {
        return this.packetsSent.incrementAndGet();
    }

    protected synchronized void updateStatsForResponse(long l2, long l3, String string, long l4, long l5) {
        long l6;
        if (l2 >= 0L) {
            this.lastCxid = l2;
        }
        this.lastZxid = l3;
        this.lastOp = string;
        this.lastResponseTime = l5;
        this.lastLatency = l6 = l5 - l4;
        if (l6 < this.minLatency) {
            this.minLatency = l6;
        }
        if (l6 > this.maxLatency) {
            this.maxLatency = l6;
        }
        ++this.count;
        this.totalLatency += l6;
    }

    @Override
    public Date getEstablished() {
        return (Date)this.established.clone();
    }

    @Override
    public long getOutstandingRequests() {
        return this.outstandingCount.longValue();
    }

    @Override
    public long getPacketsReceived() {
        return this.packetsReceived.longValue();
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent.longValue();
    }

    @Override
    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    @Override
    public synchronized long getAvgLatency() {
        return this.count == 0L ? 0L : this.totalLatency / this.count;
    }

    @Override
    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    @Override
    public synchronized String getLastOperation() {
        return this.lastOp;
    }

    @Override
    public synchronized long getLastCxid() {
        return this.lastCxid;
    }

    @Override
    public synchronized long getLastZxid() {
        return this.lastZxid;
    }

    @Override
    public synchronized long getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Override
    public synchronized long getLastLatency() {
        return this.lastLatency;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dumpConnectionInfo(printWriter, false);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    public abstract InetSocketAddress getRemoteSocketAddress();

    public abstract int getInterestOps();

    public abstract boolean isSecure();

    public abstract Certificate[] getClientCertificateChain();

    public abstract void setClientCertificateChain(Certificate[] var1);

    public synchronized void dumpConnectionInfo(PrintWriter printWriter, boolean bl2) {
        long l2;
        printWriter.print(" ");
        printWriter.print(this.getRemoteSocketAddress());
        printWriter.print("[");
        int n2 = this.getInterestOps();
        printWriter.print(n2 == 0 ? "0" : Integer.toHexString(n2));
        printWriter.print("](queued=");
        printWriter.print(this.getOutstandingRequests());
        printWriter.print(",recved=");
        printWriter.print(this.getPacketsReceived());
        printWriter.print(",sent=");
        printWriter.print(this.getPacketsSent());
        if (!bl2 && (l2 = this.getSessionId()) != 0L) {
            printWriter.print(",sid=0x");
            printWriter.print(Long.toHexString(l2));
            printWriter.print(",lop=");
            printWriter.print(this.getLastOperation());
            printWriter.print(",est=");
            printWriter.print(this.getEstablished().getTime());
            printWriter.print(",to=");
            printWriter.print(this.getSessionTimeout());
            long l3 = this.getLastCxid();
            if (l3 >= 0L) {
                printWriter.print(",lcxid=0x");
                printWriter.print(Long.toHexString(l3));
            }
            printWriter.print(",lzxid=0x");
            printWriter.print(Long.toHexString(this.getLastZxid()));
            printWriter.print(",lresp=");
            printWriter.print(this.getLastResponseTime());
            printWriter.print(",llat=");
            printWriter.print(this.getLastLatency());
            printWriter.print(",minlat=");
            printWriter.print(this.getMinLatency());
            printWriter.print(",avglat=");
            printWriter.print(this.getAvgLatency());
            printWriter.print(",maxlat=");
            printWriter.print(this.getMaxLatency());
        }
        printWriter.print(")");
    }

    public synchronized Map<String, Object> getConnectionInfo(boolean bl2) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("remote_socket_address", this.getRemoteSocketAddress());
        linkedHashMap.put("interest_ops", this.getInterestOps());
        linkedHashMap.put("outstanding_requests", this.getOutstandingRequests());
        linkedHashMap.put("packets_received", this.getPacketsReceived());
        linkedHashMap.put("packets_sent", this.getPacketsSent());
        if (!bl2) {
            linkedHashMap.put("session_id", this.getSessionId());
            linkedHashMap.put("last_operation", this.getLastOperation());
            linkedHashMap.put("established", this.getEstablished());
            linkedHashMap.put("session_timeout", this.getSessionTimeout());
            linkedHashMap.put("last_cxid", this.getLastCxid());
            linkedHashMap.put("last_zxid", this.getLastZxid());
            linkedHashMap.put("last_response_time", this.getLastResponseTime());
            linkedHashMap.put("last_latency", this.getLastLatency());
            linkedHashMap.put("min_latency", this.getMinLatency());
            linkedHashMap.put("avg_latency", this.getAvgLatency());
            linkedHashMap.put("max_latency", this.getMaxLatency());
        }
        return linkedHashMap;
    }

    public void cleanupWriterSocket(PrintWriter printWriter) {
        try {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception exception) {
            LOG.b("Error closing PrintWriter ", exception);
        }
        finally {
            try {
                this.close(DisconnectReason.CLOSE_CONNECTION_COMMAND);
            }
            catch (Exception exception) {
                LOG.d("Error closing a command socket ", exception);
            }
        }
    }

    public boolean isZKServerRunning() {
        return this.zkServer != null && this.zkServer.isRunning();
    }

    public String getHostAddress() {
        InetSocketAddress inetSocketAddress = this.getRemoteSocketAddress();
        if (inetSocketAddress == null) {
            return "";
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return "";
        }
        return inetAddress.getHostAddress();
    }

    public String getSessionIdHex() {
        return "0x" + Long.toHexString(this.getSessionId());
    }

    public static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -8255690282104294178L;
        private DisconnectReason reason;

        public EndOfStreamException(String string, DisconnectReason disconnectReason) {
            super(string);
            this.reason = disconnectReason;
        }

        @Override
        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }

        public DisconnectReason getReason() {
            return this.reason;
        }
    }

    public static class CloseRequestException
    extends IOException {
        private static final long serialVersionUID = -7854505709816442681L;
        private DisconnectReason reason;

        public CloseRequestException(String string, DisconnectReason disconnectReason) {
            super(string);
            this.reason = disconnectReason;
        }

        public DisconnectReason getReason() {
            return this.reason;
        }
    }

    public static enum DisconnectReason {
        UNKNOWN("unknown"),
        SERVER_SHUTDOWN("server_shutdown"),
        CLOSE_ALL_CONNECTIONS_FORCED("close_all_connections_forced"),
        CONNECTION_CLOSE_FORCED("connection_close_forced"),
        CONNECTION_EXPIRED("connection_expired"),
        CLIENT_CLOSED_CONNECTION("client_closed_connection"),
        CLIENT_CLOSED_SESSION("client_closed_session"),
        UNABLE_TO_READ_FROM_CLIENT("unable_to_read_from_client"),
        NOT_READ_ONLY_CLIENT("not_read_only_client"),
        CLIENT_ZXID_AHEAD("client_zxid_ahead"),
        INFO_PROBE("info_probe"),
        CLIENT_RECONNECT("client_reconnect"),
        CANCELLED_KEY_EXCEPTION("cancelled_key_exception"),
        IO_EXCEPTION("io_exception"),
        IO_EXCEPTION_IN_SESSION_INIT("io_exception_in_session_init"),
        BUFFER_UNDERFLOW_EXCEPTION("buffer_underflow_exception"),
        SASL_AUTH_FAILURE("sasl_auth_failure"),
        RESET_COMMAND("reset_command"),
        CLOSE_CONNECTION_COMMAND("close_connection_command"),
        CLEAN_UP("clean_up"),
        CONNECTION_MODE_CHANGED("connection_mode_changed"),
        RENEW_GLOBAL_SESSION_IN_RO_MODE("renew a global session in readonly mode"),
        CHANNEL_DISCONNECTED("channel disconnected"),
        CHANNEL_CLOSED_EXCEPTION("channel_closed_exception"),
        AUTH_PROVIDER_NOT_FOUND("auth provider not found"),
        FAILED_HANDSHAKE("Unsuccessful handshake"),
        CLIENT_RATE_LIMIT("Client hits rate limiting threshold"),
        CLIENT_CNX_LIMIT("Client hits connection limiting threshold");

        String disconnectReason;

        private DisconnectReason(String string2) {
            this.disconnectReason = string2;
        }

        public String toDisconnectReasonString() {
            return this.disconnectReason;
        }
    }
}

