/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.Summary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.metrics.SummarySet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.persistence.Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LearnerHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.AuthUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;

public class Request {
    private static final foe LOG = goe.a(Request.class);
    public static final Request requestOfDeath = new Request(null, 0L, 0, 0, null, null);
    private static volatile boolean staleConnectionCheck = Boolean.parseBoolean(System.getProperty("zookeeper.request_stale_connection_check", "true"));
    private static volatile boolean staleLatencyCheck = Boolean.parseBoolean(System.getProperty("zookeeper.request_stale_latency_check", "false"));
    public final long sessionId;
    public final int cxid;
    public final int type;
    private final RequestRecord request;
    public final ServerCnxn cnxn;
    private TxnHeader hdr;
    private mme txn;
    public long zxid = -1L;
    public final List<Id> authInfo;
    public final long createTime = Time.currentElapsedTime();
    public long prepQueueStartTime = -1L;
    public long prepStartTime = -1L;
    public long commitProcQueueStartTime = -1L;
    public long commitRecvTime = -1L;
    public long syncQueueStartTime;
    public long requestThrottleQueueTime;
    private Object owner;
    private KeeperException e;
    public QuorumVerifier qv = null;
    private TxnDigest txnDigest;
    private boolean isThrottledFlag = false;
    private boolean isLocalSession = false;
    private int largeRequestSize = -1;

    public Request(ServerCnxn serverCnxn, long l2, int n2, int n3, RequestRecord requestRecord, List<Id> list) {
        this.cnxn = serverCnxn;
        this.sessionId = l2;
        this.cxid = n2;
        this.type = n3;
        this.request = requestRecord;
        this.authInfo = list;
    }

    public Request(long l2, int n2, int n3, TxnHeader txnHeader, mme mme2, long l3) {
        this.sessionId = l2;
        this.cxid = n2;
        this.type = n3;
        this.hdr = txnHeader;
        this.txn = mme2;
        this.zxid = l3;
        this.request = null;
        this.cnxn = null;
        this.authInfo = null;
    }

    public <T extends mme> T readRequestRecord(Supplier<T> supplier) throws IOException {
        if (this.request != null) {
            return this.request.readRecord(supplier);
        }
        throw new IOException(new NullPointerException("request"));
    }

    public <T extends mme> T readRequestRecordNoException(Supplier<T> supplier) {
        try {
            return this.readRequestRecord(supplier);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] readRequestBytes() {
        if (this.request != null) {
            return this.request.readBytes();
        }
        return null;
    }

    public String requestDigest() {
        if (this.request != null) {
            byte[] byArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by2 : byArray = this.request.readBytes()) {
                stringBuilder.append(String.format("%02x", 0xFF & by2));
            }
            return stringBuilder.toString();
        }
        return "request buffer is null";
    }

    public boolean isThrottled() {
        return this.isThrottledFlag;
    }

    public void setIsThrottled(boolean bl2) {
        this.isThrottledFlag = bl2;
    }

    public boolean isThrottlable() {
        return this.type != 11 && this.type != -11 && this.type != -10;
    }

    public byte[] getSerializeData() {
        if (this.hdr == null) {
            return null;
        }
        try {
            return Util.marshallTxnEntry(this.hdr, this.txn, this.txnDigest);
        }
        catch (IOException iOException) {
            LOG.d("This really should be impossible.", iOException);
            return new byte[32];
        }
    }

    public boolean isLocalSession() {
        return this.isLocalSession;
    }

    public void setLocalSession(boolean bl2) {
        this.isLocalSession = bl2;
    }

    public void setLargeRequestSize(int n2) {
        this.largeRequestSize = n2;
    }

    public int getLargeRequestSize() {
        return this.largeRequestSize;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public TxnHeader getHdr() {
        return this.hdr;
    }

    public void setHdr(TxnHeader txnHeader) {
        this.hdr = txnHeader;
    }

    public mme getTxn() {
        return this.txn;
    }

    public void setTxn(mme mme2) {
        this.txn = mme2;
    }

    public ServerCnxn getConnection() {
        return this.cnxn;
    }

    public static boolean getStaleLatencyCheck() {
        return staleLatencyCheck;
    }

    public static void setStaleLatencyCheck(boolean bl2) {
        staleLatencyCheck = bl2;
    }

    public static boolean getStaleConnectionCheck() {
        return staleConnectionCheck;
    }

    public static void setStaleConnectionCheck(boolean bl2) {
        staleConnectionCheck = bl2;
    }

    public boolean isStale() {
        if (this.cnxn == null) {
            return false;
        }
        if (this.type == -11) {
            return false;
        }
        if (staleConnectionCheck && (this.cnxn.isStale() || this.cnxn.isInvalid())) {
            return true;
        }
        if (staleLatencyCheck) {
            long l2 = Time.currentElapsedTime();
            return l2 - this.createTime > (long)this.cnxn.getSessionTimeout();
        }
        return false;
    }

    public boolean mustDrop() {
        return this.cnxn != null && this.cnxn.isInvalid();
    }

    static boolean isValid(int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
            case -11: 
            case -10: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    public boolean isQuorum() {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 22: 
            case 103: 
            case 104: 
            case 107: {
                return false;
            }
            case -1: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
            case -11: 
            case -10: {
                return !this.isLocalSession;
            }
        }
        return false;
    }

    public static String op2String(int n2) {
        switch (n2) {
            case 0: {
                return "notification";
            }
            case 1: {
                return "create";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "exists";
            }
            case 4: {
                return "getData";
            }
            case 5: {
                return "setData";
            }
            case 6: {
                return "getACL";
            }
            case 7: {
                return "setACL";
            }
            case 8: {
                return "getChildren";
            }
            case 9: {
                return "sync";
            }
            case 11: {
                return "ping";
            }
            case 12: {
                return "getChildren2";
            }
            case 13: {
                return "check";
            }
            case 14: {
                return "multi";
            }
            case 15: {
                return "create2";
            }
            case 16: {
                return "reconfig";
            }
            case 17: {
                return "checkWatches";
            }
            case 18: {
                return "removeWatches";
            }
            case 19: {
                return "createContainer";
            }
            case 20: {
                return "deleteContainer";
            }
            case 21: {
                return "createTTL";
            }
            case 22: {
                return "multiRead";
            }
            case 100: {
                return "auth";
            }
            case 101: {
                return "setWatches";
            }
            case 105: {
                return "setWatches2";
            }
            case 106: {
                return "addWatch";
            }
            case 102: {
                return "sasl";
            }
            case 103: {
                return "getEphemerals";
            }
            case 104: {
                return "getAllChildrenNumber";
            }
            case -10: {
                return "createSession";
            }
            case -11: {
                return "closeSession";
            }
            case -1: {
                return "error";
            }
            case 107: {
                return "whoAmI";
            }
        }
        return "unknown " + n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sessionid:0x").append(Long.toHexString(this.sessionId)).append(" type:").append(Request.op2String(this.type)).append(" cxid:0x").append(Long.toHexString(this.cxid)).append(" zxid:0x").append(Long.toHexString(this.hdr == null ? -2L : this.hdr.getZxid())).append(" txntype:").append(this.hdr == null ? "unknown" : "" + this.hdr.getType());
        String string = "n/a";
        if (this.type != -10 && this.type != 101 && this.type != 105 && this.type != -11 && this.request != null) {
            try {
                ByteBuffer byteBuffer;
                int n2;
                byte[] byArray = this.request.readBytes();
                if (byArray != null && byArray.length >= 4 && (n2 = (byteBuffer = ByteBuffer.wrap(byArray)).getInt()) >= 0 && n2 < 4096 && byteBuffer.remaining() >= n2) {
                    byte[] byArray2 = new byte[n2];
                    byteBuffer.get(byArray2);
                    string = new String(byArray2, StandardCharsets.UTF_8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuilder.append(" reqpath:").append(string);
        return stringBuilder.toString();
    }

    public void setException(KeeperException keeperException) {
        this.e = keeperException;
    }

    public KeeperException getException() {
        return this.e;
    }

    public void logLatency(Summary summary) {
        this.logLatency(summary, Time.currentWallTime());
    }

    public void logLatency(Summary summary, long l2) {
        long l3;
        if (this.hdr != null && (l3 = l2 - this.hdr.getTime()) >= 0L) {
            summary.add(l3);
        }
    }

    public void logLatency(SummarySet summarySet, String string, long l2) {
        long l3;
        if (this.hdr != null && (l3 = l2 - this.hdr.getTime()) >= 0L) {
            summarySet.add(string, l3);
        }
    }

    public void logLatency(SummarySet summarySet, String string) {
        this.logLatency(summarySet, string, Time.currentWallTime());
    }

    public String getUsersForAudit() {
        return AuthUtil.getUsers(this.authInfo);
    }

    public TxnDigest getTxnDigest() {
        return this.txnDigest;
    }

    public void setTxnDigest(TxnDigest txnDigest) {
        this.txnDigest = txnDigest;
    }

    public boolean isFromLearner() {
        return this.owner instanceof LearnerHandler;
    }
}

