/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.DeleteContainerRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiOperationRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.StringUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CheckVersionRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateTTLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReconfigRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DigestCalculator;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumOracleMaj;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CheckVersionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CloseSessionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateContainerTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateSessionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTTLTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.DeleteTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.ErrorTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.MultiTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetACLTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetDataTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.Txn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class PrepRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final foe LOG = goe.a(PrepRequestProcessor.class);
    private static boolean failCreate = false;
    LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    private final RequestProcessor nextProcessor;
    private final boolean digestEnabled;
    private DigestCalculator digestCalculator;
    ZooKeeperServer zks;

    public PrepRequestProcessor(ZooKeeperServer zooKeeperServer, RequestProcessor requestProcessor) {
        super("ProcessThread(sid:" + zooKeeperServer.getServerId() + " cport:" + zooKeeperServer.getClientPort() + "):", zooKeeperServer.getZooKeeperServerListener());
        this.nextProcessor = requestProcessor;
        this.zks = zooKeeperServer;
        this.digestEnabled = ZooKeeperServer.isDigestEnabled();
        if (this.digestEnabled) {
            this.digestCalculator = new DigestCalculator();
        }
    }

    public static void setFailCreate(boolean bl2) {
        failCreate = bl2;
    }

    @Override
    public void run() {
        LOG.c(String.format("PrepRequestProcessor (sid:%d) started, reconfigEnabled=%s", this.zks.getServerId(), this.zks.reconfigEnabled));
        try {
            while (true) {
                ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUE_SIZE.add(this.submittedRequests.size());
                Request request = this.submittedRequests.take();
                ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUE_TIME.add(Time.currentElapsedTime() - request.prepQueueStartTime);
                if (LOG.b()) {
                    long l2 = 2L;
                    if (request.type == 11) {
                        l2 = 8L;
                    }
                    ZooTrace.logRequest(LOG, l2, 'P', request, "");
                }
                if (Request.requestOfDeath != request) {
                    request.prepStartTime = Time.currentElapsedTime();
                    this.pRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.handleException(this.getName(), exception);
        }
        LOG.c("PrepRequestProcessor exited loop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getRecordForPath(String string) throws KeeperException.NoNodeException {
        ZooKeeperServer.ChangeRecord changeRecord = null;
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            DataNode dataNode;
            changeRecord = this.zks.outstandingChangesForPath.get(string);
            if (changeRecord == null && (dataNode = this.zks.getZKDatabase().getNode(string)) != null) {
                Set<String> set;
                DataNode dataNode2 = dataNode;
                synchronized (dataNode2) {
                    set = dataNode.getChildren();
                }
                changeRecord = new ZooKeeperServer.ChangeRecord(-1L, string, dataNode.stat, set.size(), this.zks.getZKDatabase().aclForNode(dataNode));
                if (this.digestEnabled) {
                    changeRecord.precalculatedDigest = new ZooKeeperServer.PrecalculatedDigest(this.digestCalculator.calculateDigest(string, dataNode), 0L);
                }
                changeRecord.data = dataNode.getData();
            }
        }
        if (changeRecord == null || changeRecord.stat == null) {
            throw new KeeperException.NoNodeException(string);
        }
        return changeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getOutstandingChange(String string) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            return this.zks.outstandingChangesForPath.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeRecord(ZooKeeperServer.ChangeRecord changeRecord) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            this.zks.outstandingChanges.add(changeRecord);
            this.zks.outstandingChangesForPath.put(changeRecord.path, changeRecord);
            ServerMetrics.getMetrics().OUTSTANDING_CHANGES_QUEUED.add(1L);
        }
    }

    private Map<String, ZooKeeperServer.ChangeRecord> getPendingChanges(MultiOperationRecord multiOperationRecord) {
        HashMap<String, ZooKeeperServer.ChangeRecord> hashMap = new HashMap<String, ZooKeeperServer.ChangeRecord>();
        for (Op op2 : multiOperationRecord) {
            String string;
            ZooKeeperServer.ChangeRecord changeRecord;
            int n2;
            String string2 = op2.getPath();
            ZooKeeperServer.ChangeRecord changeRecord2 = this.getOutstandingChange(string2);
            if (changeRecord2 != null) {
                hashMap.put(string2, changeRecord2);
            }
            if ((n2 = string2.lastIndexOf(47)) == -1 || string2.indexOf(0) != -1 || (changeRecord = this.getOutstandingChange(string = string2.substring(0, n2))) == null) continue;
            hashMap.put(string, changeRecord);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPendingChanges(long l2, Map<String, ZooKeeperServer.ChangeRecord> map) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            Iterator<ZooKeeperServer.ChangeRecord> iterator = this.zks.outstandingChanges.descendingIterator();
            while (iterator.hasNext()) {
                ZooKeeperServer.ChangeRecord changeRecord = iterator.next();
                if (changeRecord.zxid != l2) break;
                iterator.remove();
                this.zks.outstandingChangesForPath.remove(changeRecord.path);
            }
            if (this.zks.outstandingChanges.isEmpty()) {
                return;
            }
            long l3 = this.zks.outstandingChanges.peek().zxid;
            for (ZooKeeperServer.ChangeRecord changeRecord : map.values()) {
                if (changeRecord.zxid < l3) continue;
                this.zks.outstandingChangesForPath.put(changeRecord.path, changeRecord);
            }
        }
    }

    private String validatePathForCreate(String string, long l2) throws KeeperException.BadArgumentsException {
        int n2 = string.lastIndexOf(47);
        if (n2 == -1 || string.indexOf(0) != -1 || failCreate) {
            LOG.c("Invalid path {} with session 0x{}", (Object)string, (Object)Long.toHexString(l2));
            throw new KeeperException.BadArgumentsException(string);
        }
        return string.substring(0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pRequest2Txn(int n2, long l2, Request request, mme mme2) throws KeeperException, IOException, RequestProcessor.RequestProcessorException {
        if (request.getHdr() == null) {
            request.setHdr(new TxnHeader(request.sessionId, request.cxid, l2, Time.currentWallTime(), n2));
        }
        switch (n2) {
            case 1: 
            case 15: 
            case 19: 
            case 21: {
                this.pRequest2TxnCreate(n2, request, mme2);
                break;
            }
            case 20: {
                DeleteContainerRequest deleteContainerRequest = (DeleteContainerRequest)mme2;
                String string = deleteContainerRequest.getPath();
                String string2 = this.getParentPathAndValidate(string);
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string);
                if (changeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(string);
                }
                if (EphemeralType.get(changeRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL) {
                    throw new KeeperException.BadVersionException(string);
                }
                ZooKeeperServer.ChangeRecord changeRecord2 = this.getRecordForPath(string2);
                request.setTxn(new DeleteTxn(string));
                changeRecord2 = changeRecord2.duplicate(request.getHdr().getZxid());
                --changeRecord2.childCount;
                changeRecord2.stat.setPzxid(request.getHdr().getZxid());
                changeRecord2.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string2, changeRecord2.data, changeRecord2.stat);
                this.addChangeRecord(changeRecord2);
                changeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), string, null, -1, null);
                changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, string);
                this.setTxnDigest(request, changeRecord.precalculatedDigest);
                this.addChangeRecord(changeRecord);
                break;
            }
            case 2: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                DeleteRequest deleteRequest = (DeleteRequest)mme2;
                String string = deleteRequest.getPath();
                String string3 = this.getParentPathAndValidate(string);
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string3);
                this.zks.checkACL(request.cnxn, changeRecord.acl, 8, request.authInfo, string, null);
                ZooKeeperServer.ChangeRecord changeRecord3 = this.getRecordForPath(string);
                PrepRequestProcessor.checkAndIncVersion(changeRecord3.stat.getVersion(), deleteRequest.getVersion(), string);
                if (changeRecord3.childCount > 0) {
                    throw new KeeperException.NotEmptyException(string);
                }
                request.setTxn(new DeleteTxn(string));
                changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
                --changeRecord.childCount;
                changeRecord.stat.setPzxid(request.getHdr().getZxid());
                changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string3, changeRecord.data, changeRecord.stat);
                this.addChangeRecord(changeRecord);
                changeRecord3 = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), string, null, -1, null);
                changeRecord3.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, string);
                this.setTxnDigest(request, changeRecord3.precalculatedDigest);
                this.addChangeRecord(changeRecord3);
                break;
            }
            case 5: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetDataRequest setDataRequest = (SetDataRequest)mme2;
                String string = setDataRequest.getPath();
                this.validatePath(string, request.sessionId);
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string);
                this.zks.checkACL(request.cnxn, changeRecord.acl, 2, request.authInfo, string, null);
                this.zks.checkQuota(string, changeRecord.data, setDataRequest.getData(), 5);
                int n3 = PrepRequestProcessor.checkAndIncVersion(changeRecord.stat.getVersion(), setDataRequest.getVersion(), string);
                request.setTxn(new SetDataTxn(string, setDataRequest.getData(), n3));
                changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
                changeRecord.stat.setVersion(n3);
                changeRecord.stat.setMtime(request.getHdr().getTime());
                changeRecord.stat.setMzxid(l2);
                changeRecord.data = setDataRequest.getData();
                changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string, changeRecord.data, changeRecord.stat);
                this.setTxnDigest(request, changeRecord.precalculatedDigest);
                this.addChangeRecord(changeRecord);
                break;
            }
            case 16: {
                Object object;
                LeaderZooKeeperServer leaderZooKeeperServer;
                if (!this.zks.isReconfigEnabled()) {
                    LOG.e("Reconfig operation requested but reconfig feature is disabled.");
                    throw new KeeperException.ReconfigDisabledException();
                }
                if (ZooKeeperServer.skipACL) {
                    LOG.d("skipACL is set, reconfig operation will skip ACL checks!");
                }
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                try {
                    leaderZooKeeperServer = (LeaderZooKeeperServer)this.zks;
                }
                catch (ClassCastException classCastException) {
                    throw new KeeperException.UnimplementedException();
                }
                QuorumVerifier quorumVerifier = leaderZooKeeperServer.self.getLastSeenQuorumVerifier();
                if (quorumVerifier.getVersion() != leaderZooKeeperServer.self.getQuorumVerifier().getVersion()) {
                    throw new KeeperException.ReconfigInProgress();
                }
                ReconfigRequest reconfigRequest = (ReconfigRequest)mme2;
                long l3 = reconfigRequest.getCurConfigId();
                if (l3 != -1L && l3 != leaderZooKeeperServer.self.getLastSeenQuorumVerifier().getVersion()) {
                    String string = "Reconfiguration from version " + l3 + " failed -- last seen version is " + leaderZooKeeperServer.self.getLastSeenQuorumVerifier().getVersion();
                    throw new KeeperException.BadVersionException(string);
                }
                String string = reconfigRequest.getNewMembers();
                if (string != null) {
                    LOG.c("Non-incremental reconfig");
                    string = string.replaceAll(",", "\n");
                    try {
                        object = new Properties();
                        ((Properties)object).load(new StringReader(string));
                        request.qv = QuorumPeerConfig.parseDynamicConfig((Properties)object, leaderZooKeeperServer.self.getElectionType(), true, false, quorumVerifier.getOraclePath());
                        request.qv.setVersion(request.getHdr().getZxid());
                    }
                    catch (QuorumPeerConfig.ConfigException | IOException exception) {
                        throw new KeeperException.BadArgumentsException(exception.getMessage());
                    }
                }
                LOG.c("Incremental reconfig");
                object = null;
                String string4 = reconfigRequest.getJoiningServers();
                if (string4 != null) {
                    object = StringUtils.split(string4, ",");
                }
                List<String> list = null;
                String string5 = reconfigRequest.getLeavingServers();
                if (string5 != null) {
                    list = StringUtils.split(string5, ",");
                }
                if (!(quorumVerifier instanceof QuorumMaj) && !(quorumVerifier instanceof QuorumOracleMaj)) {
                    String string6 = "Incremental reconfiguration requested but last configuration seen has a non-majority quorum system";
                    LOG.d(string6);
                    throw new KeeperException.BadArgumentsException(string6);
                }
                HashMap<Long, QuorumPeer.QuorumServer> hashMap = new HashMap<Long, QuorumPeer.QuorumServer>(quorumVerifier.getAllMembers());
                try {
                    if (list != null) {
                        for (String string7 : list) {
                            long l4 = Long.parseLong(string7);
                            hashMap.remove(l4);
                        }
                    }
                    if (object != null) {
                        Iterator<String> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string7;
                            string7 = iterator.next();
                            String[] stringArray = StringUtils.split(string7, "=").toArray(new String[0]);
                            if (stringArray.length != 2) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string");
                            }
                            Long l5 = Long.parseLong(stringArray[0].substring(stringArray[0].lastIndexOf(46) + 1));
                            QuorumPeer.QuorumServer quorumServer = new QuorumPeer.QuorumServer((long)l5, stringArray[1]);
                            if (quorumServer.clientAddr == null || quorumServer.electionAddr == null || quorumServer.addr == null) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string - each server should have 3 ports specified");
                            }
                            for (QuorumPeer.QuorumServer quorumServer2 : hashMap.values()) {
                                if (quorumServer.id == quorumServer2.id) continue;
                                quorumServer.checkAddressDuplicate(quorumServer2);
                            }
                            hashMap.remove(quorumServer.id);
                            hashMap.put(quorumServer.id, quorumServer);
                        }
                    }
                }
                catch (QuorumPeerConfig.ConfigException configException) {
                    throw new KeeperException.BadArgumentsException("Reconfiguration failed");
                }
                request.qv = quorumVerifier instanceof QuorumMaj ? new QuorumMaj(hashMap) : new QuorumOracleMaj(hashMap, quorumVerifier.getOraclePath());
                request.qv.setVersion(request.getHdr().getZxid());
                if (QuorumPeerConfig.isStandaloneEnabled() && request.qv.getVotingMembers().size() < 2) {
                    object = "Reconfig failed - new configuration must include at least 2 followers";
                    LOG.d((String)object);
                    throw new KeeperException.BadArgumentsException((String)object);
                }
                if (request.qv.getVotingMembers().size() < 1) {
                    object = "Reconfig failed - new configuration must include at least 1 follower";
                    LOG.d((String)object);
                    throw new KeeperException.BadArgumentsException((String)object);
                }
                if (!leaderZooKeeperServer.getLeader().isQuorumSynced(request.qv)) {
                    object = "Reconfig failed - there must be a connected and synced quorum in new configuration";
                    LOG.d((String)object);
                    throw new KeeperException.NewConfigNoQuorum();
                }
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath("/zookeeper/config");
                this.zks.checkACL(request.cnxn, changeRecord.acl, 2, request.authInfo, null, null);
                object = new SetDataTxn("/zookeeper/config", request.qv.toString().getBytes(), -1);
                request.setTxn((mme)object);
                changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
                changeRecord.stat.setVersion(-1);
                changeRecord.stat.setMtime(request.getHdr().getTime());
                changeRecord.stat.setMzxid(l2);
                changeRecord.data = ((SetDataTxn)object).getData();
                changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.NOOP, "/zookeeper/config", changeRecord.data, changeRecord.stat);
                this.setTxnDigest(request, changeRecord.precalculatedDigest);
                this.addChangeRecord(changeRecord);
                break;
            }
            case 7: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetACLRequest setACLRequest = (SetACLRequest)mme2;
                String string = setACLRequest.getPath();
                this.validatePath(string, request.sessionId);
                List<ACL> list = PrepRequestProcessor.fixupACL(string, request.authInfo, setACLRequest.getAcl());
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string);
                this.zks.checkACL(request.cnxn, changeRecord.acl, 16, request.authInfo, string, list);
                int n4 = PrepRequestProcessor.checkAndIncVersion(changeRecord.stat.getAversion(), setACLRequest.getVersion(), string);
                request.setTxn(new SetACLTxn(string, list, n4));
                changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
                changeRecord.stat.setAversion(n4);
                changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string, changeRecord.data, changeRecord.stat);
                this.setTxnDigest(request, changeRecord.precalculatedDigest);
                this.addChangeRecord(changeRecord);
                break;
            }
            case -10: {
                CreateSessionTxn createSessionTxn = request.readRequestRecord(CreateSessionTxn::new);
                request.setTxn(createSessionTxn);
                this.zks.sessionTracker.trackSession(request.sessionId, createSessionTxn.getTimeOut());
                this.zks.setOwner(request.sessionId, request.getOwner());
                break;
            }
            case -11: {
                long l6 = Time.currentElapsedTime();
                Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
                synchronized (deque) {
                    Set<String> set = this.zks.getZKDatabase().getEphemerals(request.sessionId);
                    for (ZooKeeperServer.ChangeRecord object : this.zks.outstandingChanges) {
                        if (object.stat == null) {
                            set.remove(object.path);
                            continue;
                        }
                        if (object.stat.getEphemeralOwner() != request.sessionId) continue;
                        set.add(object.path);
                    }
                    for (String string : set) {
                        if (this.digestEnabled) {
                            String string2 = this.getParentPathAndValidate(string);
                            ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string2);
                            changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
                            changeRecord.stat.setPzxid(request.getHdr().getZxid());
                            changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string2, changeRecord.data, changeRecord.stat);
                            this.addChangeRecord(changeRecord);
                        }
                        ZooKeeperServer.ChangeRecord changeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), string, null, 0, null);
                        changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, string);
                        this.addChangeRecord(changeRecord);
                    }
                    if (ZooKeeperServer.isCloseSessionTxnEnabled()) {
                        request.setTxn(new CloseSessionTxn(new ArrayList<String>(set)));
                    }
                    this.zks.sessionTracker.setSessionClosing(request.sessionId);
                }
                ServerMetrics.getMetrics().CLOSE_SESSION_PREP_TIME.add(Time.currentElapsedTime() - l6);
                break;
            }
            case 13: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                CheckVersionRequest checkVersionRequest = (CheckVersionRequest)mme2;
                String string = checkVersionRequest.getPath();
                this.validatePath(string, request.sessionId);
                ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string);
                this.zks.checkACL(request.cnxn, changeRecord.acl, 1, request.authInfo, string, null);
                request.setTxn(new CheckVersionTxn(string, PrepRequestProcessor.checkAndIncVersion(changeRecord.stat.getVersion(), checkVersionRequest.getVersion(), string)));
                break;
            }
            default: {
                LOG.d("unknown type {}", (Object)n2);
            }
        }
        if (request.getTxnDigest() == null && this.digestEnabled) {
            this.setTxnDigest(request);
        }
    }

    private void pRequest2TxnCreate(int n2, Request request, mme mme2) throws IOException, KeeperException {
        boolean bl2;
        long l2;
        byte[] byArray;
        List<ACL> list;
        String string;
        int n3;
        Object object;
        if (n2 == 21) {
            object = (CreateTTLRequest)mme2;
            n3 = ((CreateTTLRequest)object).getFlags();
            string = ((CreateTTLRequest)object).getPath();
            list = ((CreateTTLRequest)object).getAcl();
            byArray = ((CreateTTLRequest)object).getData();
            l2 = ((CreateTTLRequest)object).getTtl();
        } else {
            object = (CreateRequest)mme2;
            n3 = ((CreateRequest)object).getFlags();
            string = ((CreateRequest)object).getPath();
            list = ((CreateRequest)object).getAcl();
            byArray = ((CreateRequest)object).getData();
            l2 = -1L;
        }
        object = CreateMode.fromFlag(n3);
        this.validateCreateRequest(string, (CreateMode)((Object)object), request, l2);
        String string2 = this.validatePathForCreate(string, request.sessionId);
        List<ACL> list2 = PrepRequestProcessor.fixupACL(string, request.authInfo, list);
        ZooKeeperServer.ChangeRecord changeRecord = this.getRecordForPath(string2);
        this.zks.checkACL(request.cnxn, changeRecord.acl, 4, request.authInfo, string, list2);
        int n4 = changeRecord.stat.getCversion();
        if (((CreateMode)((Object)object)).isSequential()) {
            string = string + String.format(Locale.ENGLISH, "%010d", n4);
        }
        this.validatePath(string, request.sessionId);
        try {
            if (this.getRecordForPath(string) != null) {
                throw new KeeperException.NodeExistsException(string);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        boolean bl3 = bl2 = EphemeralType.get(changeRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL;
        if (bl2) {
            throw new KeeperException.NoChildrenForEphemeralsException(string);
        }
        int n5 = changeRecord.stat.getCversion() + 1;
        this.zks.checkQuota(string, null, byArray, 1);
        if (n2 == 19) {
            request.setTxn(new CreateContainerTxn(string, byArray, list2, n5));
        } else if (n2 == 21) {
            request.setTxn(new CreateTTLTxn(string, byArray, list2, n5, l2));
        } else {
            request.setTxn(new CreateTxn(string, byArray, list2, ((CreateMode)((Object)object)).isEphemeral(), n5));
        }
        TxnHeader txnHeader = request.getHdr();
        long l3 = 0L;
        if (((CreateMode)((Object)object)).isContainer()) {
            l3 = Long.MIN_VALUE;
        } else if (((CreateMode)((Object)object)).isTTL()) {
            l3 = EphemeralType.TTL.toEphemeralOwner(l2);
        } else if (((CreateMode)((Object)object)).isEphemeral()) {
            l3 = request.sessionId;
        }
        StatPersisted statPersisted = DataTree.createStat(txnHeader.getZxid(), txnHeader.getTime(), l3);
        changeRecord = changeRecord.duplicate(request.getHdr().getZxid());
        ++changeRecord.childCount;
        changeRecord.stat.setCversion(n5);
        changeRecord.stat.setPzxid(request.getHdr().getZxid());
        changeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, string2, changeRecord.data, changeRecord.stat);
        this.addChangeRecord(changeRecord);
        ZooKeeperServer.ChangeRecord changeRecord2 = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), string, statPersisted, 0, list2);
        changeRecord2.data = byArray;
        changeRecord2.precalculatedDigest = this.precalculateDigest(DigestOpCode.ADD, string, changeRecord2.data, statPersisted);
        this.setTxnDigest(request, changeRecord2.precalculatedDigest);
        this.addChangeRecord(changeRecord2);
    }

    private void validatePath(String string, long l2) throws KeeperException.BadArgumentsException {
        try {
            PathUtils.validatePath(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.c("Invalid path {} with session 0x{}, reason: {}", string, Long.toHexString(l2), illegalArgumentException.getMessage());
            throw new KeeperException.BadArgumentsException(string);
        }
    }

    private String getParentPathAndValidate(String string) throws KeeperException.BadArgumentsException {
        int n2 = string.lastIndexOf(47);
        if (n2 == -1 || string.indexOf(0) != -1 || this.zks.getZKDatabase().isSpecialPath(string)) {
            throw new KeeperException.BadArgumentsException(string);
        }
        return string.substring(0, n2);
    }

    private static int checkAndIncVersion(int n2, int n3, String string) throws KeeperException.BadVersionException {
        if (n3 != -1 && n3 != n2) {
            throw new KeeperException.BadVersionException(string);
        }
        return n2 + 1;
    }

    protected void pRequest(Request request) throws RequestProcessor.RequestProcessorException {
        request.setHdr(null);
        request.setTxn(null);
        if (!request.isThrottled()) {
            this.pRequestHelper(request);
        }
        request.zxid = this.zks.getZxid();
        long l2 = Time.currentElapsedTime();
        ServerMetrics.getMetrics().PREP_PROCESS_TIME.add(l2 - request.prepStartTime);
        this.nextProcessor.processRequest(request);
        ServerMetrics.getMetrics().PROPOSAL_PROCESS_TIME.add(Time.currentElapsedTime() - l2);
    }

    private void pRequestHelper(Request request) {
        try {
            switch (request.type) {
                case 1: 
                case 15: 
                case 19: {
                    CreateRequest createRequest = request.readRequestRecord(CreateRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, createRequest);
                    break;
                }
                case 21: {
                    CreateTTLRequest createTTLRequest = request.readRequestRecord(CreateTTLRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, createTTLRequest);
                    break;
                }
                case 20: {
                    DeleteContainerRequest deleteContainerRequest = request.readRequestRecord(DeleteContainerRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, deleteContainerRequest);
                    break;
                }
                case 2: {
                    DeleteRequest deleteRequest = request.readRequestRecord(DeleteRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, deleteRequest);
                    break;
                }
                case 5: {
                    SetDataRequest setDataRequest = request.readRequestRecord(SetDataRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setDataRequest);
                    break;
                }
                case 16: {
                    ReconfigRequest reconfigRequest = request.readRequestRecord(ReconfigRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, reconfigRequest);
                    break;
                }
                case 7: {
                    SetACLRequest setACLRequest = request.readRequestRecord(SetACLRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setACLRequest);
                    break;
                }
                case 13: {
                    CheckVersionRequest checkVersionRequest = request.readRequestRecord(CheckVersionRequest::new);
                    this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, checkVersionRequest);
                    break;
                }
                case 14: {
                    MultiOperationRecord multiOperationRecord;
                    try {
                        multiOperationRecord = request.readRequestRecord(MultiOperationRecord::new);
                    }
                    catch (IOException iOException) {
                        request.setHdr(new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), Time.currentWallTime(), 14));
                        throw iOException;
                    }
                    ArrayList<Txn> arrayList = new ArrayList<Txn>();
                    long l2 = this.zks.getNextZxid();
                    KeeperException keeperException = null;
                    Map<String, ZooKeeperServer.ChangeRecord> map = this.getPendingChanges(multiOperationRecord);
                    request.setHdr(new TxnHeader(request.sessionId, request.cxid, l2, Time.currentWallTime(), request.type));
                    for (Op op2 : multiOperationRecord) {
                        mme mme2;
                        int n2;
                        mme mme3 = op2.toRequestRecord();
                        if (keeperException != null) {
                            n2 = -1;
                            mme2 = new ErrorTxn(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
                        } else {
                            try {
                                this.pRequest2Txn(op2.getType(), l2, request, mme3);
                                n2 = op2.getType();
                                mme2 = request.getTxn();
                            }
                            catch (KeeperException keeperException2) {
                                keeperException = keeperException2;
                                n2 = -1;
                                mme2 = new ErrorTxn(keeperException2.code().intValue());
                                if (keeperException2.code().intValue() > KeeperException.Code.APIERROR.intValue()) {
                                    LOG.c("Got user-level KeeperException when processing {} aborting remaining multi ops. Error Path:{} Error:{}", request.toString(), keeperException2.getPath(), keeperException2.getMessage());
                                }
                                request.setException(keeperException2);
                                this.rollbackPendingChanges(l2, map);
                            }
                        }
                        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                            ime ime2 = ime.a(byteArrayOutputStream);
                            mme2.serialize(ime2, "request");
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                            arrayList.add(new Txn(n2, byteBuffer.array()));
                        }
                    }
                    request.setTxn(new MultiTxn(arrayList));
                    if (this.digestEnabled) {
                        this.setTxnDigest(request);
                    }
                    break;
                }
                case -11: 
                case -10: {
                    if (!request.isLocalSession()) {
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, null);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 17: 
                case 18: 
                case 22: 
                case 101: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                    break;
                }
                default: {
                    LOG.d("unknown type {}", (Object)request.type);
                    break;
                }
            }
        }
        catch (KeeperException keeperException) {
            if (request.getHdr() != null) {
                request.getHdr().setType(-1);
                request.setTxn(new ErrorTxn(keeperException.code().intValue()));
            }
            if (keeperException.code().intValue() > KeeperException.Code.APIERROR.intValue()) {
                LOG.c("Got user-level KeeperException when processing {} Error Path:{} Error:{}", request.toString(), keeperException.getPath(), keeperException.getMessage());
            }
            request.setException(keeperException);
        }
        catch (Exception exception) {
            LOG.e("Failed to process {}", (Object)request, (Object)exception);
            String string = request.requestDigest();
            LOG.e("Dumping request buffer for request type {}: 0x{}", (Object)Request.op2String(request.type), (Object)string);
            if (request.getHdr() == null) {
                request.setHdr(new TxnHeader(request.sessionId, request.cxid, this.zks.getZxid(), Time.currentWallTime(), request.type));
            }
            request.getHdr().setType(-1);
            request.setTxn(new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()));
        }
    }

    private static List<ACL> removeDuplicates(List<ACL> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ACL> arrayList = new ArrayList<ACL>(list.size());
        for (ACL aCL : list) {
            if (arrayList.contains(aCL)) continue;
            arrayList.add(aCL);
        }
        return arrayList;
    }

    private void validateCreateRequest(String string, CreateMode createMode, Request request, long l2) throws KeeperException {
        if (createMode.isTTL() && !EphemeralType.extendedEphemeralTypesEnabled()) {
            throw new KeeperException.UnimplementedException();
        }
        try {
            EphemeralType.validateTTL(createMode, l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KeeperException.BadArgumentsException(string);
        }
        if (createMode.isEphemeral()) {
            if (request.getException() != null) {
                throw request.getException();
            }
            this.zks.sessionTracker.checkGlobalSession(request.sessionId, request.getOwner());
        } else {
            this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
        }
    }

    public static List<ACL> fixupACL(String string, List<Id> list, List<ACL> list2) throws KeeperException.InvalidACLException {
        List<ACL> list3 = PrepRequestProcessor.removeDuplicates(list2);
        if (list3 == null || list3.size() == 0) {
            throw new KeeperException.InvalidACLException(string);
        }
        ArrayList<ACL> arrayList = new ArrayList<ACL>();
        for (ACL aCL : list3) {
            LOG.b("Processing ACL: {}", (Object)aCL);
            if (aCL == null) {
                throw new KeeperException.InvalidACLException(string);
            }
            Id id2 = aCL.getId();
            if (id2 == null || id2.getScheme() == null) {
                throw new KeeperException.InvalidACLException(string);
            }
            if (id2.getScheme().equals("world") && id2.getId().equals("anyone")) {
                arrayList.add(aCL);
                continue;
            }
            if (id2.getScheme().equals("auth")) {
                boolean bl2 = false;
                for (Id id3 : list) {
                    ServerAuthenticationProvider serverAuthenticationProvider = ProviderRegistry.getServerProvider(id3.getScheme());
                    if (serverAuthenticationProvider == null) {
                        LOG.e("Missing AuthenticationProvider for {}", (Object)id3.getScheme());
                        continue;
                    }
                    if (!serverAuthenticationProvider.isAuthenticated()) continue;
                    bl2 = true;
                    arrayList.add(new ACL(aCL.getPerms(), id3));
                }
                if (bl2) continue;
                throw new KeeperException.InvalidACLException(string);
            }
            ServerAuthenticationProvider serverAuthenticationProvider = ProviderRegistry.getServerProvider(id2.getScheme());
            if (serverAuthenticationProvider == null || !serverAuthenticationProvider.isValid(id2.getId())) {
                throw new KeeperException.InvalidACLException(string);
            }
            arrayList.add(aCL);
        }
        return arrayList;
    }

    @Override
    public void processRequest(Request request) {
        request.prepQueueStartTime = Time.currentElapsedTime();
        this.submittedRequests.add(request);
        ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUED.add(1L);
    }

    @Override
    public void shutdown() {
        LOG.c("Shutting down");
        this.submittedRequests.clear();
        this.submittedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    private ZooKeeperServer.PrecalculatedDigest precalculateDigest(DigestOpCode digestOpCode, String string, byte[] byArray, StatPersisted statPersisted) throws KeeperException.NoNodeException {
        long l2;
        long l3;
        if (!this.digestEnabled) {
            return null;
        }
        switch (digestOpCode) {
            case ADD: {
                l3 = 0L;
                l2 = this.digestCalculator.calculateDigest(string, byArray, statPersisted);
                break;
            }
            case REMOVE: {
                l3 = this.getRecordForPath((String)string).precalculatedDigest.nodeDigest;
                l2 = 0L;
                break;
            }
            case UPDATE: {
                l3 = this.getRecordForPath((String)string).precalculatedDigest.nodeDigest;
                l2 = this.digestCalculator.calculateDigest(string, byArray, statPersisted);
                break;
            }
            case NOOP: {
                l3 = 0L;
                l2 = 0L;
                break;
            }
            default: {
                return null;
            }
        }
        long l4 = this.getCurrentTreeDigest() - l3 + l2;
        return new ZooKeeperServer.PrecalculatedDigest(l2, l4);
    }

    private ZooKeeperServer.PrecalculatedDigest precalculateDigest(DigestOpCode digestOpCode, String string) throws KeeperException.NoNodeException {
        return this.precalculateDigest(digestOpCode, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentTreeDigest() {
        long l2;
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            if (this.zks.outstandingChanges.isEmpty()) {
                l2 = this.zks.getZKDatabase().getDataTree().getTreeDigest();
                LOG.b("Digest got from data tree is: {}", (Object)l2);
            } else {
                l2 = this.zks.outstandingChanges.peekLast().precalculatedDigest.treeDigest;
                LOG.b("Digest got from outstandingChanges is: {}", (Object)l2);
            }
        }
        return l2;
    }

    private void setTxnDigest(Request request) {
        request.setTxnDigest(new TxnDigest(this.digestCalculator.getDigestVersion(), this.getCurrentTreeDigest()));
    }

    private void setTxnDigest(Request request, ZooKeeperServer.PrecalculatedDigest precalculatedDigest) {
        if (precalculatedDigest == null) {
            return;
        }
        request.setTxnDigest(new TxnDigest(this.digestCalculator.getDigestVersion(), precalculatedDigest.treeDigest));
    }

    public static enum DigestOpCode {
        NOOP,
        ADD,
        REMOVE,
        UPDATE;

    }
}

