/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServerBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.Observer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.ObserverMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeer;
import java.net.InetSocketAddress;

public class ObserverBean
extends ZooKeeperServerBean
implements ObserverMXBean {
    private Observer observer;

    public ObserverBean(Observer observer, ZooKeeperServer zooKeeperServer) {
        super(zooKeeperServer);
        this.observer = observer;
    }

    @Override
    public String getName() {
        return "Observer";
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.observer.getPendingRevalidationsCount();
    }

    @Override
    public String getQuorumAddress() {
        return this.observer.getSocket().toString();
    }

    @Override
    public String getLearnerMaster() {
        QuorumPeer.QuorumServer quorumServer = this.observer.getCurrentLearnerMaster();
        if (quorumServer == null || quorumServer.addr.isEmpty()) {
            return "Unknown";
        }
        InetSocketAddress inetSocketAddress = quorumServer.addr.getReachableOrOne();
        return inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
    }

    @Override
    public void setLearnerMaster(String string) {
        if (!this.observer.setLearnerMaster(string)) {
            throw new IllegalArgumentException("Not a valid learner master");
        }
    }
}

