/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DigestCalculator;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NodeHashMap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.AdHash;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NodeHashMapImpl
implements NodeHashMap {
    private final ConcurrentHashMap<String, DataNode> nodes;
    private final boolean digestEnabled;
    private final DigestCalculator digestCalculator;
    private final AdHash hash;

    public NodeHashMapImpl(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
        this.nodes = new ConcurrentHashMap();
        this.hash = new AdHash();
        this.digestEnabled = ZooKeeperServer.isDigestEnabled();
    }

    @Override
    public DataNode put(String string, DataNode dataNode) {
        DataNode dataNode2 = this.nodes.put(string, dataNode);
        this.addDigest(string, dataNode);
        if (dataNode2 != null) {
            this.removeDigest(string, dataNode2);
        }
        return dataNode2;
    }

    @Override
    public DataNode putWithoutDigest(String string, DataNode dataNode) {
        return this.nodes.put(string, dataNode);
    }

    @Override
    public DataNode get(String string) {
        return this.nodes.get(string);
    }

    @Override
    public DataNode remove(String string) {
        DataNode dataNode = this.nodes.remove(string);
        if (dataNode != null) {
            this.removeDigest(string, dataNode);
        }
        return dataNode;
    }

    @Override
    public Set<Map.Entry<String, DataNode>> entrySet() {
        return this.nodes.entrySet();
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.hash.clear();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public void preChange(String string, DataNode dataNode) {
        this.removeDigest(string, dataNode);
    }

    @Override
    public void postChange(String string, DataNode dataNode) {
        dataNode.digestCached = false;
        this.addDigest(string, dataNode);
    }

    private void addDigest(String string, DataNode dataNode) {
        if (string.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.addDigest(this.digestCalculator.calculateDigest(string, dataNode));
        }
    }

    private void removeDigest(String string, DataNode dataNode) {
        if (string.startsWith("/zookeeper/")) {
            return;
        }
        if (this.digestEnabled) {
            this.hash.removeDigest(this.digestCalculator.calculateDigest(string, dataNode));
        }
    }

    @Override
    public long getDigest() {
        return this.hash.getHash();
    }
}

