/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OptionalSslHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ClientX509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.NettyUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Exception;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NettyServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.X509AuthenticationProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class NettyServerCnxnFactory
extends ServerCnxnFactory {
    private static final foe LOG = goe.a(NettyServerCnxnFactory.class);
    public static final String PORT_UNIFICATION_KEY = "zookeeper.client.portUnification";
    public static final String EARLY_DROP_SECURE_CONNECTION_HANDSHAKES = "zookeeper.netty.server.earlyDropSecureConnectionHandshakes";
    private final boolean shouldUsePortUnification;
    private static final byte TLS_HANDSHAKE_RECORD_TYPE = 22;
    private final AtomicInteger outstandingHandshake = new AtomicInteger();
    public static final String OUTSTANDING_HANDSHAKE_LIMIT = "zookeeper.netty.server.outstandingHandshake.limit";
    private int outstandingHandshakeLimit;
    private boolean handshakeThrottlingEnabled;
    private final ServerBootstrap bootstrap;
    private Channel parentChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup("zkServerCnxns", (EventExecutor)new DefaultEventExecutor());
    private final Map<InetAddress, AtomicInteger> ipMap = new ConcurrentHashMap<InetAddress, AtomicInteger>();
    private InetSocketAddress localAddress;
    private int maxClientCnxns = 60;
    int listenBacklog = -1;
    private final ClientX509Util x509Util;
    public static final String NETTY_ADVANCED_FLOW_CONTROL = "zookeeper.netty.advancedFlowControl.enabled";
    private boolean advancedFlowControlEnabled = false;
    private static final AttributeKey<NettyServerCnxn> CONNECTION_ATTRIBUTE = AttributeKey.valueOf((String)"NettyServerCnxn");
    private static final AtomicReference<ByteBufAllocator> TEST_ALLOCATOR = new AtomicReference<Object>(null);
    public static final String CLIENT_CERT_RELOAD_KEY = "zookeeper.client.certReload";
    CnxnChannelHandler channelHandler = new CnxnChannelHandler();
    ReadIssuedTrackingHandler readIssuedTrackingHandler = new ReadIssuedTrackingHandler();
    private boolean killed;

    public void setOutstandingHandshakeLimit(int n2) {
        this.outstandingHandshakeLimit = n2;
        this.handshakeThrottlingEnabled = (this.secure || this.shouldUsePortUnification) && this.outstandingHandshakeLimit > 0;
        LOG.c("handshakeThrottlingEnabled = {}, {} = {}", this.handshakeThrottlingEnabled, OUTSTANDING_HANDSHAKE_LIMIT, this.outstandingHandshakeLimit);
    }

    private void updateHandshakeCountIfStarted(NettyServerCnxn nettyServerCnxn) {
        if (nettyServerCnxn != null && nettyServerCnxn.getHandshakeState() == NettyServerCnxn.HandshakeState.STARTED) {
            nettyServerCnxn.setHandshakeState(NettyServerCnxn.HandshakeState.FINISHED);
            this.outstandingHandshake.addAndGet(-1);
        }
    }

    private ServerBootstrap configureBootstrapAllocator(ServerBootstrap serverBootstrap) {
        ByteBufAllocator byteBufAllocator = TEST_ALLOCATOR.get();
        if (byteBufAllocator != null) {
            return ((ServerBootstrap)serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)byteBufAllocator)).childOption(ChannelOption.ALLOCATOR, (Object)byteBufAllocator);
        }
        return serverBootstrap;
    }

    NettyServerCnxnFactory() {
        this.x509Util = new ClientX509Util();
        boolean bl2 = Boolean.getBoolean(CLIENT_CERT_RELOAD_KEY);
        LOG.c("{}={}", (Object)CLIENT_CERT_RELOAD_KEY, (Object)bl2);
        if (bl2) {
            try {
                this.x509Util.enableCertFileReloading();
            }
            catch (IOException iOException) {
                LOG.d("unable to set up client certificate reload filewatcher", iOException);
                bl2 = false;
            }
        }
        boolean bl3 = Boolean.getBoolean(PORT_UNIFICATION_KEY);
        LOG.c("{}={}", (Object)PORT_UNIFICATION_KEY, (Object)bl3);
        if (bl3) {
            try {
                QuorumPeerConfig.configureSSLAuth();
            }
            catch (QuorumPeerConfig.ConfigException configException) {
                LOG.d("unable to set up SslAuthProvider, turning off client port unification", configException);
                bl3 = false;
            }
        }
        this.shouldUsePortUnification = bl3;
        this.advancedFlowControlEnabled = Boolean.getBoolean(NETTY_ADVANCED_FLOW_CONTROL);
        LOG.c("{} = {}", (Object)NETTY_ADVANCED_FLOW_CONTROL, (Object)this.advancedFlowControlEnabled);
        this.setOutstandingHandshakeLimit(Integer.getInteger(OUTSTANDING_HANDSHAKE_LIMIT, -1));
        EventLoopGroup eventLoopGroup = NettyUtils.newNioOrEpollEventLoopGroup(NettyUtils.getClientReachableLocalInetAddressCount());
        EventLoopGroup eventLoopGroup2 = NettyUtils.newNioOrEpollEventLoopGroup();
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup, eventLoopGroup2).channel(NettyUtils.nioOrEpollServerSocketChannel())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_LINGER, (Object)-1).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline channelPipeline = socketChannel.pipeline();
                if (NettyServerCnxnFactory.this.advancedFlowControlEnabled) {
                    channelPipeline.addLast(new ChannelHandler[]{NettyServerCnxnFactory.this.readIssuedTrackingHandler});
                }
                if (NettyServerCnxnFactory.this.secure) {
                    NettyServerCnxnFactory.this.initSSL(channelPipeline, false);
                } else if (NettyServerCnxnFactory.this.shouldUsePortUnification) {
                    NettyServerCnxnFactory.this.initSSL(channelPipeline, true);
                }
                channelPipeline.addLast("servercnxnfactory", (ChannelHandler)NettyServerCnxnFactory.this.channelHandler);
            }
        });
        this.bootstrap = this.configureBootstrapAllocator(serverBootstrap);
        this.bootstrap.validate();
    }

    private synchronized void initSSL(ChannelPipeline channelPipeline, boolean bl2) throws X509Exception, SSLException {
        SslContext sslContext;
        String string = System.getProperty(this.x509Util.getSslAuthProviderProperty());
        if (string == null) {
            sslContext = this.x509Util.createNettySslContextForServer(new ZKConfig());
        } else {
            X509AuthenticationProvider x509AuthenticationProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(System.getProperty(this.x509Util.getSslAuthProviderProperty(), "x509"));
            if (x509AuthenticationProvider == null) {
                LOG.e("Auth provider not found: {}", (Object)string);
                throw new X509Exception.SSLContextException("Could not create SSLContext with specified auth provider: " + string);
            }
            sslContext = this.x509Util.createNettySslContextForServer(new ZKConfig(), x509AuthenticationProvider.getKeyManager(), x509AuthenticationProvider.getTrustManager());
        }
        if (bl2) {
            channelPipeline.addLast("ssl", (ChannelHandler)new DualModeSslHandler(sslContext));
            LOG.b("dual mode SSL handler added for channel: {}", (Object)channelPipeline.channel());
        } else {
            channelPipeline.addLast("ssl", (ChannelHandler)sslContext.newHandler(channelPipeline.channel().alloc()));
            LOG.b("SSL handler added for channel: {}", (Object)channelPipeline.channel());
        }
    }

    @Override
    public void closeAll(ServerCnxn.DisconnectReason disconnectReason) {
        LOG.b("closeAll()");
        int n2 = this.cnxns.size();
        for (ServerCnxn serverCnxn : this.cnxns) {
            try {
                serverCnxn.close(disconnectReason);
            }
            catch (Exception exception) {
                LOG.d("Ignoring exception closing cnxn sessionid 0x{}", (Object)Long.toHexString(serverCnxn.getSessionId()), (Object)exception);
            }
        }
        LOG.b("allChannels size: {} cnxns size: {}", (Object)this.allChannels.size(), (Object)n2);
    }

    @Override
    public void configure(InetSocketAddress inetSocketAddress, int n2, int n3, boolean bl2) throws IOException {
        this.configureSaslLogin();
        this.initMaxCnxns();
        this.localAddress = inetSocketAddress;
        this.maxClientCnxns = n2;
        this.secure = bl2;
        this.listenBacklog = n3;
        LOG.c("configure {} secure: {} on addr {}", this, bl2, inetSocketAddress);
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int n2) {
        this.maxClientCnxns = n2;
    }

    @Override
    public int getSocketListenBacklog() {
        return this.listenBacklog;
    }

    @Override
    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            while (!this.killed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object;
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            if (this.killed) {
                LOG.c("already shutdown {}", (Object)this.localAddress);
                return;
            }
        }
        LOG.c("shutdown called {}", (Object)this.localAddress);
        this.x509Util.close();
        if (this.login != null) {
            this.login.shutdown();
        }
        nettyServerCnxnFactory = this.bootstrap.config().group();
        EventLoopGroup eventLoopGroup = this.bootstrap.config().childGroup();
        if (this.parentChannel != null) {
            object = this.parentChannel.close();
            if (nettyServerCnxnFactory != null) {
                object.addListener(arg_0 -> NettyServerCnxnFactory.lambda$shutdown$0((EventLoopGroup)nettyServerCnxnFactory, arg_0));
            }
            this.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
            ChannelGroupFuture channelGroupFuture = this.allChannels.close();
            if (eventLoopGroup != null) {
                channelGroupFuture.addListener(future -> eventLoopGroup.shutdownGracefully());
            }
        } else {
            if (nettyServerCnxnFactory != null) {
                nettyServerCnxnFactory.shutdownGracefully();
            }
            if (eventLoopGroup != null) {
                eventLoopGroup.shutdownGracefully();
            }
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
        object = this;
        synchronized (object) {
            this.killed = true;
            this.notifyAll();
        }
    }

    @Override
    public void start() {
        if (this.listenBacklog != -1) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.listenBacklog);
        }
        LOG.c("binding to port {}", (Object)this.localAddress);
        this.parentChannel = this.bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly().channel();
        this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
        LOG.c("bound to port {}", (Object)this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(InetSocketAddress inetSocketAddress) {
        LOG.c("binding to port {}, {}", (Object)inetSocketAddress, (Object)this.localAddress);
        if (inetSocketAddress != null && this.localAddress != null && (inetSocketAddress.equals(this.localAddress) || inetSocketAddress.getAddress().isAnyLocalAddress() && this.localAddress.getAddress().isAnyLocalAddress() && inetSocketAddress.getPort() == this.localAddress.getPort())) {
            LOG.c("address is the same, skip rebinding");
            return;
        }
        try (Channel channel = this.parentChannel;){
            this.parentChannel = this.bootstrap.bind((SocketAddress)inetSocketAddress).syncUninterruptibly().channel();
            this.localAddress = (InetSocketAddress)this.parentChannel.localAddress();
            LOG.c("bound to port {}", (Object)this.getLocalPort());
        }
    }

    @Override
    public void startup(ZooKeeperServer zooKeeperServer, boolean bl2) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zooKeeperServer);
        if (bl2) {
            zooKeeperServer.startdata();
            zooKeeperServer.startup();
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    private void addCnxn(NettyServerCnxn nettyServerCnxn) {
        this.cnxns.add(nettyServerCnxn);
        InetAddress inetAddress2 = ((InetSocketAddress)nettyServerCnxn.getChannel().remoteAddress()).getAddress();
        this.ipMap.compute(inetAddress2, (inetAddress, atomicInteger) -> {
            if (atomicInteger == null) {
                atomicInteger = new AtomicInteger();
            }
            atomicInteger.incrementAndGet();
            return atomicInteger;
        });
    }

    void removeCnxnFromIpMap(NettyServerCnxn nettyServerCnxn, InetAddress inetAddress) {
        this.ipMap.compute(inetAddress, (inetAddress2, atomicInteger) -> {
            if (atomicInteger == null) {
                LOG.e("Unexpected remote address {} when removing cnxn {}", (Object)inetAddress, (Object)nettyServerCnxn);
                return null;
            }
            int n2 = atomicInteger.decrementAndGet();
            return n2 == 0 ? null : atomicInteger;
        });
    }

    private int getClientCnxnCount(InetAddress inetAddress) {
        AtomicInteger atomicInteger = this.ipMap.get(inetAddress);
        return atomicInteger == null ? 0 : atomicInteger.get();
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn serverCnxn : this.cnxns) {
            serverCnxn.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean bl2) {
        HashSet<Map<String, Object>> hashSet = new HashSet<Map<String, Object>>();
        for (ServerCnxn serverCnxn : this.cnxns) {
            hashSet.add(serverCnxn.getConnectionInfo(bl2));
        }
        return hashSet;
    }

    static void setTestAllocator(ByteBufAllocator byteBufAllocator) {
        TEST_ALLOCATOR.set(byteBufAllocator);
    }

    static void clearTestAllocator() {
        TEST_ALLOCATOR.set(null);
    }

    public void setAdvancedFlowControlEnabled(boolean bl2) {
        this.advancedFlowControlEnabled = bl2;
    }

    public void setSecure(boolean bl2) {
        this.secure = bl2;
    }

    public Channel getParentChannel() {
        return this.parentChannel;
    }

    public int getOutstandingHandshakeNum() {
        return this.outstandingHandshake.get();
    }

    private static /* synthetic */ void lambda$shutdown$0(EventLoopGroup eventLoopGroup, Future future) throws Exception {
        eventLoopGroup.shutdownGracefully();
    }

    static class ReadIssuedTrackingHandler
    extends ChannelDuplexHandler {
        ReadIssuedTrackingHandler() {
        }

        public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
            NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get();
            if (nettyServerCnxn != null) {
                ++nettyServerCnxn.readIssuedAfterReadComplete;
            }
            channelHandlerContext.read();
        }

        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
            NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get();
            if (nettyServerCnxn != null) {
                nettyServerCnxn.readIssuedAfterReadComplete = 0;
            }
            channelHandlerContext.fireChannelReadComplete();
        }
    }

    final class CertificateVerifier
    implements GenericFutureListener<Future<Channel>> {
        private final SslHandler sslHandler;
        private final NettyServerCnxn cnxn;

        CertificateVerifier(SslHandler sslHandler, NettyServerCnxn nettyServerCnxn) {
            this.sslHandler = sslHandler;
            this.cnxn = nettyServerCnxn;
        }

        public void operationComplete(Future<Channel> future) {
            NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(this.cnxn);
            if (future.isSuccess()) {
                SSLSession sSLSession;
                LOG.b("Successful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                SSLEngine sSLEngine = this.sslHandler.engine();
                if (sSLEngine.getNeedClientAuth() || sSLEngine.getWantClientAuth()) {
                    sSLSession = sSLEngine.getSession();
                    try {
                        this.cnxn.setClientCertificateChain(sSLSession.getPeerCertificates());
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        if (sSLEngine.getNeedClientAuth()) {
                            LOG.d("Error getting peer certificates", sSLPeerUnverifiedException);
                            this.cnxn.close();
                            return;
                        }
                        Channel channel = (Channel)future.getNow();
                        NettyServerCnxnFactory.this.allChannels.add((Object)Objects.requireNonNull(channel));
                        NettyServerCnxnFactory.this.addCnxn(this.cnxn);
                        return;
                    }
                    catch (Exception exception) {
                        LOG.d("Error getting peer certificates", exception);
                        this.cnxn.close();
                        return;
                    }
                    String string = System.getProperty(NettyServerCnxnFactory.this.x509Util.getSslAuthProviderProperty(), "x509");
                    X509AuthenticationProvider x509AuthenticationProvider = (X509AuthenticationProvider)ProviderRegistry.getProvider(string);
                    if (x509AuthenticationProvider == null) {
                        LOG.e("X509 Auth provider not found: {}", (Object)string);
                        this.cnxn.close(ServerCnxn.DisconnectReason.AUTH_PROVIDER_NOT_FOUND);
                        return;
                    }
                    KeeperException.Code code = x509AuthenticationProvider.handleAuthentication(this.cnxn, null);
                    if (KeeperException.Code.OK != code) {
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementAuthFailedCount();
                        LOG.e("Authentication failed for session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                        this.cnxn.close(ServerCnxn.DisconnectReason.SASL_AUTH_FAILURE);
                        return;
                    }
                }
                sSLSession = (Channel)future.getNow();
                NettyServerCnxnFactory.this.allChannels.add((Object)((Channel)Objects.requireNonNull(sSLSession)));
                NettyServerCnxnFactory.this.addCnxn(this.cnxn);
            } else {
                NettyServerCnxnFactory.this.zkServer.serverStats().incrementAuthFailedCount();
                LOG.e("Unsuccessful handshake with session 0x{}", (Object)Long.toHexString(this.cnxn.getSessionId()));
                ServerMetrics.getMetrics().UNSUCCESSFUL_HANDSHAKE.add(1L);
                this.cnxn.close(ServerCnxn.DisconnectReason.FAILED_HANDSHAKE);
            }
        }
    }

    class CnxnChannelHandler
    extends ChannelDuplexHandler {
        private final GenericFutureListener<Future<Void>> onWriteCompletedTracer = future -> {
            if (LOG.b()) {
                LOG.a("write success: {}", (Object)future.isSuccess());
            }
        };

        CnxnChannelHandler() {
        }

        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            int n2;
            if (LOG.b()) {
                LOG.a("Channel active {}", (Object)channelHandlerContext.channel());
            }
            Channel channel = channelHandlerContext.channel();
            if (NettyServerCnxnFactory.this.limitTotalNumberOfCnxns()) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                channel.close();
                return;
            }
            InetAddress inetAddress = ((InetSocketAddress)channel.remoteAddress()).getAddress();
            if (NettyServerCnxnFactory.this.maxClientCnxns > 0 && NettyServerCnxnFactory.this.getClientCnxnCount(inetAddress) >= NettyServerCnxnFactory.this.maxClientCnxns) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                LOG.d("Too many connections from {} - max is {}", (Object)inetAddress, (Object)NettyServerCnxnFactory.this.maxClientCnxns);
                channel.close();
                return;
            }
            NettyServerCnxn nettyServerCnxn = new NettyServerCnxn(channel, NettyServerCnxnFactory.this.zkServer, NettyServerCnxnFactory.this);
            channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).set((Object)nettyServerCnxn);
            if (NettyServerCnxnFactory.this.secure && !nettyServerCnxn.isZKServerRunning() && (n2 = Boolean.getBoolean(NettyServerCnxnFactory.EARLY_DROP_SECURE_CONNECTION_HANDSHAKES)) != 0) {
                LOG.c("Zookeeper server is not running, close the connection to {} before starting the TLS handshake", (Object)nettyServerCnxn.getChannel().remoteAddress());
                ServerMetrics.getMetrics().CNXN_CLOSED_WITHOUT_ZK_SERVER_RUNNING.add(1L);
                channel.close();
                return;
            }
            if (NettyServerCnxnFactory.this.handshakeThrottlingEnabled) {
                n2 = NettyServerCnxnFactory.this.outstandingHandshake.addAndGet(1);
                if (n2 > NettyServerCnxnFactory.this.outstandingHandshakeLimit) {
                    NettyServerCnxnFactory.this.outstandingHandshake.addAndGet(-1);
                    channel.close();
                    ServerMetrics.getMetrics().TLS_HANDSHAKE_EXCEEDED.add(1L);
                } else {
                    nettyServerCnxn.setHandshakeState(NettyServerCnxn.HandshakeState.STARTED);
                }
            }
            if (NettyServerCnxnFactory.this.secure) {
                SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(SslHandler.class);
                Future<Channel> future = sslHandler.handshakeFuture();
                future.addListener((GenericFutureListener)new CertificateVerifier(sslHandler, nettyServerCnxn));
            } else if (!NettyServerCnxnFactory.this.shouldUsePortUnification) {
                NettyServerCnxnFactory.this.allChannels.add((Object)channelHandlerContext.channel());
                NettyServerCnxnFactory.this.addCnxn(nettyServerCnxn);
            }
            if (channelHandlerContext.channel().pipeline().get(SslHandler.class) == null) {
                if (NettyServerCnxnFactory.this.zkServer != null) {
                    SocketAddress socketAddress = nettyServerCnxn.getChannel().remoteAddress();
                    if (socketAddress != null && !((InetSocketAddress)socketAddress).getAddress().isLoopbackAddress()) {
                        LOG.a("NettyChannelHandler channelActive: remote={} local={}", (Object)socketAddress, (Object)nettyServerCnxn.getChannel().localAddress());
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementNonMTLSRemoteConnCount();
                    } else {
                        NettyServerCnxnFactory.this.zkServer.serverStats().incrementNonMTLSLocalConnCount();
                    }
                } else {
                    LOG.a("Opened non-TLS connection from {} but zkServer is not running", (Object)nettyServerCnxn.getChannel().remoteAddress());
                }
            }
        }

        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            if (LOG.b()) {
                LOG.a("Channel inactive {}", (Object)channelHandlerContext.channel());
            }
            NettyServerCnxnFactory.this.allChannels.remove((Object)channelHandlerContext.channel());
            NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (nettyServerCnxn != null) {
                if (LOG.b()) {
                    LOG.a("Channel inactive caused close {}", (Object)nettyServerCnxn);
                }
                NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(nettyServerCnxn);
                nettyServerCnxn.close(ServerCnxn.DisconnectReason.CHANNEL_DISCONNECTED);
            }
        }

        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            LOG.c("Exception caught", throwable);
            NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).getAndSet(null);
            if (nettyServerCnxn != null) {
                LOG.b("Closing {}", (Object)nettyServerCnxn);
                NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(nettyServerCnxn);
                nettyServerCnxn.close(ServerCnxn.DisconnectReason.CHANNEL_CLOSED_EXCEPTION);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            try {
                if (object == NettyServerCnxn.ReadEvent.ENABLE) {
                    LOG.b("Received ReadEvent.ENABLE");
                    NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get();
                    if (nettyServerCnxn != null && nettyServerCnxn.getQueuedReadableBytes() > 0) {
                        nettyServerCnxn.processQueuedBuffer();
                        if (NettyServerCnxnFactory.this.advancedFlowControlEnabled && nettyServerCnxn.getQueuedReadableBytes() == 0) {
                            channelHandlerContext.read();
                            LOG.b("Issued a read after queuedBuffer drained");
                        }
                    }
                    if (!NettyServerCnxnFactory.this.advancedFlowControlEnabled) {
                        channelHandlerContext.channel().config().setAutoRead(true);
                    }
                } else if (object == NettyServerCnxn.ReadEvent.DISABLE) {
                    LOG.b("Received ReadEvent.DISABLE");
                    channelHandlerContext.channel().config().setAutoRead(false);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            try {
                if (LOG.b()) {
                    LOG.a("message received called {}", object);
                }
                try {
                    LOG.b("New message {} from {}", object, (Object)channelHandlerContext.channel());
                    NettyServerCnxn nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get();
                    if (nettyServerCnxn == null) {
                        LOG.e("channelRead() on a closed or closing NettyServerCnxn");
                    } else {
                        nettyServerCnxn.processMessage((ByteBuf)object);
                    }
                }
                catch (Exception exception) {
                    LOG.d("Unexpected exception in receive", exception);
                    throw exception;
                }
            }
            finally {
                ReferenceCountUtil.release((Object)object);
            }
        }

        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
            NettyServerCnxn nettyServerCnxn;
            if (NettyServerCnxnFactory.this.advancedFlowControlEnabled && (nettyServerCnxn = (NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get()) != null && nettyServerCnxn.getQueuedReadableBytes() == 0 && nettyServerCnxn.readIssuedAfterReadComplete == 0) {
                channelHandlerContext.read();
                LOG.b("Issued a read since we do not have anything to consume after channelReadComplete");
            }
            channelHandlerContext.fireChannelReadComplete();
        }

        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            if (LOG.b()) {
                channelPromise.addListener(this.onWriteCompletedTracer);
            }
            super.write(channelHandlerContext, object, channelPromise);
        }
    }

    class DualModeSslHandler
    extends OptionalSslHandler {
        DualModeSslHandler(SslContext sslContext) {
            super(sslContext);
        }

        @Override
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            if (byteBuf.readableBytes() >= 5) {
                super.decode(channelHandlerContext, byteBuf, list);
            } else if (byteBuf.readableBytes() > 0 && 22 != byteBuf.getByte(0)) {
                LOG.b("first byte {} does not match TLS handshake, failing to plaintext", (Object)byteBuf.getByte(0));
                this.handleNonSsl(channelHandlerContext);
            }
        }

        private void handleNonSsl(ChannelHandlerContext channelHandlerContext) {
            ChannelHandler channelHandler = this.newNonSslHandler(channelHandlerContext);
            if (channelHandler != null) {
                channelHandlerContext.pipeline().replace((ChannelHandler)this, this.newNonSslHandlerName(), channelHandler);
            } else {
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
            }
        }

        @Override
        protected SslHandler newSslHandler(ChannelHandlerContext channelHandlerContext, SslContext sslContext) {
            NettyServerCnxn nettyServerCnxn = Objects.requireNonNull((NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get());
            LOG.b("creating ssl handler for session {}", (Object)nettyServerCnxn.getSessionId());
            SslHandler sslHandler = super.newSslHandler(channelHandlerContext, sslContext);
            Future<Channel> future = sslHandler.handshakeFuture();
            future.addListener((GenericFutureListener)new CertificateVerifier(sslHandler, nettyServerCnxn));
            return sslHandler;
        }

        @Override
        protected ChannelHandler newNonSslHandler(ChannelHandlerContext channelHandlerContext) {
            NettyServerCnxn nettyServerCnxn = Objects.requireNonNull((NettyServerCnxn)channelHandlerContext.channel().attr(CONNECTION_ATTRIBUTE).get());
            LOG.b("creating plaintext handler for session {}", (Object)nettyServerCnxn.getSessionId());
            NettyServerCnxnFactory.this.updateHandshakeCountIfStarted(nettyServerCnxn);
            NettyServerCnxnFactory.this.allChannels.add((Object)channelHandlerContext.channel());
            NettyServerCnxnFactory.this.addCnxn(nettyServerCnxn);
            return super.newNonSslHandler(channelHandlerContext);
        }
    }
}

