/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiOperationRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.OpResult;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.AuditHelper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.AddWatchRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CheckWatchesRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.Create2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ErrorResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ExistsRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ExistsResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetAllChildrenNumberRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildren2Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildren2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetEphemeralsRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetEphemeralsResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RemoveWatchesRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetWatches;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetWatches2;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SyncRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SyncResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.WhoAmIResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.AuthUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.ErrorTxn;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final foe LOG = goe.a(FinalRequestProcessor.class);
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zooKeeperServer) {
        this.zks = zooKeeperServer;
        this.requestPathMetricsCollector = zooKeeperServer.getRequestPathMetricsCollector();
    }

    private DataTree.ProcessTxnResult applyRequest(Request request) {
        long l2;
        DataTree.ProcessTxnResult processTxnResult = this.zks.processTxn(request);
        if (request.type == -11 && this.connClosedByClient(request) && (this.closeSession(this.zks.serverCnxnFactory, request.sessionId) || this.closeSession(this.zks.secureServerCnxnFactory, request.sessionId))) {
            return processTxnResult;
        }
        if (request.getHdr() != null && (l2 = Time.currentWallTime() - request.getHdr().getTime()) >= 0L) {
            ServerMetrics.getMetrics().PROPAGATION_LATENCY.add(l2);
        }
        return processTxnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request request) {
        Iterator<DataTree.ProcessTxnResult> iterator;
        Object object;
        LOG.b("Processing request:: {}", (Object)request);
        if (LOG.b()) {
            long l2 = 2L;
            if (request.type == 11) {
                l2 = 128L;
            }
            ZooTrace.logRequest(LOG, l2, 'E', request, "");
        }
        DataTree.ProcessTxnResult processTxnResult = null;
        if (!request.isThrottled()) {
            processTxnResult = this.applyRequest(request);
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn serverCnxn = request.cnxn;
        long l3 = this.zks.getZKDatabase().getDataTreeLastProcessedZxid();
        String string = "NA";
        this.zks.decInProcess();
        this.zks.requestFinished(request);
        KeeperException.Code code = KeeperException.Code.OK;
        mme mme2 = null;
        String string2 = null;
        int n2 = 0;
        try {
            if (request.getHdr() != null && request.getHdr().getType() == -1) {
                AuditHelper.addAuditLog(request, processTxnResult, true);
                if (request.getException() != null) {
                    throw request.getException();
                }
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.getTxn()).getErr()));
            }
            object = request.getException();
            if (object instanceof KeeperException.SessionMovedException) {
                throw object;
            }
            if (object != null && request.type != 14) {
                throw object;
            }
            LOG.b("{}", (Object)request);
            if (request.isStale()) {
                ServerMetrics.getMetrics().STALE_REPLIES.add(1L);
            }
            if (request.isThrottled()) {
                throw KeeperException.create(KeeperException.Code.THROTTLEDOP);
            }
            AuditHelper.addAuditLog(request, processTxnResult);
            switch (request.type) {
                case 11: {
                    string = "PING";
                    this.updateStats(request, string, l3);
                    n2 = serverCnxn.sendResponse(new ReplyHeader(-2, l3, 0), null, "response");
                    return;
                }
                case -10: {
                    string = "SESS";
                    this.updateStats(request, string, l3);
                    this.zks.finishSessionInit(request.cnxn, true);
                    return;
                }
                case 14: {
                    string = "MULT";
                    mme2 = new MultiResponse();
                    for (DataTree.ProcessTxnResult processTxnResult2 : processTxnResult.multiResult) {
                        OpResult opResult;
                        switch (processTxnResult2.type) {
                            case 13: {
                                opResult = new OpResult.CheckResult();
                                break;
                            }
                            case 1: {
                                opResult = new OpResult.CreateResult(processTxnResult2.path);
                                break;
                            }
                            case 15: 
                            case 19: 
                            case 21: {
                                opResult = new OpResult.CreateResult(processTxnResult2.path, processTxnResult2.stat);
                                break;
                            }
                            case 2: 
                            case 20: {
                                opResult = new OpResult.DeleteResult();
                                break;
                            }
                            case 5: {
                                opResult = new OpResult.SetDataResult(processTxnResult2.stat);
                                break;
                            }
                            case -1: {
                                opResult = new OpResult.ErrorResult(processTxnResult2.err);
                                if (processTxnResult2.err != KeeperException.Code.SESSIONMOVED.intValue()) break;
                                throw new KeeperException.SessionMovedException();
                            }
                            default: {
                                throw new IOException("Invalid type of op");
                            }
                        }
                        ((MultiResponse)mme2).add(opResult);
                    }
                    break;
                }
                case 22: {
                    string = "MLTR";
                    iterator = request.readRequestRecord(MultiOperationRecord::new);
                    mme2 = new MultiResponse();
                    Iterator<Op> iterator2 = ((MultiOperationRecord)((Object)iterator)).iterator();
                    while (iterator2.hasNext()) {
                        OpResult opResult;
                        Op op2 = iterator2.next();
                        try {
                            switch (op2.getType()) {
                                case 8: {
                                    mme mme3 = this.handleGetChildrenRequest(op2.toRequestRecord(), serverCnxn, request.authInfo);
                                    opResult = new OpResult.GetChildrenResult(((GetChildrenResponse)mme3).getChildren());
                                    break;
                                }
                                case 4: {
                                    mme mme3 = this.handleGetDataRequest(op2.toRequestRecord(), serverCnxn, request.authInfo);
                                    GetDataResponse getDataResponse = (GetDataResponse)mme3;
                                    opResult = new OpResult.GetDataResult(getDataResponse.getData(), getDataResponse.getStat());
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of readOp");
                                }
                            }
                        }
                        catch (KeeperException keeperException) {
                            opResult = new OpResult.ErrorResult(keeperException.code().intValue());
                        }
                        ((MultiResponse)mme2).add(opResult);
                    }
                    break;
                }
                case 1: {
                    string = "CREA";
                    mme2 = new CreateResponse(processTxnResult.path);
                    code = KeeperException.Code.get(processTxnResult.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, processTxnResult.path);
                    break;
                }
                case 15: 
                case 19: 
                case 21: {
                    string = "CREA";
                    mme2 = new Create2Response(processTxnResult.path, processTxnResult.stat);
                    code = KeeperException.Code.get(processTxnResult.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, processTxnResult.path);
                    break;
                }
                case 2: 
                case 20: {
                    string = "DELE";
                    code = KeeperException.Code.get(processTxnResult.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, processTxnResult.path);
                    break;
                }
                case 5: {
                    string = "SETD";
                    mme2 = new SetDataResponse(processTxnResult.stat);
                    code = KeeperException.Code.get(processTxnResult.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, processTxnResult.path);
                    break;
                }
                case 16: {
                    string = "RECO";
                    mme2 = new GetDataResponse(((QuorumZooKeeperServer)this.zks).self.getQuorumVerifier().toString().getBytes(StandardCharsets.UTF_8), processTxnResult.stat);
                    code = KeeperException.Code.get(processTxnResult.err);
                    break;
                }
                case 7: {
                    string = "SETA";
                    mme2 = new SetACLResponse(processTxnResult.stat);
                    code = KeeperException.Code.get(processTxnResult.err);
                    this.requestPathMetricsCollector.registerRequest(request.type, processTxnResult.path);
                    break;
                }
                case -11: {
                    string = "CLOS";
                    code = KeeperException.Code.get(processTxnResult.err);
                    break;
                }
                case 9: {
                    string = "SYNC";
                    iterator = request.readRequestRecord(SyncRequest::new);
                    mme2 = new SyncResponse(((SyncRequest)((Object)iterator)).getPath());
                    this.requestPathMetricsCollector.registerRequest(request.type, ((SyncRequest)((Object)iterator)).getPath());
                    break;
                }
                case 13: {
                    string = "CHEC";
                    mme2 = new SetDataResponse(processTxnResult.stat);
                    code = KeeperException.Code.get(processTxnResult.err);
                    break;
                }
                case 3: {
                    string = "EXIS";
                    iterator = request.readRequestRecord(ExistsRequest::new);
                    string2 = ((ExistsRequest)((Object)iterator)).getPath();
                    if (string2.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    DataNode dataNode = this.zks.getZKDatabase().getNode(string2);
                    if (dataNode != null) {
                        this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(dataNode), 1, request.authInfo, string2, null);
                    }
                    Stat stat = this.zks.getZKDatabase().statNode(string2, ((ExistsRequest)((Object)iterator)).getWatch() ? serverCnxn : null);
                    mme2 = new ExistsResponse(stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, string2);
                    break;
                }
                case 4: {
                    string = "GETD";
                    iterator = request.readRequestRecord(GetDataRequest::new);
                    string2 = ((GetDataRequest)((Object)iterator)).getPath();
                    mme2 = this.handleGetDataRequest((mme)((Object)iterator), serverCnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, string2);
                    break;
                }
                case 101: {
                    string = "SETW";
                    iterator = request.readRequestRecord(SetWatches::new);
                    long l4 = ((SetWatches)((Object)iterator)).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(l4, ((SetWatches)((Object)iterator)).getDataWatches(), ((SetWatches)((Object)iterator)).getExistWatches(), ((SetWatches)((Object)iterator)).getChildWatches(), Collections.emptyList(), Collections.emptyList(), serverCnxn);
                    break;
                }
                case 105: {
                    string = "STW2";
                    iterator = request.readRequestRecord(SetWatches2::new);
                    long l5 = ((SetWatches2)((Object)iterator)).getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(l5, ((SetWatches2)((Object)iterator)).getDataWatches(), ((SetWatches2)((Object)iterator)).getExistWatches(), ((SetWatches2)((Object)iterator)).getChildWatches(), ((SetWatches2)((Object)iterator)).getPersistentWatches(), ((SetWatches2)((Object)iterator)).getPersistentRecursiveWatches(), serverCnxn);
                    break;
                }
                case 106: {
                    string = "ADDW";
                    iterator = request.readRequestRecord(AddWatchRequest::new);
                    this.zks.getZKDatabase().addWatch(((AddWatchRequest)((Object)iterator)).getPath(), serverCnxn, ((AddWatchRequest)((Object)iterator)).getMode());
                    mme2 = new ErrorResponse(0);
                    break;
                }
                case 6: {
                    string = "GETA";
                    iterator = request.readRequestRecord(GetACLRequest::new);
                    string2 = ((GetACLRequest)((Object)iterator)).getPath();
                    DataNode dataNode = this.zks.getZKDatabase().getNode(string2);
                    if (dataNode == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(dataNode), 17, request.authInfo, string2, null);
                    Stat stat = new Stat();
                    List<ACL> list = this.zks.getZKDatabase().getACL(string2, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, ((GetACLRequest)((Object)iterator)).getPath());
                    try {
                        this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(dataNode), 16, request.authInfo, string2, null);
                        mme2 = new GetACLResponse(list, stat);
                    }
                    catch (KeeperException.NoAuthException noAuthException) {
                        ArrayList<ACL> arrayList = new ArrayList<ACL>(list.size());
                        for (ACL aCL : list) {
                            if ("digest".equals(aCL.getId().getScheme())) {
                                Id id2 = aCL.getId();
                                Id id3 = new Id(id2.getScheme(), id2.getId().replaceAll(":.*", ":x"));
                                arrayList.add(new ACL(aCL.getPerms(), id3));
                                continue;
                            }
                            arrayList.add(aCL);
                        }
                        mme2 = new GetACLResponse(arrayList, stat);
                    }
                    break;
                }
                case 8: {
                    string = "GETC";
                    iterator = request.readRequestRecord(GetChildrenRequest::new);
                    string2 = ((GetChildrenRequest)((Object)iterator)).getPath();
                    mme2 = this.handleGetChildrenRequest((mme)((Object)iterator), serverCnxn, request.authInfo);
                    this.requestPathMetricsCollector.registerRequest(request.type, string2);
                    break;
                }
                case 104: {
                    string = "GETACN";
                    iterator = request.readRequestRecord(GetAllChildrenNumberRequest::new);
                    string2 = ((GetAllChildrenNumberRequest)((Object)iterator)).getPath();
                    DataNode dataNode = this.zks.getZKDatabase().getNode(string2);
                    if (dataNode == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(dataNode), 1, request.authInfo, string2, null);
                    int n3 = this.zks.getZKDatabase().getAllChildrenNumber(string2);
                    mme2 = new GetAllChildrenNumberResponse(n3);
                    break;
                }
                case 12: {
                    string = "GETC";
                    iterator = request.readRequestRecord(GetChildren2Request::new);
                    Stat stat = new Stat();
                    string2 = ((GetChildren2Request)((Object)iterator)).getPath();
                    DataNode dataNode = this.zks.getZKDatabase().getNode(string2);
                    if (dataNode == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    this.zks.checkACL(request.cnxn, this.zks.getZKDatabase().aclForNode(dataNode), 1, request.authInfo, string2, null);
                    List<String> list = this.zks.getZKDatabase().getChildren(string2, stat, ((GetChildren2Request)((Object)iterator)).getWatch() ? serverCnxn : null);
                    mme2 = new GetChildren2Response(list, stat);
                    this.requestPathMetricsCollector.registerRequest(request.type, string2);
                    break;
                }
                case 17: {
                    string = "CHKW";
                    iterator = request.readRequestRecord(CheckWatchesRequest::new);
                    Watcher.WatcherType watcherType = Watcher.WatcherType.fromInt(((CheckWatchesRequest)((Object)iterator)).getType());
                    string2 = ((CheckWatchesRequest)((Object)iterator)).getPath();
                    boolean bl2 = this.zks.getZKDatabase().containsWatcher(string2, watcherType, serverCnxn);
                    if (!bl2) {
                        String string3 = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{string2, watcherType});
                        throw new KeeperException.NoWatcherException(string3);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, ((CheckWatchesRequest)((Object)iterator)).getPath());
                    break;
                }
                case 18: {
                    string = "REMW";
                    iterator = request.readRequestRecord(RemoveWatchesRequest::new);
                    Watcher.WatcherType watcherType = Watcher.WatcherType.fromInt(((RemoveWatchesRequest)((Object)iterator)).getType());
                    string2 = ((RemoveWatchesRequest)((Object)iterator)).getPath();
                    boolean bl3 = this.zks.getZKDatabase().removeWatch(string2, watcherType, serverCnxn);
                    if (!bl3) {
                        String string4 = String.format(Locale.ENGLISH, "%s (type: %s)", new Object[]{string2, watcherType});
                        throw new KeeperException.NoWatcherException(string4);
                    }
                    this.requestPathMetricsCollector.registerRequest(request.type, ((RemoveWatchesRequest)((Object)iterator)).getPath());
                    break;
                }
                case 107: {
                    string = "HOMI";
                    mme2 = new WhoAmIResponse(AuthUtil.getClientInfos(request.authInfo));
                    break;
                }
                case 103: {
                    string = "GETE";
                    iterator = request.readRequestRecord(GetEphemeralsRequest::new);
                    String string5 = ((GetEphemeralsRequest)((Object)iterator)).getPrefixPath();
                    Set<String> set = this.zks.getZKDatabase().getDataTree().getEphemerals(request.sessionId);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string5 == null || string5.trim().isEmpty() || "/".equals(string5.trim())) {
                        arrayList.addAll(set);
                    } else {
                        for (String string6 : set) {
                            if (!string6.startsWith(string5)) continue;
                            arrayList.add(string6);
                        }
                    }
                    mme2 = new GetEphemeralsResponse(arrayList);
                    break;
                }
            }
        }
        catch (KeeperException.SessionMovedException sessionMovedException) {
            serverCnxn.sendCloseSession();
            return;
        }
        catch (KeeperException keeperException) {
            code = keeperException.code();
        }
        catch (Exception exception) {
            LOG.e("Failed to process {}", (Object)request, (Object)exception);
            iterator = request.requestDigest();
            LOG.e("Dumping request buffer for request type {}: 0x{}", (Object)Request.op2String(request.type), (Object)iterator);
            code = KeeperException.Code.MARSHALLINGERROR;
        }
        object = new ReplyHeader(request.cxid, l3, code.intValue());
        this.updateStats(request, string, l3);
        try {
            if (string2 == null || mme2 == null) {
                n2 = serverCnxn.sendResponse((ReplyHeader)object, mme2, "response");
            } else {
                int n4 = request.type;
                Stat stat = null;
                switch (n4) {
                    case 4: {
                        GetDataResponse getDataResponse = (GetDataResponse)mme2;
                        stat = getDataResponse.getStat();
                        n2 = serverCnxn.sendResponse((ReplyHeader)object, mme2, "response", string2, stat, n4);
                        break;
                    }
                    case 12: {
                        GetChildren2Response getChildren2Response = (GetChildren2Response)mme2;
                        stat = getChildren2Response.getStat();
                        n2 = serverCnxn.sendResponse((ReplyHeader)object, mme2, "response", string2, stat, n4);
                        break;
                    }
                    default: {
                        n2 = serverCnxn.sendResponse((ReplyHeader)object, mme2, "response");
                    }
                }
            }
            if (request.type == -11) {
                serverCnxn.sendCloseSession();
            }
        }
        catch (IOException iOException) {
            LOG.d("FIXMSG", iOException);
        }
        finally {
            ServerMetrics.getMetrics().RESPONSE_BYTES.add(n2);
        }
    }

    private mme handleGetChildrenRequest(mme mme2, ServerCnxn serverCnxn, List<Id> list) throws KeeperException, IOException {
        GetChildrenRequest getChildrenRequest = (GetChildrenRequest)mme2;
        String string = getChildrenRequest.getPath();
        DataNode dataNode = this.zks.getZKDatabase().getNode(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(serverCnxn, this.zks.getZKDatabase().aclForNode(dataNode), 1, list, string, null);
        List<String> list2 = this.zks.getZKDatabase().getChildren(string, null, getChildrenRequest.getWatch() ? serverCnxn : null);
        return new GetChildrenResponse(list2);
    }

    private mme handleGetDataRequest(mme mme2, ServerCnxn serverCnxn, List<Id> list) throws KeeperException, IOException {
        GetDataRequest getDataRequest = (GetDataRequest)mme2;
        String string = getDataRequest.getPath();
        DataNode dataNode = this.zks.getZKDatabase().getNode(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        this.zks.checkACL(serverCnxn, this.zks.getZKDatabase().aclForNode(dataNode), 1, list, string, null);
        Stat stat = new Stat();
        byte[] byArray = this.zks.getZKDatabase().getData(string, stat, getDataRequest.getWatch() ? serverCnxn : null);
        return new GetDataResponse(byArray, stat);
    }

    private boolean closeSession(ServerCnxnFactory serverCnxnFactory, long l2) {
        if (serverCnxnFactory == null) {
            return false;
        }
        return serverCnxnFactory.closeSession(l2, ServerCnxn.DisconnectReason.CLIENT_CLOSED_SESSION);
    }

    private boolean connClosedByClient(Request request) {
        return request.cnxn == null;
    }

    @Override
    public void shutdown() {
        LOG.c("shutdown of request processor complete");
    }

    private void updateStats(Request request, String string, long l2) {
        if (request.cnxn == null) {
            return;
        }
        long l3 = Time.currentElapsedTime();
        this.zks.serverStats().updateLatency(request, l3);
        request.cnxn.updateStatsForResponse(request.cxid, l2, string, request.createTime, l3);
    }
}

