/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.DigestWatcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooDefs;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.AuditEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.ZKAuditProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathTrie;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ByteBufferInputStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DigestCalculator;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NodeHashMap;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.NodeHashMapImpl;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RateLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ReferenceCountedACLCache;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerMetrics;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.IWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchManagerFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatcherOrBitSet;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesPathReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesReport;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.WatchesSummary;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CheckVersionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CloseSessionTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateContainerTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTTLTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.CreateTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.DeleteTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.ErrorTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.MultiTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetACLTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.SetDataTxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.Txn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnDigest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.txn.TxnHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class DataTree {
    private static final foe LOG = goe.a(DataTree.class);
    private final RateLogger RATE_LOGGER = new RateLogger(LOG, 900000L);
    private final NodeHashMap nodes;
    private IWatchManager dataWatches;
    private IWatchManager childWatches;
    private final AtomicLong nodeDataSize = new AtomicLong(0L);
    private static final String rootZookeeper = "/";
    private static final String procZookeeper = "/zookeeper";
    private static final String procChildZookeeper = "/zookeeper".substring(1);
    private static final String quotaZookeeper = "/zookeeper/quota";
    private static final String quotaChildZookeeper = "/zookeeper/quota".substring("/zookeeper".length() + 1);
    private static final String configZookeeper = "/zookeeper/config";
    private static final String configChildZookeeper = "/zookeeper/config".substring("/zookeeper".length() + 1);
    private final PathTrie pTrie = new PathTrie();
    public static final int STAT_OVERHEAD_BYTES = 68;
    private final Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private final Set<String> containers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> ttls = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceCountedACLCache aclCache = new ReferenceCountedACLCache();
    public static final int DIGEST_LOG_LIMIT = 1024;
    public static final int DIGEST_LOG_INTERVAL = 128;
    private ZxidDigest digestFromLoadedSnapshot;
    private volatile ZxidDigest lastProcessedZxidDigest;
    private boolean firstMismatchTxn = true;
    private final List<DigestWatcher> digestWatchers = new ArrayList<DigestWatcher>();
    private final LinkedList<ZxidDigest> digestLog = new LinkedList();
    private final DigestCalculator digestCalculator;
    private DataNode root = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode procDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode quotaDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEphemerals(long l2) {
        HashSet<String> hashSet = this.ephemerals.get(l2);
        if (hashSet == null) {
            return new HashSet<String>();
        }
        HashSet<String> hashSet2 = hashSet;
        synchronized (hashSet2) {
            return (HashSet)hashSet.clone();
        }
    }

    public Set<String> getContainers() {
        return new HashSet<String>(this.containers);
    }

    public Set<String> getTtls() {
        return new HashSet<String>(this.ttls);
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public DataNode getNode(String string) {
        return this.nodes.get(string);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public int getEphemeralsCount() {
        int n2 = 0;
        for (HashSet<String> hashSet : this.ephemerals.values()) {
            n2 += hashSet.size();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approximateDataSize() {
        long l2 = 0L;
        for (Map.Entry<String, DataNode> entry : this.nodes.entrySet()) {
            DataNode dataNode;
            DataNode dataNode2 = dataNode = entry.getValue();
            synchronized (dataNode2) {
                l2 += DataTree.getNodeSize(entry.getKey(), dataNode.data);
            }
        }
        return l2;
    }

    private static long getNodeSize(String string, byte[] byArray) {
        return (string == null ? 0 : string.length()) + (byArray == null ? 0 : byArray.length);
    }

    public long cachedApproximateDataSize() {
        return this.nodeDataSize.get();
    }

    public DataTree() {
        this(new DigestCalculator());
    }

    DataTree(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
        this.nodes = new NodeHashMapImpl(digestCalculator);
        this.nodes.put("", this.root);
        this.nodes.putWithoutDigest(rootZookeeper, this.root);
        this.root.addChild(procChildZookeeper);
        this.nodes.put(procZookeeper, this.procDataNode);
        this.procDataNode.addChild(quotaChildZookeeper);
        this.nodes.put(quotaZookeeper, this.quotaDataNode);
        this.addConfigNode();
        this.nodeDataSize.set(this.approximateDataSize());
        try {
            this.dataWatches = WatchManagerFactory.createWatchManager();
            this.childWatches = WatchManagerFactory.createWatchManager();
        }
        catch (Exception exception) {
            LOG.d("Unexpected exception when creating WatchManager, exiting abnormally", exception);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public void addConfigNode() {
        block5: {
            DataNode dataNode = this.nodes.get(procZookeeper);
            if (dataNode != null) {
                dataNode.addChild(configChildZookeeper);
            } else assert (false) : "There's no /zookeeper znode - this should never happen.";
            this.nodes.put(configZookeeper, new DataNode(new byte[0], -1L, new StatPersisted()));
            try {
                this.setACL(configZookeeper, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"There's no /zookeeper/config znode - this should never happen.");
            }
        }
    }

    boolean isSpecialPath(String string) {
        return rootZookeeper.equals(string) || procZookeeper.equals(string) || quotaZookeeper.equals(string) || configZookeeper.equals(string);
    }

    public static void copyStatPersisted(StatPersisted statPersisted, StatPersisted statPersisted2) {
        statPersisted2.setAversion(statPersisted.getAversion());
        statPersisted2.setCtime(statPersisted.getCtime());
        statPersisted2.setCversion(statPersisted.getCversion());
        statPersisted2.setCzxid(statPersisted.getCzxid());
        statPersisted2.setMtime(statPersisted.getMtime());
        statPersisted2.setMzxid(statPersisted.getMzxid());
        statPersisted2.setPzxid(statPersisted.getPzxid());
        statPersisted2.setVersion(statPersisted.getVersion());
        statPersisted2.setEphemeralOwner(statPersisted.getEphemeralOwner());
    }

    public static void copyStat(Stat stat, Stat stat2) {
        stat2.setAversion(stat.getAversion());
        stat2.setCtime(stat.getCtime());
        stat2.setCversion(stat.getCversion());
        stat2.setCzxid(stat.getCzxid());
        stat2.setMtime(stat.getMtime());
        stat2.setMzxid(stat.getMzxid());
        stat2.setPzxid(stat.getPzxid());
        stat2.setVersion(stat.getVersion());
        stat2.setEphemeralOwner(stat.getEphemeralOwner());
        stat2.setDataLength(stat.getDataLength());
        stat2.setNumChildren(stat.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuotaStat(String string, long l2, int n2) {
        String string2 = Quotas.statPath(string);
        DataNode dataNode = this.nodes.get(string2);
        if (dataNode == null) {
            LOG.e("Missing node for stat {}", (Object)string2);
            return;
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            StatsTrack statsTrack = new StatsTrack(dataNode.data);
            statsTrack.setCount(statsTrack.getCount() + (long)n2);
            statsTrack.setBytes(statsTrack.getBytes() + l2);
            dataNode.data = statsTrack.getStatsBytes();
        }
    }

    public void createNode(String string, byte[] byArray, List<ACL> list, long l2, int n2, long l3, long l4) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        this.createNode(string, byArray, list, l2, n2, l3, l4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNode(String string, byte[] byArray, List<ACL> list, long l3, int n2, long l4, long l5, Stat stat) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        long l6;
        List<ACL> list2;
        int n3 = string.lastIndexOf(47);
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        StatPersisted statPersisted = DataTree.createStat(l4, l5, l3);
        DataNode dataNode = this.nodes.get(string2);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        Object object = dataNode;
        synchronized (object) {
            list2 = this.getACL(dataNode);
            Long l7 = this.aclCache.convertAcls(list);
            Set<String> set = dataNode.getChildren();
            if (set.contains(string3)) {
                throw new KeeperException.NodeExistsException();
            }
            this.nodes.preChange(string2, dataNode);
            if (n2 == -1) {
                n2 = dataNode.stat.getCversion();
                ++n2;
            }
            if (n2 > dataNode.stat.getCversion()) {
                dataNode.stat.setCversion(n2);
                dataNode.stat.setPzxid(l4);
            }
            DataNode dataNode2 = new DataNode(byArray, l7, statPersisted);
            dataNode.addChild(string3);
            this.nodes.postChange(string2, dataNode);
            this.nodeDataSize.addAndGet(DataTree.getNodeSize(string, dataNode2.data));
            this.nodes.put(string, dataNode2);
            EphemeralType ephemeralType = EphemeralType.get(l3);
            if (ephemeralType == EphemeralType.CONTAINER) {
                this.containers.add(string);
            } else if (ephemeralType == EphemeralType.TTL) {
                this.ttls.add(string);
            } else if (l3 != 0L) {
                HashSet hashSet;
                HashSet hashSet2 = hashSet = this.ephemerals.computeIfAbsent(l3, l2 -> new HashSet());
                synchronized (hashSet2) {
                    hashSet.add(string);
                }
            }
            if (stat != null) {
                dataNode2.copyStat(stat);
            }
        }
        if (string2.startsWith(quotaZookeeper)) {
            if ("zookeeper_limits".equals(string3)) {
                this.pTrie.addPath(Quotas.trimQuotaPath(string2));
            }
            if ("zookeeper_stats".equals(string3)) {
                this.updateQuotaForPath(Quotas.trimQuotaPath(string2));
            }
        }
        object = this.getMaxPrefixWithQuota(string);
        long l8 = l6 = byArray == null ? 0L : (long)byArray.length;
        if (object != null) {
            this.updateQuotaStat((String)object, l6, 1);
        }
        this.updateWriteStat(string, l6);
        this.dataWatches.triggerWatch(string, Watcher.Event.EventType.NodeCreated, l4, list);
        this.childWatches.triggerWatch(string2.equals("") ? rootZookeeper : string2, Watcher.Event.EventType.NodeChildrenChanged, l4, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String string, long l2) throws KeeperException.NoNodeException {
        Object object;
        long l3;
        List<ACL> list;
        int n2 = string.lastIndexOf(47);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        DataNode dataNode = this.nodes.get(string2);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            this.nodes.preChange(string2, dataNode);
            dataNode.removeChild(string3);
            if (l2 > dataNode.stat.getPzxid()) {
                dataNode.stat.setPzxid(l2);
            }
            this.nodes.postChange(string2, dataNode);
        }
        dataNode2 = this.nodes.get(string);
        if (dataNode2 == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(string);
        Object object2 = dataNode2;
        synchronized (object2) {
            list = this.getACL(dataNode2);
            this.aclCache.removeUsage(dataNode2.acl);
            this.nodeDataSize.addAndGet(-DataTree.getNodeSize(string, dataNode2.data));
        }
        Object object3 = dataNode;
        synchronized (object3) {
            Set set;
            object2 = this.getACL(dataNode);
            l3 = dataNode2.stat.getEphemeralOwner();
            object = EphemeralType.get(l3);
            if (object == EphemeralType.CONTAINER) {
                this.containers.remove(string);
            } else if (object == EphemeralType.TTL) {
                this.ttls.remove(string);
            } else if (l3 != 0L && (set = (Set)this.ephemerals.get(l3)) != null) {
                Set set2 = set;
                synchronized (set2) {
                    set.remove(string);
                }
            }
        }
        if (string2.startsWith(procZookeeper) && "zookeeper_limits".equals(string3)) {
            this.pTrie.deletePath(Quotas.trimQuotaPath(string2));
        }
        if ((object3 = this.getMaxPrefixWithQuota(string)) != null) {
            object = dataNode2;
            synchronized (object) {
                l3 = dataNode2.data == null ? 0 : -dataNode2.data.length;
            }
            this.updateQuotaStat((String)object3, l3, -1);
        }
        this.updateWriteStat(string, 0L);
        if (LOG.b()) {
            ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + string);
            ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + string2);
        }
        WatcherOrBitSet watcherOrBitSet = this.dataWatches.triggerWatch(string, Watcher.Event.EventType.NodeDeleted, l2, list);
        this.childWatches.triggerWatch(string, Watcher.Event.EventType.NodeDeleted, l2, list, watcherOrBitSet);
        this.childWatches.triggerWatch("".equals(string2) ? rootZookeeper : string2, Watcher.Event.EventType.NodeChildrenChanged, l2, (List<ACL>)object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String string, byte[] byArray, int n2, long l2, long l3) throws KeeperException.NoNodeException {
        long l4;
        byte[] byArray2;
        List<ACL> list;
        Stat stat = new Stat();
        DataNode dataNode = this.nodes.get(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        Object object = dataNode;
        synchronized (object) {
            list = this.getACL(dataNode);
            byArray2 = dataNode.data;
            this.nodes.preChange(string, dataNode);
            dataNode.data = byArray;
            dataNode.stat.setMtime(l3);
            dataNode.stat.setMzxid(l2);
            dataNode.stat.setVersion(n2);
            dataNode.copyStat(stat);
            this.nodes.postChange(string, dataNode);
        }
        object = this.getMaxPrefixWithQuota(string);
        long l5 = (byArray == null ? 0 : byArray.length) - (byArray2 == null ? 0 : byArray2.length);
        long l6 = l4 = byArray == null ? 0L : (long)byArray.length;
        if (object != null) {
            this.updateQuotaStat((String)object, l5, 0);
        }
        this.nodeDataSize.addAndGet(DataTree.getNodeSize(string, byArray) - DataTree.getNodeSize(string, byArray2));
        this.updateWriteStat(string, l4);
        this.dataWatches.triggerWatch(string, Watcher.Event.EventType.NodeDataChanged, l2, list);
        return stat;
    }

    public String getMaxPrefixWithQuota(String string) {
        String string2 = this.pTrie.findMaxPrefix(string);
        if (rootZookeeper.equals(string2) || string2.isEmpty()) {
            return null;
        }
        return string2;
    }

    public void addWatch(String string, Watcher watcher, int n2) {
        WatcherMode watcherMode = WatcherMode.fromZooDef(n2);
        this.dataWatches.addWatch(string, watcher, watcherMode);
        if (watcherMode != WatcherMode.PERSISTENT_RECURSIVE) {
            this.childWatches.addWatch(string, watcher, watcherMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String string, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        byte[] byArray;
        DataNode dataNode = this.nodes.get(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            dataNode.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(string, watcher);
            }
            byArray = dataNode.data;
        }
        this.updateReadStat(string, byArray == null ? 0L : (long)byArray.length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String string, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode dataNode;
        if (watcher != null) {
            this.dataWatches.addWatch(string, watcher);
        }
        if ((dataNode = this.nodes.get(string)) == null) {
            throw new KeeperException.NoNodeException();
        }
        Stat stat = new Stat();
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            dataNode.copyStat(stat);
        }
        this.updateReadStat(string, 0L);
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String string, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        ArrayList<String> arrayList;
        DataNode dataNode = this.nodes.get(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            if (stat != null) {
                dataNode.copyStat(stat);
            }
            arrayList = new ArrayList<String>(dataNode.getChildren());
            if (watcher != null) {
                this.childWatches.addWatch(string, watcher);
            }
        }
        int n2 = 0;
        for (String string2 : arrayList) {
            n2 += string2.length();
        }
        this.updateReadStat(string, n2);
        return arrayList;
    }

    public int getAllChildrenNumber(String string) {
        if (rootZookeeper.equals(string)) {
            return this.nodes.size() - 2;
        }
        return (int)this.nodes.entrySet().parallelStream().filter(entry -> ((String)entry.getKey()).startsWith(string + rootZookeeper)).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String string, List<ACL> list, int n2) throws KeeperException.NoNodeException {
        DataNode dataNode = this.nodes.get(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            Stat stat = new Stat();
            this.aclCache.removeUsage(dataNode.acl);
            this.nodes.preChange(string, dataNode);
            dataNode.stat.setAversion(n2);
            dataNode.acl = this.aclCache.convertAcls(list);
            dataNode.copyStat(stat);
            this.nodes.postChange(string, dataNode);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String string, Stat stat) throws KeeperException.NoNodeException {
        DataNode dataNode = this.nodes.get(string);
        if (dataNode == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            if (stat != null) {
                dataNode.copyStat(stat);
            }
            return new ArrayList<ACL>(this.aclCache.convertLong(dataNode.acl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(DataNode dataNode) {
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            return this.aclCache.convertLong(dataNode.acl);
        }
    }

    public int aclCacheSize() {
        return this.aclCache.size();
    }

    public ProcessTxnResult processTxn(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        ProcessTxnResult processTxnResult = this.processTxn(txnHeader, mme2);
        this.compareDigest(txnHeader, mme2, txnDigest);
        return processTxnResult;
    }

    public ProcessTxnResult processTxn(TxnHeader txnHeader, mme mme2) {
        return this.processTxn(txnHeader, mme2, false);
    }

    public ProcessTxnResult processTxn(TxnHeader txnHeader, mme mme2, boolean bl2) {
        mme mme3;
        Object object;
        ProcessTxnResult processTxnResult = new ProcessTxnResult();
        try {
            processTxnResult.clientId = txnHeader.getClientId();
            processTxnResult.cxid = txnHeader.getCxid();
            processTxnResult.zxid = txnHeader.getZxid();
            processTxnResult.type = txnHeader.getType();
            processTxnResult.err = 0;
            processTxnResult.multiResult = null;
            switch (txnHeader.getType()) {
                case 1: {
                    CreateTxn createTxn = (CreateTxn)mme2;
                    processTxnResult.path = createTxn.getPath();
                    this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? txnHeader.getClientId() : 0L, createTxn.getParentCVersion(), txnHeader.getZxid(), txnHeader.getTime(), null);
                    break;
                }
                case 15: {
                    object = (CreateTxn)mme2;
                    processTxnResult.path = ((CreateTxn)object).getPath();
                    mme3 = new Stat();
                    this.createNode(((CreateTxn)object).getPath(), ((CreateTxn)object).getData(), ((CreateTxn)object).getAcl(), ((CreateTxn)object).getEphemeral() ? txnHeader.getClientId() : 0L, ((CreateTxn)object).getParentCVersion(), txnHeader.getZxid(), txnHeader.getTime(), (Stat)mme3);
                    processTxnResult.stat = mme3;
                    break;
                }
                case 21: {
                    CreateTTLTxn createTTLTxn = (CreateTTLTxn)mme2;
                    processTxnResult.path = createTTLTxn.getPath();
                    mme3 = new Stat();
                    this.createNode(createTTLTxn.getPath(), createTTLTxn.getData(), createTTLTxn.getAcl(), EphemeralType.TTL.toEphemeralOwner(createTTLTxn.getTtl()), createTTLTxn.getParentCVersion(), txnHeader.getZxid(), txnHeader.getTime(), (Stat)mme3);
                    processTxnResult.stat = mme3;
                    break;
                }
                case 19: {
                    CreateContainerTxn createContainerTxn = (CreateContainerTxn)mme2;
                    processTxnResult.path = createContainerTxn.getPath();
                    mme3 = new Stat();
                    this.createNode(createContainerTxn.getPath(), createContainerTxn.getData(), createContainerTxn.getAcl(), Long.MIN_VALUE, createContainerTxn.getParentCVersion(), txnHeader.getZxid(), txnHeader.getTime(), (Stat)mme3);
                    processTxnResult.stat = mme3;
                    break;
                }
                case 2: 
                case 20: {
                    DeleteTxn deleteTxn = (DeleteTxn)mme2;
                    processTxnResult.path = deleteTxn.getPath();
                    this.deleteNode(deleteTxn.getPath(), txnHeader.getZxid());
                    break;
                }
                case 5: 
                case 16: {
                    SetDataTxn setDataTxn = (SetDataTxn)mme2;
                    processTxnResult.path = setDataTxn.getPath();
                    processTxnResult.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), txnHeader.getZxid(), txnHeader.getTime());
                    break;
                }
                case 7: {
                    SetACLTxn setACLTxn = (SetACLTxn)mme2;
                    processTxnResult.path = setACLTxn.getPath();
                    processTxnResult.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                    break;
                }
                case -11: {
                    long l2 = txnHeader.getClientId();
                    if (mme2 != null) {
                        this.killSession(l2, txnHeader.getZxid(), (Set<String>)this.ephemerals.remove(l2), ((CloseSessionTxn)mme2).getPaths2Delete());
                        break;
                    }
                    this.killSession(l2, txnHeader.getZxid());
                    break;
                }
                case -1: {
                    ErrorTxn errorTxn = (ErrorTxn)mme2;
                    processTxnResult.err = errorTxn.getErr();
                    break;
                }
                case 13: {
                    CheckVersionTxn checkVersionTxn = (CheckVersionTxn)mme2;
                    processTxnResult.path = checkVersionTxn.getPath();
                    break;
                }
                case 14: {
                    MultiTxn multiTxn = (MultiTxn)mme2;
                    List<Txn> list = multiTxn.getTxns();
                    processTxnResult.multiResult = new ArrayList<ProcessTxnResult>();
                    boolean bl3 = false;
                    for (Txn object2 : list) {
                        if (object2.getType() != -1) continue;
                        bl3 = true;
                        break;
                    }
                    boolean bl4 = false;
                    for (Txn txn : list) {
                        mme mme4;
                        ByteBuffer byteBuffer = ByteBuffer.wrap(txn.getData());
                        switch (txn.getType()) {
                            case 1: 
                            case 15: {
                                mme4 = new CreateTxn();
                                break;
                            }
                            case 21: {
                                mme4 = new CreateTTLTxn();
                                break;
                            }
                            case 19: {
                                mme4 = new CreateContainerTxn();
                                break;
                            }
                            case 2: 
                            case 20: {
                                mme4 = new DeleteTxn();
                                break;
                            }
                            case 5: {
                                mme4 = new SetDataTxn();
                                break;
                            }
                            case -1: {
                                mme4 = new ErrorTxn();
                                bl4 = true;
                                break;
                            }
                            case 13: {
                                mme4 = new CheckVersionTxn();
                                break;
                            }
                            default: {
                                throw new IOException("Invalid type of op: " + txn.getType());
                            }
                        }
                        assert (mme4 != null);
                        ByteBufferInputStream.byteBuffer2Record(byteBuffer, mme4);
                        if (bl3 && txn.getType() != -1) {
                            int n2 = bl4 ? KeeperException.Code.RUNTIMEINCONSISTENCY.intValue() : KeeperException.Code.OK.intValue();
                            txn.setType(-1);
                            mme4 = new ErrorTxn(n2);
                        }
                        assert (!bl3 || txn.getType() == -1);
                        TxnHeader n2 = new TxnHeader(txnHeader.getClientId(), txnHeader.getCxid(), txnHeader.getZxid(), txnHeader.getTime(), txn.getType());
                        ProcessTxnResult processTxnResult2 = this.processTxn(n2, mme4, true);
                        processTxnResult.multiResult.add(processTxnResult2);
                        if (processTxnResult2.err == 0 || processTxnResult.err != 0) continue;
                        processTxnResult.err = processTxnResult2.err;
                    }
                    break;
                }
            }
        }
        catch (KeeperException keeperException) {
            LOG.b("Failed: {}:{}", txnHeader, mme2, keeperException);
            processTxnResult.err = keeperException.code().intValue();
        }
        catch (IOException iOException) {
            LOG.b("Failed: {}:{}", txnHeader, mme2, iOException);
        }
        if (txnHeader.getType() == 1 && processTxnResult.err == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.b("Adjusting parent cversion for Txn: {} path: {} err: {}", txnHeader.getType(), processTxnResult.path, processTxnResult.err);
            int n3 = processTxnResult.path.lastIndexOf(47);
            object = processTxnResult.path.substring(0, n3);
            mme3 = (CreateTxn)mme2;
            try {
                this.setCversionPzxid((String)object, ((CreateTxn)mme3).getParentCVersion(), txnHeader.getZxid());
            }
            catch (KeeperException.NoNodeException noNodeException) {
                LOG.e("Failed to set parent cversion for: {}", object, (Object)noNodeException);
                processTxnResult.err = noNodeException.code().intValue();
            }
        } else if (processTxnResult.err != KeeperException.Code.OK.intValue()) {
            LOG.b("Ignoring processTxn failure hdr: {} : error: {}", (Object)txnHeader.getType(), (Object)processTxnResult.err);
        }
        if (!bl2) {
            if (processTxnResult.zxid > this.lastProcessedZxid) {
                this.lastProcessedZxid = processTxnResult.zxid;
            }
            if (this.digestFromLoadedSnapshot != null) {
                this.compareSnapshotDigests(processTxnResult.zxid);
            } else {
                this.logZxidDigest(processTxnResult.zxid, this.getTreeDigest());
            }
        }
        return processTxnResult;
    }

    void killSession(long l2, long l3) {
        this.killSession(l2, l3, (Set<String>)this.ephemerals.remove(l2), null);
    }

    void killSession(long l2, long l3, Set<String> set, List<String> list) {
        if (list != null) {
            this.deleteNodes(l2, l3, list);
        }
        if (set == null) {
            return;
        }
        if (list != null) {
            for (String string : list) {
                set.remove(string);
            }
            if (!set.isEmpty()) {
                LOG.d("Unexpected extra paths under session {} which are not in txn 0x{}", (Object)set, (Object)Long.toHexString(l3));
            }
        }
        this.deleteNodes(l2, l3, set);
    }

    void deleteNodes(long l2, long l3, Iterable<String> iterable) {
        for (String string : iterable) {
            boolean bl2 = false;
            String string2 = "0x" + Long.toHexString(l2);
            try {
                this.deleteNode(string, l3);
                bl2 = true;
                LOG.b("Deleting ephemeral node {} for session {}", (Object)string, (Object)string2);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                LOG.d("Ignoring NoNodeException for path {} while removing ephemeral for dead session {}", (Object)string, (Object)string2);
            }
            if (!ZKAuditProvider.isAuditEnabled()) continue;
            if (bl2) {
                ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "ephemeralZNodeDeletionOnSessionCloseOrExpire", string, null, null, string2, null, AuditEvent.Result.SUCCESS);
                continue;
            }
            ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "ephemeralZNodeDeletionOnSessionCloseOrExpire", string, null, null, string2, null, AuditEvent.Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCounts(String string, Counts counts) {
        String[] stringArray = this.getNode(string);
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            String[] stringArray3 = stringArray.getChildren().toArray(new String[0]);
            int n2 = stringArray.data == null ? 0 : stringArray.data.length;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            ++counts.count;
            counts.bytes += (long)n2;
            for (String string2 : stringArray3) {
                this.getCounts(string + rootZookeeper + string2, counts);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuotaForPath(String string) {
        Counts counts = new Counts();
        this.getCounts(string, counts);
        StatsTrack statsTrack = new StatsTrack();
        statsTrack.setBytes(counts.bytes);
        statsTrack.setCount(counts.count);
        String string2 = Quotas.statPath(string);
        DataNode dataNode = this.getNode(string2);
        if (dataNode == null) {
            LOG.d("Missing quota stat node {}", (Object)string2);
            return;
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            this.nodes.preChange(string2, dataNode);
            dataNode.data = statsTrack.getStatsBytes();
            this.nodes.postChange(string2, dataNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseNode(String string) {
        String[] stringArray;
        DataNode dataNode;
        DataNode object = dataNode = this.getNode(string);
        synchronized (object) {
            stringArray = dataNode.getChildren().toArray(new String[0]);
        }
        if (stringArray.length == 0) {
            String string2 = "/zookeeper_limits";
            if (string.endsWith(string2)) {
                String string3 = string.substring(quotaZookeeper.length(), string.indexOf(string2));
                this.updateQuotaForPath(string3);
                this.pTrie.addPath(string3);
            }
            return;
        }
        for (String string4 : stringArray) {
            this.traverseNode(string + rootZookeeper + string4);
        }
    }

    private void setupQuota() {
        String string = quotaZookeeper;
        DataNode dataNode = this.getNode(string);
        if (dataNode == null) {
            return;
        }
        this.traverseNode(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(lme lme2, StringBuilder stringBuilder) throws IOException {
        String[] stringArray;
        DataNode dataNode;
        String string = stringBuilder.toString();
        DataNode dataNode2 = this.getNode(string);
        if (dataNode2 == null) {
            return;
        }
        DataNode dataNode3 = dataNode2;
        synchronized (dataNode3) {
            String[] stringArray2 = new StatPersisted();
            DataTree.copyStatPersisted(dataNode2.stat, (StatPersisted)stringArray2);
            dataNode = new DataNode(dataNode2.data, dataNode2.acl, (StatPersisted)stringArray2);
            stringArray = dataNode2.getChildren().toArray(new String[0]);
        }
        this.serializeNodeData(lme2, string, dataNode);
        stringBuilder.append('/');
        int n2 = stringBuilder.length();
        for (String string2 : stringArray) {
            stringBuilder.delete(n2, Integer.MAX_VALUE);
            stringBuilder.append(string2);
            this.serializeNode(lme2, stringBuilder);
        }
    }

    public void serializeNodeData(lme lme2, String string, DataNode dataNode) throws IOException {
        lme2.a(string, "path");
        lme2.a(dataNode, "node");
    }

    public void serializeAcls(lme lme2) throws IOException {
        this.aclCache.serialize(lme2);
    }

    public void serializeNodes(lme lme2) throws IOException {
        this.serializeNode(lme2, new StringBuilder());
        if (this.root != null) {
            lme2.a(rootZookeeper, "path");
        }
    }

    public void serialize(lme lme2, String string) throws IOException {
        this.serializeAcls(lme2);
        this.serializeNodes(lme2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(kme kme2, String string) throws IOException {
        this.aclCache.deserialize(kme2);
        this.nodes.clear();
        this.pTrie.clear();
        this.nodeDataSize.set(0L);
        String string2 = kme2.e("path");
        while (!rootZookeeper.equals(string2)) {
            DataNode dataNode = new DataNode();
            kme2.a(dataNode, "node");
            this.nodes.put(string2, dataNode);
            DataNode dataNode2 = dataNode;
            synchronized (dataNode2) {
                this.aclCache.addUsage(dataNode.acl);
            }
            int n2 = string2.lastIndexOf(47);
            if (n2 == -1) {
                this.root = dataNode;
            } else {
                String string3 = string2.substring(0, n2);
                DataNode dataNode3 = this.nodes.get(string3);
                if (dataNode3 == null) {
                    throw new IOException("Invalid Datatree, unable to find parent " + string3 + " of path " + string2);
                }
                dataNode3.addChild(string2.substring(n2 + 1));
                long l3 = dataNode.stat.getEphemeralOwner();
                EphemeralType ephemeralType = EphemeralType.get(l3);
                if (ephemeralType == EphemeralType.CONTAINER) {
                    this.containers.add(string2);
                } else if (ephemeralType == EphemeralType.TTL) {
                    this.ttls.add(string2);
                } else if (l3 != 0L) {
                    HashSet hashSet = this.ephemerals.computeIfAbsent(l3, l2 -> new HashSet());
                    hashSet.add(string2);
                }
            }
            string2 = kme2.e("path");
        }
        this.nodes.putWithoutDigest(rootZookeeper, this.root);
        this.nodeDataSize.set(this.approximateDataSize());
        this.setupQuota();
        this.aclCache.purgeUnused();
    }

    public synchronized void dumpWatchesSummary(PrintWriter printWriter) {
        printWriter.print(this.dataWatches.toString());
    }

    public synchronized void dumpWatches(PrintWriter printWriter, boolean bl2) {
        this.dataWatches.dumpWatches(printWriter, bl2);
    }

    public synchronized WatchesReport getWatches() {
        return this.dataWatches.getWatches();
    }

    public synchronized WatchesPathReport getWatchesByPath() {
        return this.dataWatches.getWatchesByPath();
    }

    public synchronized WatchesSummary getWatchesSummary() {
        return this.dataWatches.getWatchesSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEphemerals(PrintWriter printWriter) {
        printWriter.println("Sessions with Ephemerals (" + this.ephemerals.keySet().size() + "):");
        for (Map.Entry<Long, HashSet<String>> entry : this.ephemerals.entrySet()) {
            printWriter.print("0x" + Long.toHexString(entry.getKey()));
            printWriter.println(":");
            Set set = entry.getValue();
            if (set == null) continue;
            Set set2 = set;
            synchronized (set2) {
                for (String string : set) {
                    printWriter.println("\t" + string);
                }
            }
        }
    }

    public void shutdownWatcher() {
        this.dataWatches.shutdown();
        this.childWatches.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Set<String>> getEphemerals() {
        HashMap<Long, Set<String>> hashMap = new HashMap<Long, Set<String>>();
        for (Map.Entry<Long, HashSet<String>> entry : this.ephemerals.entrySet()) {
            HashSet<String> hashSet = entry.getValue();
            synchronized (hashSet) {
                hashMap.put(entry.getKey(), new HashSet(entry.getValue()));
            }
        }
        return hashMap;
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void setWatches(long l2, List<String> list, List<String> list2, List<String> list3, List<String> list4, List<String> list5, Watcher watcher) {
        DataNode dataNode;
        for (String string : list) {
            dataNode = this.getNode(string);
            if (dataNode == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, string));
                continue;
            }
            if (dataNode.stat.getMzxid() > l2) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, string));
                continue;
            }
            this.dataWatches.addWatch(string, watcher);
        }
        for (String string : list2) {
            dataNode = this.getNode(string);
            if (dataNode != null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, string));
                continue;
            }
            this.dataWatches.addWatch(string, watcher);
        }
        for (String string : list3) {
            dataNode = this.getNode(string);
            if (dataNode == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, string));
                continue;
            }
            if (dataNode.stat.getPzxid() > l2) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, string));
                continue;
            }
            this.childWatches.addWatch(string, watcher);
        }
        for (String string : list4) {
            this.childWatches.addWatch(string, watcher, WatcherMode.PERSISTENT);
            this.dataWatches.addWatch(string, watcher, WatcherMode.PERSISTENT);
        }
        for (String string : list5) {
            this.dataWatches.addWatch(string, watcher, WatcherMode.PERSISTENT_RECURSIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCversionPzxid(String string, int n2, long l2) throws KeeperException.NoNodeException {
        DataNode dataNode;
        if (string.endsWith(rootZookeeper)) {
            string = string.substring(0, string.length() - 1);
        }
        if ((dataNode = this.nodes.get(string)) == null) {
            throw new KeeperException.NoNodeException(string);
        }
        DataNode dataNode2 = dataNode;
        synchronized (dataNode2) {
            if (n2 == -1) {
                n2 = dataNode.stat.getCversion() + 1;
            }
            if (n2 > dataNode.stat.getCversion()) {
                this.nodes.preChange(string, dataNode);
                dataNode.stat.setCversion(n2);
                dataNode.stat.setPzxid(l2);
                this.nodes.postChange(string, dataNode);
            }
        }
    }

    public boolean containsWatcher(String string, Watcher.WatcherType watcherType, Watcher watcher) {
        boolean bl2 = false;
        switch (watcherType) {
            case Children: {
                bl2 = this.childWatches.containsWatcher(string, watcher, WatcherMode.STANDARD);
                break;
            }
            case Data: {
                bl2 = this.dataWatches.containsWatcher(string, watcher, WatcherMode.STANDARD);
                break;
            }
            case Persistent: {
                bl2 = this.dataWatches.containsWatcher(string, watcher, WatcherMode.PERSISTENT);
                break;
            }
            case PersistentRecursive: {
                bl2 = this.dataWatches.containsWatcher(string, watcher, WatcherMode.PERSISTENT_RECURSIVE);
                break;
            }
            case Any: {
                if (this.childWatches.containsWatcher(string, watcher, null)) {
                    bl2 = true;
                    break;
                }
                if (!this.dataWatches.containsWatcher(string, watcher, null)) break;
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean removeWatch(String string, Watcher.WatcherType watcherType, Watcher watcher) {
        boolean bl2 = false;
        switch (watcherType) {
            case Children: {
                bl2 = this.childWatches.removeWatcher(string, watcher, WatcherMode.STANDARD);
                break;
            }
            case Data: {
                bl2 = this.dataWatches.removeWatcher(string, watcher, WatcherMode.STANDARD);
                break;
            }
            case Persistent: {
                if (this.childWatches.removeWatcher(string, watcher, WatcherMode.PERSISTENT)) {
                    bl2 = true;
                }
                if (!this.dataWatches.removeWatcher(string, watcher, WatcherMode.PERSISTENT)) break;
                bl2 = true;
                break;
            }
            case PersistentRecursive: {
                bl2 = this.dataWatches.removeWatcher(string, watcher, WatcherMode.PERSISTENT_RECURSIVE);
                break;
            }
            case Any: {
                if (this.childWatches.removeWatcher(string, watcher, null)) {
                    bl2 = true;
                }
                if (!this.dataWatches.removeWatcher(string, watcher, null)) break;
                bl2 = true;
            }
        }
        return bl2;
    }

    public ReferenceCountedACLCache getReferenceCountedAclCache() {
        return this.aclCache;
    }

    private void updateReadStat(String string, long l2) {
        String string2 = PathUtils.getTopNamespace(string);
        if (string2 == null) {
            return;
        }
        long l3 = (long)string.length() + l2 + 68L;
        ServerMetrics.getMetrics().READ_PER_NAMESPACE.add(string2, l3);
    }

    private void updateWriteStat(String string, long l2) {
        String string2 = PathUtils.getTopNamespace(string);
        if (string2 == null) {
            return;
        }
        ServerMetrics.getMetrics().WRITE_PER_NAMESPACE.add(string2, (long)string.length() + l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logZxidDigest(long l2, long l3) {
        ZxidDigest zxidDigest;
        this.lastProcessedZxidDigest = zxidDigest = new ZxidDigest(l2, this.digestCalculator.getDigestVersion(), l3);
        if (zxidDigest.zxid % 128L == 0L) {
            LinkedList<ZxidDigest> linkedList = this.digestLog;
            synchronized (linkedList) {
                this.digestLog.add(zxidDigest);
                if (this.digestLog.size() > 1024) {
                    this.digestLog.poll();
                }
            }
        }
    }

    public boolean serializeZxidDigest(lme lme2) throws IOException {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return false;
        }
        ZxidDigest zxidDigest = this.lastProcessedZxidDigest;
        if (zxidDigest == null) {
            zxidDigest = new ZxidDigest();
        }
        zxidDigest.serialize(lme2);
        return true;
    }

    public boolean deserializeZxidDigest(kme kme2, long l2) throws IOException {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return false;
        }
        try {
            ZxidDigest zxidDigest = new ZxidDigest();
            zxidDigest.deserialize(kme2);
            if (zxidDigest.zxid > 0L) {
                this.digestFromLoadedSnapshot = zxidDigest;
                LOG.c("The digest in the snapshot has digest version of {}, with zxid as 0x{}, and digest value as {}", this.digestFromLoadedSnapshot.digestVersion, Long.toHexString(this.digestFromLoadedSnapshot.zxid), this.digestFromLoadedSnapshot.digest);
            } else {
                this.digestFromLoadedSnapshot = null;
                LOG.c("The digest value is empty in snapshot");
            }
            if (this.digestFromLoadedSnapshot != null && this.digestFromLoadedSnapshot.zxid < l2) {
                LOG.c("The zxid of snapshot digest 0x{} is smaller than the known snapshot highest zxid, the snapshot started with zxid 0x{}. It will be invalid to use this snapshot digest associated with this zxid, will ignore comparing it.", (Object)Long.toHexString(this.digestFromLoadedSnapshot.zxid), (Object)Long.toHexString(l2));
                this.digestFromLoadedSnapshot = null;
            }
            return true;
        }
        catch (EOFException eOFException) {
            LOG.d("Got EOF exception while reading the digest, likely due to the reading an older snapshot.");
            return false;
        }
    }

    public boolean serializeLastProcessedZxid(lme lme2) throws IOException {
        if (!ZooKeeperServer.isSerializeLastProcessedZxidEnabled()) {
            return false;
        }
        lme2.a(this.lastProcessedZxid, "lastZxid");
        return true;
    }

    public boolean deserializeLastProcessedZxid(kme kme2) throws IOException {
        if (!ZooKeeperServer.isSerializeLastProcessedZxidEnabled()) {
            return false;
        }
        try {
            this.lastProcessedZxid = kme2.d("lastZxid");
        }
        catch (EOFException eOFException) {
            LOG.d("Got EOFException while reading the last processed zxid, likely due to reading an older snapshot.");
            return false;
        }
        return true;
    }

    public void compareSnapshotDigests(long l2) {
        if (l2 == this.digestFromLoadedSnapshot.zxid) {
            if (this.digestCalculator.getDigestVersion() != this.digestFromLoadedSnapshot.digestVersion) {
                LOG.c("Digest version changed, local: {}, new: {}, skip comparing digest now.", (Object)this.digestFromLoadedSnapshot.digestVersion, (Object)this.digestCalculator.getDigestVersion());
                this.digestFromLoadedSnapshot = null;
                return;
            }
            if (this.getTreeDigest() != this.digestFromLoadedSnapshot.getDigest()) {
                this.reportDigestMismatch(l2);
            }
            this.digestFromLoadedSnapshot = null;
        } else if (this.digestFromLoadedSnapshot.zxid != 0L && l2 > this.digestFromLoadedSnapshot.zxid) {
            this.RATE_LOGGER.rateLimitLog("The txn 0x{} of snapshot digest does not exist.", Long.toHexString(this.digestFromLoadedSnapshot.zxid));
        }
    }

    public boolean compareDigest(TxnHeader txnHeader, mme mme2, TxnDigest txnDigest) {
        long l2;
        long l3 = txnHeader.getZxid();
        if (!ZooKeeperServer.isDigestEnabled() || txnDigest == null) {
            return true;
        }
        if (this.digestFromLoadedSnapshot != null) {
            return true;
        }
        if (this.digestCalculator.getDigestVersion() != txnDigest.getVersion()) {
            this.RATE_LOGGER.rateLimitLog("Digest version not the same on zxid.", String.valueOf(l3));
            return true;
        }
        long l4 = txnDigest.getTreeDigest();
        if (l4 != (l2 = this.getTreeDigest())) {
            this.reportDigestMismatch(l3);
            LOG.b("Digest in log: {}, actual tree: {}", (Object)l4, (Object)l2);
            if (this.firstMismatchTxn) {
                LOG.e("First digest mismatch on txn: {}, {}, expected digest is {}, actual digest is {}, ", txnHeader, mme2, txnDigest, l2);
                this.firstMismatchTxn = false;
            }
            return false;
        }
        this.RATE_LOGGER.flush();
        LOG.b("Digests are matching for Zxid: {}, Digest in log and actual tree: {}", (Object)Long.toHexString(l3), (Object)l4);
        return true;
    }

    public void reportDigestMismatch(long l2) {
        ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT.add(1L);
        this.RATE_LOGGER.rateLimitLog("Digests are not matching. Value is Zxid.", String.valueOf(l2));
        for (DigestWatcher digestWatcher : this.digestWatchers) {
            digestWatcher.process(l2);
        }
    }

    public long getTreeDigest() {
        return this.nodes.getDigest();
    }

    public ZxidDigest getLastProcessedZxidDigest() {
        return this.lastProcessedZxidDigest;
    }

    public ZxidDigest getDigestFromLoadedSnapshot() {
        return this.digestFromLoadedSnapshot;
    }

    public void addDigestWatcher(DigestWatcher digestWatcher) {
        this.digestWatchers.add(digestWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZxidDigest> getDigestLog() {
        LinkedList<ZxidDigest> linkedList = this.digestLog;
        synchronized (linkedList) {
            return new LinkedList<ZxidDigest>(this.digestLog);
        }
    }

    public static StatPersisted createStat(long l2, long l3, long l4) {
        StatPersisted statPersisted = new StatPersisted();
        statPersisted.setCtime(l3);
        statPersisted.setMtime(l3);
        statPersisted.setCzxid(l2);
        statPersisted.setMzxid(l2);
        statPersisted.setPzxid(l2);
        statPersisted.setVersion(0);
        statPersisted.setAversion(0);
        statPersisted.setEphemeralOwner(l4);
        return statPersisted;
    }

    public class ZxidDigest {
        long zxid;
        long digest;
        int digestVersion;

        ZxidDigest() {
            this(0L, dataTree.digestCalculator.getDigestVersion(), 0L);
        }

        ZxidDigest(long l2, int n2, long l3) {
            this.zxid = l2;
            this.digestVersion = n2;
            this.digest = l3;
        }

        public void serialize(lme lme2) throws IOException {
            lme2.a(this.zxid, "zxid");
            lme2.a(this.digestVersion, "digestVersion");
            lme2.a(this.digest, "digest");
        }

        public void deserialize(kme kme2) throws IOException {
            this.zxid = kme2.d("zxid");
            this.digestVersion = kme2.c("digestVersion");
            if (this.digestVersion < 2) {
                String string = kme2.e("digest");
                if (string != null) {
                    this.digest = Long.parseLong(string, 16);
                }
            } else {
                this.digest = kme2.d("digest");
            }
        }

        public long getZxid() {
            return this.zxid;
        }

        public int getDigestVersion() {
            return this.digestVersion;
        }

        public long getDigest() {
            return this.digest;
        }
    }

    static class Counts {
        long bytes;
        int count;

        private Counts() {
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;
        public List<ProcessTxnResult> multiResult;

        public boolean equals(Object object) {
            if (object instanceof ProcessTxnResult) {
                ProcessTxnResult processTxnResult = (ProcessTxnResult)object;
                return processTxnResult.clientId == this.clientId && processTxnResult.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

