/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.kme;
import XcoreXdatabricksX240X9088.lme;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.StatPersisted;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DataNode
implements mme {
    private volatile long digest;
    volatile boolean digestCached;
    byte[] data;
    Long acl;
    public StatPersisted stat;
    private Set<String> children = null;
    private static final Set<String> EMPTY_SET = Collections.emptySet();

    DataNode() {
    }

    public DataNode(byte[] byArray, Long l2, StatPersisted statPersisted) {
        this.data = byArray;
        this.acl = l2;
        this.stat = statPersisted;
    }

    public synchronized boolean addChild(String string) {
        if (this.children == null) {
            this.children = new HashSet<String>(8);
        }
        return this.children.add(string);
    }

    public synchronized boolean removeChild(String string) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(string);
    }

    public synchronized void setChildren(HashSet<String> hashSet) {
        this.children = hashSet;
    }

    public synchronized Set<String> getChildren() {
        if (this.children == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.children);
    }

    public synchronized void copyStat(Stat stat) {
        stat.setAversion(this.stat.getAversion());
        stat.setCtime(this.stat.getCtime());
        stat.setCzxid(this.stat.getCzxid());
        stat.setMtime(this.stat.getMtime());
        stat.setMzxid(this.stat.getMzxid());
        stat.setPzxid(this.stat.getPzxid());
        stat.setVersion(this.stat.getVersion());
        stat.setEphemeralOwner(DataNode.getClientEphemeralOwner(this.stat));
        stat.setDataLength(this.data == null ? 0 : this.data.length);
        int n2 = 0;
        if (this.children != null) {
            n2 = this.children.size();
        }
        stat.setCversion(this.stat.getCversion() * 2 - n2);
        stat.setNumChildren(n2);
    }

    private static long getClientEphemeralOwner(StatPersisted statPersisted) {
        EphemeralType ephemeralType = EphemeralType.get(statPersisted.getEphemeralOwner());
        if (ephemeralType != EphemeralType.NORMAL) {
            return 0L;
        }
        return statPersisted.getEphemeralOwner();
    }

    @Override
    public synchronized void deserialize(kme kme2, String string) throws IOException {
        kme2.g("node");
        this.data = kme2.f("data");
        this.acl = kme2.d("acl");
        this.stat = new StatPersisted();
        this.stat.deserialize(kme2, "statpersisted");
        kme2.h("node");
    }

    @Override
    public synchronized void serialize(lme lme2, String string) throws IOException {
        lme2.b(this, "node");
        lme2.a(this.data, "data");
        lme2.a(this.acl, "acl");
        this.stat.serialize(lme2, "statpersisted");
        lme2.c(this, "node");
    }

    public boolean isDigestCached() {
        return this.digestCached;
    }

    public void setDigestCached(boolean bl2) {
        this.digestCached = bl2;
    }

    public long getDigest() {
        return this.digest;
    }

    public void setDigest(long l2) {
        this.digest = l2;
    }

    public synchronized byte[] getData() {
        return this.data;
    }
}

