/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.DeleteContainerRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataNode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestProcessor;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.RequestRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZKDatabase;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ContainerManager {
    private static final foe LOG = goe.a(ContainerManager.class);
    private final ZKDatabase zkDb;
    private final RequestProcessor requestProcessor;
    private final int checkIntervalMs;
    private final int maxPerMinute;
    private final long maxNeverUsedIntervalMs;
    private final Timer timer;
    private final AtomicReference<TimerTask> task = new AtomicReference<Object>(null);

    public ContainerManager(ZKDatabase zKDatabase, RequestProcessor requestProcessor, int n2, int n3) {
        this(zKDatabase, requestProcessor, n2, n3, 0L);
    }

    public ContainerManager(ZKDatabase zKDatabase, RequestProcessor requestProcessor, int n2, int n3, long l2) {
        this.zkDb = zKDatabase;
        this.requestProcessor = requestProcessor;
        this.checkIntervalMs = n2;
        this.maxPerMinute = n3;
        this.maxNeverUsedIntervalMs = l2;
        this.timer = new Timer("ContainerManagerTask", true);
        LOG.c("Using checkIntervalMs={} maxPerMinute={} maxNeverUsedIntervalMs={}", n2, n3, l2);
    }

    public void start() {
        TimerTask timerTask;
        if (this.task.get() == null && this.task.compareAndSet(null, timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ContainerManager.this.checkContainers();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    LOG.c("interrupted");
                    this.cancel();
                }
                catch (Throwable throwable) {
                    LOG.d("Error checking containers", throwable);
                }
            }
        })) {
            this.timer.scheduleAtFixedRate(timerTask, this.checkIntervalMs, (long)this.checkIntervalMs);
        }
    }

    public void stop() {
        TimerTask timerTask = this.task.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.timer.cancel();
    }

    public void checkContainers() throws InterruptedException {
        long l2 = this.getMinIntervalMs();
        for (String string : this.getCandidates()) {
            long l3;
            long l4;
            long l5 = Time.currentElapsedTime();
            DeleteContainerRequest deleteContainerRequest = new DeleteContainerRequest(string);
            Request request = new Request(null, 0L, 0, 20, RequestRecord.fromRecord(deleteContainerRequest), null);
            try {
                LOG.c("Attempting to delete candidate container: {}", (Object)string);
                this.postDeleteRequest(request);
            }
            catch (Exception exception) {
                LOG.e("Could not delete container: {}", (Object)string, (Object)exception);
            }
            if ((l4 = l2 - (l3 = Time.currentElapsedTime() - l5)) <= 0L) continue;
            Thread.sleep(l4);
        }
    }

    protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
        this.requestProcessor.processRequest(request);
    }

    protected long getMinIntervalMs() {
        return TimeUnit.MINUTES.toMillis(1L) / (long)this.maxPerMinute;
    }

    protected Collection<String> getCandidates() {
        DataNode dataNode;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.zkDb.getDataTree().getContainers()) {
            dataNode = this.zkDb.getDataTree().getNode(string);
            if (dataNode == null || !dataNode.getChildren().isEmpty()) continue;
            if (dataNode.stat.getCversion() > 0) {
                hashSet.add(string);
                continue;
            }
            if (this.maxNeverUsedIntervalMs == 0L || this.getElapsed(dataNode) <= this.maxNeverUsedIntervalMs) continue;
            hashSet.add(string);
        }
        for (String string : this.zkDb.getDataTree().getTtls()) {
            long l2;
            Set<String> set;
            dataNode = this.zkDb.getDataTree().getNode(string);
            if (dataNode == null || !(set = dataNode.getChildren()).isEmpty() || EphemeralType.get(dataNode.stat.getEphemeralOwner()) != EphemeralType.TTL || (l2 = EphemeralType.TTL.getValue(dataNode.stat.getEphemeralOwner())) == 0L || this.getElapsed(dataNode) <= l2) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected long getElapsed(DataNode dataNode) {
        return Time.currentWallTime() - dataNode.stat.getMtime();
    }
}

