/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.MBeanRegistry;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.jmx.ZKMBeanInfo;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ConnectionMXBean;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Stats;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperServer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.management.ObjectName;

public class ConnectionBean
implements ZKMBeanInfo,
ConnectionMXBean {
    private static final foe LOG = goe.a(ConnectionBean.class);
    private final ServerCnxn connection;
    private final Stats stats;
    private final ZooKeeperServer zk;
    private final String remoteIP;
    private final long sessionId;

    public ConnectionBean(ServerCnxn serverCnxn, ZooKeeperServer zooKeeperServer) {
        InetAddress inetAddress;
        this.connection = serverCnxn;
        this.stats = serverCnxn;
        this.zk = zooKeeperServer;
        InetSocketAddress inetSocketAddress = serverCnxn.getRemoteSocketAddress();
        this.remoteIP = inetSocketAddress == null ? "Unknown" : ((inetAddress = inetSocketAddress.getAddress()) instanceof Inet6Address ? ObjectName.quote(inetAddress.getHostAddress()) : inetAddress.getHostAddress());
        this.sessionId = serverCnxn.getSessionId();
    }

    @Override
    public String getSessionId() {
        return "0x" + Long.toHexString(this.sessionId);
    }

    @Override
    public String getSourceIP() {
        InetSocketAddress inetSocketAddress = this.connection.getRemoteSocketAddress();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort();
    }

    @Override
    public String getName() {
        return MBeanRegistry.getInstance().makeFullPath("Connections", this.remoteIP, this.getSessionId());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String[] getEphemeralNodes() {
        if (this.zk.getZKDatabase() != null) {
            Object[] objectArray = this.zk.getZKDatabase().getEphemerals(this.sessionId).toArray(new String[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }
        return null;
    }

    @Override
    public String getStartedTime() {
        return this.stats.getEstablished().toString();
    }

    @Override
    public void terminateSession() {
        try {
            this.zk.closeSession(this.sessionId);
        }
        catch (Exception exception) {
            LOG.d("Unable to closeSession() for session: 0x{}", (Object)this.getSessionId(), (Object)exception);
        }
    }

    @Override
    public void terminateConnection() {
        this.connection.sendCloseSession();
    }

    @Override
    public void resetCounters() {
        this.stats.resetStats();
    }

    public String toString() {
        return "ConnectionBean{ClientIP=" + ObjectName.quote(this.getSourceIP()) + ",SessionId=0x" + this.getSessionId() + "}";
    }

    @Override
    public long getOutstandingRequests() {
        return this.stats.getOutstandingRequests();
    }

    @Override
    public long getPacketsReceived() {
        return this.stats.getPacketsReceived();
    }

    @Override
    public long getPacketsSent() {
        return this.stats.getPacketsSent();
    }

    @Override
    public int getSessionTimeout() {
        return this.connection.getSessionTimeout();
    }

    @Override
    public long getMinLatency() {
        return this.stats.getMinLatency();
    }

    @Override
    public long getAvgLatency() {
        return this.stats.getAvgLatency();
    }

    @Override
    public long getMaxLatency() {
        return this.stats.getMaxLatency();
    }

    @Override
    public String getLastOperation() {
        return this.stats.getLastOperation();
    }

    @Override
    public String getLastCxid() {
        return "0x" + Long.toHexString(this.stats.getLastCxid());
    }

    @Override
    public String getLastZxid() {
        return "0x" + Long.toHexString(this.stats.getLastZxid());
    }

    @Override
    public String getLastResponseTime() {
        return Time.elapsedTimeToDate(this.stats.getLastResponseTime()).toString();
    }

    @Override
    public long getLastLatency() {
        return this.stats.getLastLatency();
    }
}

