/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.server;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Id;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.auth.ProviderRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AuthenticationHelper {
    private static final foe LOG = goe.a(AuthenticationHelper.class);
    public static final String ENFORCE_AUTH_ENABLED = "zookeeper.enforce.auth.enabled";
    public static final String ENFORCE_AUTH_SCHEMES = "zookeeper.enforce.auth.schemes";
    public static final String SESSION_REQUIRE_CLIENT_SASL_AUTH = "zookeeper.sessionRequireClientSASLAuth";
    public static final String SASL_AUTH_SCHEME = "sasl";
    private boolean enforceAuthEnabled;
    private List<String> enforceAuthSchemes = new ArrayList<String>();
    private boolean saslAuthRequired;

    public AuthenticationHelper() {
        this.initConfigurations();
    }

    private void initConfigurations() {
        if (Boolean.parseBoolean(System.getProperty(SESSION_REQUIRE_CLIENT_SASL_AUTH, "false"))) {
            this.enforceAuthEnabled = true;
            this.enforceAuthSchemes.add(SASL_AUTH_SCHEME);
        } else {
            this.enforceAuthEnabled = Boolean.parseBoolean(System.getProperty(ENFORCE_AUTH_ENABLED, "false"));
            String string2 = System.getProperty(ENFORCE_AUTH_SCHEMES);
            if (string2 != null) {
                Arrays.stream(string2.split(",")).forEach(string -> this.enforceAuthSchemes.add(string.trim()));
            }
        }
        LOG.c("{} = {}", (Object)ENFORCE_AUTH_ENABLED, (Object)this.enforceAuthEnabled);
        LOG.c("{} = {}", (Object)ENFORCE_AUTH_SCHEMES, (Object)this.enforceAuthSchemes);
        this.validateConfiguredProperties();
        this.saslAuthRequired = this.enforceAuthEnabled && this.enforceAuthSchemes.contains(SASL_AUTH_SCHEME);
    }

    private void validateConfiguredProperties() {
        if (this.enforceAuthEnabled) {
            if (this.enforceAuthSchemes.isEmpty()) {
                String string2 = "zookeeper.enforce.auth.enabled is true zookeeper.enforce.auth.schemes must be  configured.";
                LOG.e(string2);
                throw new IllegalArgumentException(string2);
            }
            this.enforceAuthSchemes.forEach(string -> {
                if (ProviderRegistry.getProvider(string) == null) {
                    String string2 = "Authentication scheme " + string + " is not available.";
                    LOG.e(string2);
                    throw new IllegalArgumentException(string2);
                }
            });
        }
    }

    private boolean isCnxnAuthenticated(ServerCnxn serverCnxn) {
        for (Id id2 : serverCnxn.getAuthInfo()) {
            if (!this.enforceAuthSchemes.contains(id2.getScheme())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnforceAuthEnabled() {
        return this.enforceAuthEnabled;
    }

    public boolean enforceAuthentication(ServerCnxn serverCnxn, int n2) throws IOException {
        if (this.isEnforceAuthEnabled() && !this.isCnxnAuthenticated(serverCnxn)) {
            LOG.e("Client authentication scheme(s) {} does not match with any of the expected authentication scheme {}, closing session.", (Object)this.getAuthSchemes(serverCnxn), (Object)this.enforceAuthSchemes);
            ReplyHeader replyHeader = new ReplyHeader(n2, 0L, KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue());
            serverCnxn.sendResponse(replyHeader, null, "response");
            serverCnxn.sendCloseSession();
            serverCnxn.disableRecv();
            return false;
        }
        return true;
    }

    private List<String> getAuthSchemes(ServerCnxn serverCnxn) {
        return serverCnxn.getAuthInfo().stream().map(Id::getScheme).collect(Collectors.toList());
    }

    public boolean isSaslAuthRequired() {
        return this.saslAuthRequired;
    }
}

