/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKHostnameVerifier;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedTrustManager;

public class ZKTrustManager
extends X509ExtendedTrustManager {
    private static final foe LOG = goe.a(ZKTrustManager.class);
    private final X509ExtendedTrustManager x509ExtendedTrustManager;
    private final boolean serverHostnameVerificationEnabled;
    private final boolean clientHostnameVerificationEnabled;
    private final ZKHostnameVerifier hostnameVerifier;

    ZKTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager, boolean bl2, boolean bl3) {
        this(x509ExtendedTrustManager, bl2, bl3, new ZKHostnameVerifier());
    }

    ZKTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager, boolean bl2, boolean bl3, ZKHostnameVerifier zKHostnameVerifier) {
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
        this.serverHostnameVerificationEnabled = bl2;
        this.clientHostnameVerificationEnabled = bl3;
        this.hostnameVerifier = zKHostnameVerifier;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.x509ExtendedTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(x509CertificateArray, string, socket);
        if (this.clientHostnameVerificationEnabled) {
            if (LOG.c()) {
                LOG.b("Check client trusted socket.getInetAddress(): {}, {}", (Object)socket.getInetAddress(), (Object)socket);
            }
            this.performHostVerification(socket.getInetAddress(), x509CertificateArray[0]);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(x509CertificateArray, string, socket);
        if (this.serverHostnameVerificationEnabled) {
            if (LOG.c()) {
                LOG.b("Check server trusted socket.getInetAddress(): {}, {}", (Object)socket.getInetAddress(), (Object)socket);
            }
            this.performHostVerification(socket.getInetAddress(), x509CertificateArray[0]);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(x509CertificateArray, string, sSLEngine);
        if (this.clientHostnameVerificationEnabled) {
            try {
                if (LOG.c()) {
                    LOG.b("Check client trusted engine.getPeerHost(): {}, {}", (Object)sSLEngine.getPeerHost(), (Object)sSLEngine);
                }
                this.performHostVerification(InetAddress.getByName(sSLEngine.getPeerHost()), x509CertificateArray[0]);
            }
            catch (UnknownHostException unknownHostException) {
                throw new CertificateException("Failed to verify host", unknownHostException);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(x509CertificateArray, string, sSLEngine);
        if (this.serverHostnameVerificationEnabled) {
            try {
                if (LOG.c()) {
                    LOG.b("Check server trusted engine.getPeerHost(): {}, {}", (Object)sSLEngine.getPeerHost(), (Object)sSLEngine);
                }
                this.performHostVerification(InetAddress.getByName(sSLEngine.getPeerHost()), x509CertificateArray[0]);
            }
            catch (UnknownHostException unknownHostException) {
                throw new CertificateException("Failed to verify host", unknownHostException);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(x509CertificateArray, string);
    }

    private void performHostVerification(InetAddress inetAddress, X509Certificate x509Certificate) throws CertificateException {
        String string = "";
        String string2 = "";
        try {
            string = inetAddress.getHostAddress();
            if (LOG.c()) {
                LOG.b("Trying to verify host address first: {}", (Object)string);
            }
            this.hostnameVerifier.verify(string, x509Certificate);
        }
        catch (SSLException sSLException) {
            try {
                string2 = inetAddress.getHostName();
                if (LOG.c()) {
                    LOG.b("Failed to verify host address: {}, trying to verify host name: {}", (Object)string, (Object)string2);
                }
                this.hostnameVerifier.verify(string2, x509Certificate);
            }
            catch (SSLException sSLException2) {
                LOG.e("Failed to verify host address: {}", (Object)string, (Object)sSLException);
                LOG.e("Failed to verify hostname: {}", (Object)string2, (Object)sSLException2);
                throw new CertificateException("Failed to verify both host address and host name", sSLException2);
            }
        }
    }
}

