/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

class ZKHostnameVerifier
implements HostnameVerifier {
    private final foe log = goe.a(ZKHostnameVerifier.class);

    ZKHostnameVerifier() {
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            this.verify(string, x509Certificate);
            return true;
        }
        catch (SSLException sSLException) {
            this.log.a("Unexpected exception", sSLException);
            return false;
        }
    }

    void verify(String string, X509Certificate x509Certificate) throws SSLException {
        HostNameType hostNameType = ZKHostnameVerifier.determineHostFormat(string);
        List<SubjectName> list = ZKHostnameVerifier.getSubjectAltNames(x509Certificate);
        if (list != null && !list.isEmpty()) {
            switch (hostNameType) {
                case IPv4: {
                    ZKHostnameVerifier.matchIPAddress(string, list);
                    break;
                }
                case IPv6: {
                    ZKHostnameVerifier.matchIPv6Address(string, list);
                    break;
                }
                default: {
                    ZKHostnameVerifier.matchDNSName(string, list);
                    break;
                }
            }
        } else {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            String string2 = ZKHostnameVerifier.extractCN(x500Principal.getName("RFC2253"));
            if (string2 == null) {
                throw new SSLException("Certificate subject for <" + string + "> doesn't contain a common name and does not have alternative names");
            }
            ZKHostnameVerifier.matchCN(string, string2);
        }
    }

    private static void matchIPAddress(String string, List<SubjectName> list) throws SSLException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 7 || !string.equals(subjectName.getValue())) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    private static void matchIPv6Address(String string, List<SubjectName> list) throws SSLException {
        String string2 = ZKHostnameVerifier.normaliseAddress(string);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3;
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 7 || !string2.equals(string3 = ZKHostnameVerifier.normaliseAddress(subjectName.getValue()))) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    private static void matchDNSName(String string, List<SubjectName> list) throws SSLException {
        String string2 = string.toLowerCase(Locale.ROOT);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3;
            SubjectName subjectName = list.get(i2);
            if (subjectName.getType() != 2 || !ZKHostnameVerifier.matchIdentityStrict(string2, string3 = subjectName.getValue().toLowerCase(Locale.ROOT))) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    private static void matchCN(String string, String string2) throws SSLException {
        String string3;
        String string4 = string.toLowerCase(Locale.ROOT);
        if (!ZKHostnameVerifier.matchIdentityStrict(string4, string3 = string2.toLowerCase(Locale.ROOT))) {
            throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match common name of the certificate subject: " + string2);
        }
    }

    private static boolean matchIdentity(String string, String string2, boolean bl2) {
        int n2 = string2.indexOf(42);
        if (n2 != -1) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            if (!string3.isEmpty() && !string.startsWith(string3)) {
                return false;
            }
            if (!string4.isEmpty() && !string.endsWith(string4)) {
                return false;
            }
            if (bl2) {
                String string5 = string.substring(string3.length(), string.length() - string4.length());
                return !string5.contains(".");
            }
            return true;
        }
        return string.equalsIgnoreCase(string2);
    }

    private static boolean matchIdentityStrict(String string, String string2) {
        return ZKHostnameVerifier.matchIdentity(string, string2, true);
    }

    private static String extractCN(String string) throws SSLException {
        if (string == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(string);
            List<Rdn> list = ldapName.getRdns();
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Rdn rdn = list.get(i2);
                Attributes attributes = rdn.toAttributes();
                Attribute attribute = attributes.get("cn");
                if (attribute == null) continue;
                try {
                    Object object = attribute.get();
                    if (object == null) continue;
                    return object.toString();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            throw new SSLException(string + " is not a valid X500 distinguished name");
        }
    }

    private static HostNameType determineHostFormat(String string) {
        if (InetAddressUtils.isIPv4Address(string)) {
            return HostNameType.IPv4;
        }
        String string2 = string;
        if (string2.startsWith("[") && string2.endsWith("]")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (InetAddressUtils.isIPv6Address(string2)) {
            return HostNameType.IPv6;
        }
        return HostNameType.DNS;
    }

    private static List<SubjectName> getSubjectAltNames(X509Certificate x509Certificate) {
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
            ArrayList<SubjectName> arrayList = new ArrayList<SubjectName>();
            for (List<?> list : collection) {
                Integer n2 = list.size() >= 2 ? (Integer)list.get(0) : null;
                if (n2 == null || n2 != 2 && n2 != 7) continue;
                Object obj = list.get(1);
                if (obj instanceof String) {
                    arrayList.add(new SubjectName((String)obj, n2));
                    continue;
                }
                if (!(obj instanceof byte[])) continue;
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    private static String normaliseAddress(String string) {
        if (string == null) {
            return string;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    static enum HostNameType {
        IPv4(7),
        IPv6(7),
        DNS(2);

        final int subjectType;

        private HostNameType(int n3) {
            this.subjectType = n3;
        }
    }

    static class InetAddressUtils {
        private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
        private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
        private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

        private InetAddressUtils() {
        }

        static boolean isIPv4Address(String string) {
            return IPV4_PATTERN.matcher(string).matches();
        }

        static boolean isIPv6StdAddress(String string) {
            return IPV6_STD_PATTERN.matcher(string).matches();
        }

        static boolean isIPv6HexCompressedAddress(String string) {
            return IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches();
        }

        static boolean isIPv6Address(String string) {
            return InetAddressUtils.isIPv6StdAddress(string) || InetAddressUtils.isIPv6HexCompressedAddress(string);
        }
    }

    static final class SubjectName {
        static final int DNS = 2;
        static final int IP = 7;
        private final String value;
        private final int type;

        static SubjectName IP(String string) {
            return new SubjectName(string, 7);
        }

        static SubjectName DNS(String string) {
            return new SubjectName(string, 2);
        }

        SubjectName(String string, int n2) {
            if (n2 != 2 && n2 != 7) {
                throw new IllegalArgumentException("Invalid type: " + n2);
            }
            this.value = Objects.requireNonNull(string);
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

