/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.X509Util;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.ZKConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class SSLContextAndOptions {
    private static final foe LOG = goe.a(SSLContextAndOptions.class);
    private final X509Util x509Util;
    private final String[] enabledProtocols;
    private final String[] cipherSuites;
    private final X509Util.ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final int handshakeDetectionTimeoutMillis;

    SSLContextAndOptions(X509Util x509Util, ZKConfig zKConfig, SSLContext sSLContext) {
        this.x509Util = Objects.requireNonNull(x509Util);
        this.sslContext = Objects.requireNonNull(sSLContext);
        this.enabledProtocols = this.getEnabledProtocols(Objects.requireNonNull(zKConfig), sSLContext);
        this.cipherSuites = this.getCipherSuites(zKConfig);
        this.clientAuth = this.getClientAuth(zKConfig);
        this.handshakeDetectionTimeoutMillis = this.getHandshakeDetectionTimeoutMillis(zKConfig);
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public SSLSocket createSSLSocket() throws IOException {
        return this.configureSSLSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(), true);
    }

    public SSLSocket createSSLSocket(Socket socket, byte[] byArray) throws IOException {
        SSLSocket sSLSocket = byArray != null && byArray.length > 0 ? (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, new ByteArrayInputStream(byArray), true) : (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, null, socket.getPort(), true);
        return this.configureSSLSocket(sSLSocket, false);
    }

    public SSLServerSocket createSSLServerSocket() throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.sslContext.getServerSocketFactory().createServerSocket();
        return this.configureSSLServerSocket(sSLServerSocket);
    }

    public SSLServerSocket createSSLServerSocket(int n2) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.sslContext.getServerSocketFactory().createServerSocket(n2);
        return this.configureSSLServerSocket(sSLServerSocket);
    }

    public int getHandshakeDetectionTimeoutMillis() {
        return this.handshakeDetectionTimeoutMillis;
    }

    private SSLSocket configureSSLSocket(SSLSocket sSLSocket, boolean bl2) {
        SSLParameters sSLParameters = sSLSocket.getSSLParameters();
        this.configureSslParameters(sSLParameters, bl2);
        sSLSocket.setSSLParameters(sSLParameters);
        sSLSocket.setUseClientMode(bl2);
        return sSLSocket;
    }

    private SSLServerSocket configureSSLServerSocket(SSLServerSocket sSLServerSocket) {
        SSLParameters sSLParameters = sSLServerSocket.getSSLParameters();
        this.configureSslParameters(sSLParameters, false);
        sSLServerSocket.setSSLParameters(sSLParameters);
        sSLServerSocket.setUseClientMode(false);
        return sSLServerSocket;
    }

    private void configureSslParameters(SSLParameters sSLParameters, boolean bl2) {
        if (this.cipherSuites != null) {
            LOG.b("Setup cipher suites for {} socket: {}", (Object)(bl2 ? "client" : "server"), (Object)Arrays.toString(this.cipherSuites));
            sSLParameters.setCipherSuites(this.cipherSuites);
        }
        if (this.enabledProtocols != null) {
            LOG.b("Setup enabled protocols for {} socket: {}", (Object)(bl2 ? "client" : "server"), (Object)Arrays.toString(this.enabledProtocols));
            sSLParameters.setProtocols(this.enabledProtocols);
        }
        if (!bl2) {
            switch (this.clientAuth) {
                case NEED: {
                    sSLParameters.setNeedClientAuth(true);
                    break;
                }
                case WANT: {
                    sSLParameters.setWantClientAuth(true);
                    break;
                }
                default: {
                    sSLParameters.setNeedClientAuth(false);
                }
            }
        }
    }

    private String[] getEnabledProtocols(ZKConfig zKConfig, SSLContext sSLContext) {
        String string = zKConfig.getProperty(this.x509Util.getSslEnabledProtocolsProperty());
        if (string == null) {
            return sSLContext.getDefaultSSLParameters().getProtocols();
        }
        return string.split(",");
    }

    private String[] getCipherSuites(ZKConfig zKConfig) {
        String string = zKConfig.getProperty(this.x509Util.getSslCipherSuitesProperty());
        if (string == null) {
            return X509Util.getDefaultCipherSuites();
        }
        return string.split(",");
    }

    private X509Util.ClientAuth getClientAuth(ZKConfig zKConfig) {
        return X509Util.ClientAuth.fromPropertyValue(zKConfig.getProperty(this.x509Util.getSslClientAuthProperty()));
    }

    private int getHandshakeDetectionTimeoutMillis(ZKConfig zKConfig) {
        int n2;
        String string = zKConfig.getProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty());
        if (string == null) {
            n2 = 5000;
        } else {
            n2 = Integer.parseInt(string);
            if (n2 < 1) {
                LOG.d("Invalid value for {}: {}, using the default value of {}", this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), n2, 5000);
                n2 = 5000;
            }
        }
        return n2;
    }
}

