/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

public class PathUtils {
    public static void validatePath(String string, boolean bl2) throws IllegalArgumentException {
        PathUtils.validatePath(bl2 ? string + "1" : string);
    }

    public static void validatePath(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (string.length() == 1) {
            return;
        }
        if (string.charAt(string.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String string2 = null;
        int n2 = 47;
        char[] cArray = string.toCharArray();
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\u0000') {
                string2 = "null character not allowed @" + i2;
                break;
            }
            if (c2 == '/' && n2 == 47) {
                string2 = "empty node name specified @" + i2;
                break;
            }
            if (c2 == '.' && n2 == 46) {
                if (cArray[i2 - 2] == '/' && (i2 + 1 == cArray.length || cArray[i2 + 1] == '/')) {
                    string2 = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c2 == '.') {
                if (cArray[i2 - 1] == '/' && (i2 + 1 == cArray.length || cArray[i2 + 1] == '/')) {
                    string2 = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c2 > '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\ud800' && c2 <= '\uf8ff' || c2 >= '\ufff0' && c2 <= '\uffff') {
                string2 = "invalid character @" + i2;
                break;
            }
            n2 = cArray[i2];
        }
        if (string2 != null) {
            throw new IllegalArgumentException("Invalid path string \"" + string + "\" caused by " + string2);
        }
    }

    public static String normalizeFileSystemPath(String string) {
        String string2;
        if (string != null && (string2 = System.getProperty("os.name")).toLowerCase().contains("windows")) {
            return string.replace('\\', '/');
        }
        return string;
    }

    public static String getTopNamespace(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray.length > 1 ? stringArray[1] : null;
    }
}

