/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class NetUtils {
    public static String formatInetAddr(InetSocketAddress inetSocketAddress) {
        String string = inetSocketAddress.getHostString();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet6Address && string.contains(":")) {
            return String.format("[%s]:%s", string, inetSocketAddress.getPort());
        }
        return String.format("%s:%s", string, inetSocketAddress.getPort());
    }

    public static String[] getIPV6HostAndPort(String string) {
        if (string.startsWith("[")) {
            int n2 = string.lastIndexOf(93);
            if (n2 < 0) {
                throw new IllegalArgumentException(string + " starts with '[' but has no matching ']'");
            }
            String string2 = string.substring(1, n2);
            if (string2.isEmpty()) {
                throw new IllegalArgumentException(string2 + " is empty.");
            }
            if (string.length() > n2 + 1) {
                return NetUtils.getHostPort(string, n2, string2);
            }
            return new String[]{string2};
        }
        return new String[0];
    }

    private static String[] getHostPort(String string, int n2, String string2) {
        if (string.charAt(n2 + 1) != ':') {
            throw new IllegalArgumentException(string + " does not have : after ]");
        }
        if (n2 + 2 == string.length()) {
            throw new IllegalArgumentException(string + " doesn't have a port after colon.");
        }
        String string3 = string.substring(n2 + 2);
        return new String[]{string2, string3};
    }
}

