/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.common;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class AtomicFileOutputStream
extends FilterOutputStream {
    public static final String TMP_EXTENSION = ".tmp";
    private static final foe LOG = goe.a(AtomicFileOutputStream.class);
    private final File origFile;
    private final File tmpFile;

    public AtomicFileOutputStream(File file) throws FileNotFoundException {
        super(new FileOutputStream(new File(file.getParentFile(), file.getName() + TMP_EXTENSION)));
        this.origFile = file.getAbsoluteFile();
        this.tmpFile = new File(file.getParentFile(), file.getName() + TMP_EXTENSION).getAbsoluteFile();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.flush();
            ((FileOutputStream)this.out).getFD().sync();
            bl2 = true;
            super.close();
            bl3 = true;
        }
        finally {
            if (bl3) {
                boolean bl4 = this.tmpFile.renameTo(this.origFile);
                if (!(bl4 || this.origFile.delete() && this.tmpFile.renameTo(this.origFile))) {
                    throw new IOException("Could not rename temporary file " + this.tmpFile + " to " + this.origFile);
                }
            } else {
                if (!bl2) {
                    IOUtils.closeStream(this.out);
                }
                if (!this.tmpFile.delete()) {
                    LOG.d("Unable to delete tmp file {}", (Object)this.tmpFile);
                }
            }
        }
    }

    public void abort() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            LOG.d("Unable to abort file {}", (Object)this.tmpFile, (Object)iOException);
        }
        if (!this.tmpFile.delete()) {
            LOG.d("Unable to delete tmp file during abort {}", (Object)this.tmpFile);
        }
    }
}

