/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.client;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.AsyncCallback;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Login;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.SaslClientCallbackHandler;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetSASLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetSASLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.SecurityUtils;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class ZooKeeperSaslClient {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    public static final String ENABLE_CLIENT_SASL_KEY = "zookeeper.sasl.client";
    public static final String ENABLE_CLIENT_SASL_DEFAULT = "true";
    private static final foe LOG = goe.a(ZooKeeperSaslClient.class);
    private Login login = null;
    private SaslClient saslClient;
    private boolean isSASLConfigured = true;
    private final ZKClientConfig clientConfig;
    private byte[] saslToken = new byte[0];
    private SaslState saslState = SaslState.INITIAL;
    private boolean gotLastPacket = false;
    private final String configStatus;

    public static boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty(ENABLE_CLIENT_SASL_KEY, ENABLE_CLIENT_SASL_DEFAULT));
    }

    public SaslState getSaslState() {
        return this.saslState;
    }

    public String getLoginContext() {
        if (this.login != null) {
            return this.login.getLoginContextName();
        }
        return null;
    }

    public ZooKeeperSaslClient(String string, ZKClientConfig zKClientConfig, AtomicReference<Login> atomicReference) throws LoginException {
        String string2 = zKClientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client");
        this.clientConfig = zKClientConfig;
        AppConfigurationEntry[] appConfigurationEntryArray = null;
        RuntimeException runtimeException = null;
        try {
            appConfigurationEntryArray = Configuration.getConfiguration().getAppConfigurationEntry(string2);
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        if (appConfigurationEntryArray != null) {
            this.configStatus = "Will attempt to SASL-authenticate using Login Context section '" + string2 + "'";
            this.saslClient = this.createSaslClient(string, string2, atomicReference);
            this.login = atomicReference.get();
        } else {
            this.saslState = SaslState.FAILED;
            String string3 = zKClientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY);
            if (string3 != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the " + string3 + " section of the supplied JAAS configuration: '" + zKClientConfig.getJaasConfKey() + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("Client cannot SASL-authenticate because the specified JAAS configuration section '" + string3 + "' could not be found.");
            }
            String string4 = "Will not attempt to authenticate using SASL ";
            string4 = runtimeException != null ? string4 + "(" + runtimeException + ")" : string4 + "(unknown error)";
            this.configStatus = string4;
            this.isSASLConfigured = false;
            if (zKClientConfig.getJaasConfKey() != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the '" + zKClientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' section of the supplied JAAS configuration: '" + zKClientConfig.getJaasConfKey() + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("No JAAS configuration section named '" + zKClientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' was found in specified JAAS configuration file: '" + zKClientConfig.getJaasConfKey() + "'.");
            }
        }
    }

    public String getConfigStatus() {
        return this.configStatus;
    }

    public boolean isComplete() {
        return this.saslState == SaslState.COMPLETE;
    }

    public boolean isFailed() {
        return this.saslState == SaslState.FAILED;
    }

    private SaslClient createSaslClient(String string, String string2, AtomicReference<Login> atomicReference) throws LoginException {
        try {
            if (atomicReference.get() == null) {
                LOG.b("JAAS loginContext is: {}", (Object)string2);
                Login login = new Login(string2, new SaslClientCallbackHandler(null, "Client"), this.clientConfig);
                if (atomicReference.compareAndSet(null, login)) {
                    login.startThreadIfNeeded();
                }
            }
            return SecurityUtils.createSaslClient(atomicReference.get().getSubject(), string, "zookeeper", "zk-sasl-md5", LOG, "Client");
        }
        catch (LoginException loginException) {
            throw loginException;
        }
        catch (Exception exception) {
            LOG.d("Exception while trying to create SASL client.", exception);
            return null;
        }
    }

    public void respondToServer(byte[] byArray, ClientCnxn clientCnxn) {
        if (this.saslClient == null) {
            LOG.e("saslClient is unexpectedly null. Cannot respond to server's SASL message; ignoring.");
            return;
        }
        if (!this.saslClient.isComplete()) {
            try {
                this.saslToken = this.createSaslToken(byArray);
                if (this.saslToken != null) {
                    this.sendSaslPacket(this.saslToken, clientCnxn);
                }
            }
            catch (SaslException saslException) {
                LOG.e("SASL authentication failed using login context '{}'.", (Object)this.getLoginContext(), (Object)saslException);
                this.saslState = SaslState.FAILED;
                this.gotLastPacket = true;
            }
        }
        if (this.saslClient.isComplete()) {
            if (byArray == null && this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            if (!this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            clientCnxn.saslCompleted();
        }
    }

    private byte[] createSaslToken() throws SaslException {
        this.saslState = SaslState.INTERMEDIATE;
        return this.createSaslToken(this.saslToken);
    }

    private byte[] createSaslToken(final byte[] byArray) throws SaslException {
        if (byArray == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        Subject subject = this.login.getSubject();
        if (subject != null) {
            Login login = this.login;
            synchronized (login) {
                try {
                    byte[] byArray2 = Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.b("saslClient.evaluateChallenge(len={})", (Object)byArray.length);
                            return ZooKeeperSaslClient.this.saslClient.evaluateChallenge(byArray);
                        }
                    });
                    return byArray2;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    String string = "An error: (" + privilegedActionException + ") occurred when evaluating Zookeeper Quorum Member's  received SASL token.";
                    String string2 = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (privilegedActionException.toString().contains("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)")) {
                        string = string + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment.";
                    }
                    string = string + " Zookeeper Client will go to AUTH_FAILED state.";
                    LOG.e(string);
                    this.saslState = SaslState.FAILED;
                    throw new SaslException(string, privilegedActionException);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }

    private void sendSaslPacket(byte[] byArray, ClientCnxn clientCnxn) throws SaslException {
        LOG.b("ClientCnxn:sendSaslPacket:length={}", (Object)byArray.length);
        GetSASLRequest getSASLRequest = new GetSASLRequest();
        getSASLRequest.setToken(byArray);
        SetSASLResponse setSASLResponse = new SetSASLResponse();
        ServerSaslResponseCallback serverSaslResponseCallback = new ServerSaslResponseCallback();
        try {
            clientCnxn.sendPacket(getSASLRequest, setSASLResponse, serverSaslResponseCallback, 102);
        }
        catch (IOException iOException) {
            throw new SaslException("Failed to send SASL packet to server.", iOException);
        }
    }

    private void sendSaslPacket(ClientCnxn clientCnxn) throws SaslException {
        LOG.b("ClientCnxn:sendSaslPacket:length={}", (Object)this.saslToken.length);
        GetSASLRequest getSASLRequest = new GetSASLRequest();
        getSASLRequest.setToken(this.createSaslToken());
        SetSASLResponse setSASLResponse = new SetSASLResponse();
        ServerSaslResponseCallback serverSaslResponseCallback = new ServerSaslResponseCallback();
        try {
            clientCnxn.sendPacket(getSASLRequest, setSASLResponse, serverSaslResponseCallback, 102);
        }
        catch (IOException iOException) {
            throw new SaslException("Failed to send SASL packet to server due to IOException:", iOException);
        }
    }

    public Watcher.Event.KeeperState getKeeperState() {
        if (this.saslClient != null) {
            if (this.saslState == SaslState.FAILED) {
                return Watcher.Event.KeeperState.AuthFailed;
            }
            if (this.saslClient.isComplete() && this.saslState == SaslState.INTERMEDIATE) {
                this.saslState = SaslState.COMPLETE;
                return Watcher.Event.KeeperState.SaslAuthenticated;
            }
        }
        return null;
    }

    public void initialize(ClientCnxn clientCnxn) throws SaslException {
        if (this.saslClient == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("saslClient failed to initialize properly: it's null.");
        }
        if (this.saslState == SaslState.INITIAL) {
            if (this.saslClient.hasInitialResponse()) {
                this.sendSaslPacket(clientCnxn);
            } else {
                byte[] byArray = new byte[]{};
                this.sendSaslPacket(byArray, clientCnxn);
            }
            this.saslState = SaslState.INTERMEDIATE;
        }
    }

    public boolean clientTunneledAuthenticationInProgress() {
        if (!this.isSASLConfigured) {
            return false;
        }
        try {
            if (this.clientConfig.getJaasConfKey() != null || Configuration.getConfiguration() != null && Configuration.getConfiguration().getAppConfigurationEntry(this.clientConfig.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client")) != null) {
                if (!this.isComplete() && !this.isFailed()) {
                    return true;
                }
                if (!this.gotLastPacket) {
                    return true;
                }
            }
            return false;
        }
        catch (SecurityException securityException) {
            LOG.a("Could not retrieve login configuration", securityException);
            return false;
        }
    }

    public static class ServerSaslResponseCallback
    implements AsyncCallback.DataCallback {
        @Override
        public void processResult(int n2, String string, Object object, byte[] byArray, Stat stat) {
            ZooKeeperSaslClient zooKeeperSaslClient = ((ClientCnxn)object).getZooKeeperSaslClient();
            if (zooKeeperSaslClient == null) {
                LOG.d("sasl client was unexpectedly null: cannot respond to Zookeeper server.");
                return;
            }
            byte[] byArray2 = byArray;
            if (byArray != null) {
                LOG.b("ServerSaslResponseCallback(): saslToken server response: (length={})", (Object)byArray2.length);
            } else {
                byArray2 = new byte[]{};
                LOG.b("ServerSaslResponseCallback(): using empty data[] as server response (length={})", (Object)byArray2.length);
            }
            zooKeeperSaslClient.respondToServer(byArray2, (ClientCnxn)object);
        }
    }

    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

