/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.client;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.HostProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class StaticHostProvider
implements HostProvider {
    private static final foe LOG = goe.a(StaticHostProvider.class);
    private List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private Random sourceOfRandomness;
    private int lastIndex = -1;
    private int currentIndex = -1;
    private boolean reconfigMode = false;
    private final List<InetSocketAddress> oldServers = new ArrayList<InetSocketAddress>(5);
    private final List<InetSocketAddress> newServers = new ArrayList<InetSocketAddress>(5);
    private int currentIndexOld = -1;
    private int currentIndexNew = -1;
    private float pOld;
    private float pNew;
    private Resolver resolver;

    public StaticHostProvider(Collection<InetSocketAddress> collection) {
        this.init(collection, System.currentTimeMillis() ^ (long)this.hashCode(), new Resolver(){

            @Override
            public InetAddress[] getAllByName(String string) throws UnknownHostException {
                return InetAddress.getAllByName(string);
            }
        });
    }

    public StaticHostProvider(Collection<InetSocketAddress> collection, Resolver resolver) {
        this.init(collection, System.currentTimeMillis() ^ (long)this.hashCode(), resolver);
    }

    public StaticHostProvider(Collection<InetSocketAddress> collection, long l2) {
        this.init(collection, l2, new Resolver(){

            @Override
            public InetAddress[] getAllByName(String string) throws UnknownHostException {
                return InetAddress.getAllByName(string);
            }
        });
    }

    private void init(Collection<InetSocketAddress> collection, long l2, Resolver resolver) {
        this.sourceOfRandomness = new Random(l2);
        this.resolver = resolver;
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        this.serverAddresses = this.shuffle(collection);
        this.currentIndex = -1;
        this.lastIndex = -1;
    }

    private InetSocketAddress resolve(InetSocketAddress inetSocketAddress) {
        try {
            String string = inetSocketAddress.getHostString();
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(Arrays.asList(this.resolver.getAllByName(string)));
            if (arrayList.isEmpty()) {
                return inetSocketAddress;
            }
            Collections.shuffle(arrayList);
            return new InetSocketAddress((InetAddress)arrayList.get(0), inetSocketAddress.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            LOG.e("Unable to resolve address: {}", (Object)inetSocketAddress.toString(), (Object)unknownHostException);
            return inetSocketAddress;
        }
    }

    private List<InetSocketAddress> shuffle(Collection<InetSocketAddress> collection) {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(collection.size());
        arrayList.addAll(collection);
        Collections.shuffle(arrayList, this.sourceOfRandomness);
        return arrayList;
    }

    @Override
    public synchronized boolean updateServerList(Collection<InetSocketAddress> collection, InetSocketAddress inetSocketAddress) {
        int n2;
        List<InetSocketAddress> list = this.shuffle(collection);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        boolean bl2 = false;
        InetSocketAddress inetSocketAddress2 = inetSocketAddress;
        if (this.reconfigMode) {
            inetSocketAddress2 = this.next(0L);
        }
        if (inetSocketAddress2 == null) {
            inetSocketAddress2 = this.lastIndex >= 0 ? this.serverAddresses.get(this.lastIndex) : this.serverAddresses.get(0);
        }
        for (InetSocketAddress inetSocketAddress3 : list) {
            if (inetSocketAddress3.getPort() != inetSocketAddress2.getPort() || (inetSocketAddress3.getAddress() == null || inetSocketAddress2.getAddress() == null || !inetSocketAddress3.getAddress().equals(inetSocketAddress2.getAddress())) && !inetSocketAddress3.getHostString().equals(inetSocketAddress2.getHostString())) continue;
            bl2 = true;
            break;
        }
        this.reconfigMode = true;
        this.newServers.clear();
        this.oldServers.clear();
        for (InetSocketAddress inetSocketAddress3 : list) {
            if (this.serverAddresses.contains(inetSocketAddress3)) {
                this.oldServers.add(inetSocketAddress3);
                continue;
            }
            this.newServers.add(inetSocketAddress3);
        }
        int n3 = this.oldServers.size();
        if (n3 + (n2 = this.newServers.size()) > this.serverAddresses.size()) {
            if (bl2) {
                if (this.sourceOfRandomness.nextFloat() <= 1.0f - (float)this.serverAddresses.size() / (float)(n3 + n2)) {
                    this.pNew = 1.0f;
                    this.pOld = 0.0f;
                } else {
                    this.reconfigMode = false;
                }
            } else {
                this.pNew = 1.0f;
                this.pOld = 0.0f;
            }
        } else if (bl2) {
            this.reconfigMode = false;
        } else {
            this.pOld = (float)(n3 * (this.serverAddresses.size() - (n3 + n2))) / (float)((n3 + n2) * (this.serverAddresses.size() - n3));
            this.pNew = 1.0f - this.pOld;
        }
        this.currentIndex = !this.reconfigMode ? list.indexOf(this.getServerAtCurrentIndex()) : -1;
        this.serverAddresses = list;
        this.currentIndexOld = -1;
        this.currentIndexNew = -1;
        this.lastIndex = this.currentIndex;
        return this.reconfigMode;
    }

    public synchronized InetSocketAddress getServerAtIndex(int n2) {
        if (n2 < 0 || n2 >= this.serverAddresses.size()) {
            return null;
        }
        return this.serverAddresses.get(n2);
    }

    public synchronized InetSocketAddress getServerAtCurrentIndex() {
        return this.getServerAtIndex(this.currentIndex);
    }

    @Override
    public synchronized int size() {
        return this.serverAddresses.size();
    }

    private InetSocketAddress nextHostInReconfigMode() {
        boolean bl2;
        boolean bl3 = bl2 = this.sourceOfRandomness.nextFloat() <= this.pNew;
        if (this.currentIndexNew + 1 < this.newServers.size() && (bl2 || this.currentIndexOld + 1 >= this.oldServers.size())) {
            ++this.currentIndexNew;
            return this.newServers.get(this.currentIndexNew);
        }
        if (this.currentIndexOld + 1 < this.oldServers.size()) {
            ++this.currentIndexOld;
            return this.oldServers.get(this.currentIndexOld);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress next(long l2) {
        InetSocketAddress inetSocketAddress;
        boolean bl2 = false;
        StaticHostProvider staticHostProvider = this;
        synchronized (staticHostProvider) {
            if (this.reconfigMode) {
                inetSocketAddress = this.nextHostInReconfigMode();
                if (inetSocketAddress != null) {
                    this.currentIndex = this.serverAddresses.indexOf(inetSocketAddress);
                    return this.resolve(inetSocketAddress);
                }
                this.reconfigMode = false;
                bl2 = l2 > 0L;
            }
            ++this.currentIndex;
            if (this.currentIndex == this.serverAddresses.size()) {
                this.currentIndex = 0;
            }
            inetSocketAddress = this.serverAddresses.get(this.currentIndex);
            boolean bl3 = bl2 = bl2 || this.currentIndex == this.lastIndex && l2 > 0L;
            if (this.lastIndex == -1) {
                this.lastIndex = 0;
            }
        }
        if (bl2) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                LOG.c("Unexpected exception", interruptedException);
            }
        }
        return this.resolve(inetSocketAddress);
    }

    @Override
    public synchronized void onConnected() {
        this.lastIndex = this.currentIndex;
        this.reconfigMode = false;
    }

    public static interface Resolver {
        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

