/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SyncCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    public static final long SYNC_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    public SyncCommand() {
        super("sync", "path");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        CommandLine commandLine;
        DefaultParser defaultParser = new DefaultParser();
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = commandLine.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String string2 = this.args[1];
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            this.zk.sync(string2, (n2, string, object) -> completableFuture.complete(n2), null);
            int n3 = (Integer)completableFuture.get(SYNC_TIMEOUT, TimeUnit.MILLISECONDS);
            if (n3 == 0) {
                this.out.println("Sync is OK");
            } else {
                this.out.println("Sync has failed. rc=" + n3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new CliWrapperException(interruptedException);
        }
        catch (ExecutionException | TimeoutException exception) {
            throw new CliWrapperException(exception);
        }
        return false;
    }
}

