/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.StatPrinter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class StatCommand
extends CliCommand {
    private static final Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public StatCommand() {
        super("stat", "[-w] path");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(stringArray);
        return this;
    }

    private void retainCompatibility(String[] stringArray) throws CliParseException {
        if (this.args.length > 2) {
            stringArray[2] = "-w";
            this.err.println("'stat path [watch]' has been deprecated. Please use 'stat [-w] path' instead.");
            DefaultParser defaultParser = new DefaultParser();
            try {
                this.cl = defaultParser.parse(options, stringArray);
            }
            catch (ParseException parseException) {
                throw new CliParseException(parseException);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        Stat stat;
        String string = this.args[1];
        boolean bl2 = this.cl.hasOption("w");
        try {
            stat = this.zk.exists(string, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        if (stat == null) {
            throw new CliWrapperException(new KeeperException.NoNodeException(string));
        }
        new StatPrinter(this.out).print(stat);
        return bl2;
    }

    static {
        options.addOption("w", false, "watch");
    }
}

