/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.AclParser;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.StatPrinter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetAclCommand() {
        super("setAcl", "[-s] [-v version] [-R] path acl");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String string3 = this.args[1];
        String string4 = this.args[2];
        List<ACL> list = AclParser.parse(string4);
        int n2 = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            if (this.cl.hasOption("R")) {
                ZKUtil.visitSubTreeDFS(this.zk, string3, false, (n3, string, object, string2) -> {
                    try {
                        this.zk.setACL(string, list, n2);
                    }
                    catch (KeeperException | InterruptedException exception) {
                        this.out.print(exception.getMessage());
                    }
                });
            } else {
                Stat stat = this.zk.setACL(string3, list, n2);
                if (this.cl.hasOption("s")) {
                    new StatPrinter(this.out).print(stat);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
        options.addOption("R", false, "recursive");
    }
}

