/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RemoveWatchesCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public RemoveWatchesCommand() {
        super("removewatches", "path [-c|-d|-a] [-l]");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliWrapperException, MalformedPathException {
        String string = this.args[1];
        Watcher.WatcherType watcherType = Watcher.WatcherType.Any;
        if (this.cl.hasOption("c")) {
            watcherType = Watcher.WatcherType.Children;
        } else if (this.cl.hasOption("d")) {
            watcherType = Watcher.WatcherType.Data;
        } else if (this.cl.hasOption("p")) {
            watcherType = Watcher.WatcherType.Persistent;
        } else if (this.cl.hasOption("r")) {
            watcherType = Watcher.WatcherType.PersistentRecursive;
        } else if (this.cl.hasOption("a")) {
            watcherType = Watcher.WatcherType.Any;
        }
        boolean bl2 = this.cl.hasOption("l");
        try {
            this.zk.removeAllWatches(string, watcherType, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return true;
    }

    static {
        options.addOption("c", false, "child watcher type");
        options.addOption("d", false, "data watcher type");
        options.addOption("p", false, "persistent watcher type");
        options.addOption("r", false, "persistent recursive watcher type");
        options.addOption("a", false, "any watcher type");
        options.addOption("l", false, "remove locally when there is no server connection");
    }
}

