/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Quotas;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.StatsTrack;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ListQuotaCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public ListQuotaCommand() {
        super("listquota", "path");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        CommandLine commandLine;
        DefaultParser defaultParser = new DefaultParser();
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = commandLine.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String string = this.args[1];
        String string2 = Quotas.limitPath(string);
        try {
            this.err.println("absolute path is " + string2);
            List<StatsTrack> list = ListQuotaCommand.listQuota(this.zk, string);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                StatsTrack statsTrack = list.get(i2);
                if (i2 == 0) {
                    this.out.println("Output quota for " + string + " " + statsTrack.toString());
                    continue;
                }
                this.out.println("Output stat for " + string + " " + statsTrack.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException.NoNodeException noNodeException) {
            this.err.println("quota for " + string + " does not exist.");
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        return false;
    }

    public static List<StatsTrack> listQuota(ZooKeeper zooKeeper, String string) throws KeeperException, InterruptedException {
        ArrayList<StatsTrack> arrayList = new ArrayList<StatsTrack>();
        Stat stat = new Stat();
        byte[] byArray = zooKeeper.getData(Quotas.limitPath(string), false, stat);
        StatsTrack statsTrack = new StatsTrack(byArray);
        arrayList.add(statsTrack);
        byArray = zooKeeper.getData(Quotas.statPath(string), false, stat);
        statsTrack = new StatsTrack(byArray);
        arrayList.add(statsTrack);
        return arrayList;
    }
}

