/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.StatPrinter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetCommand() {
        super("get", "[-s] [-w] path");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(stringArray);
        return this;
    }

    private void retainCompatibility(String[] stringArray) throws CliParseException {
        if (this.args.length > 2) {
            stringArray[2] = "-w";
            this.err.println("'get path [watch]' has been deprecated. Please use 'get [-s] [-w] path' instead.");
            DefaultParser defaultParser = new DefaultParser();
            try {
                this.cl = defaultParser.parse(options, stringArray);
            }
            catch (ParseException parseException) {
                throw new CliParseException(parseException);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        byte[] byArray;
        boolean bl2 = this.cl.hasOption("w");
        String string = this.args[1];
        Stat stat = new Stat();
        try {
            byArray = this.zk.getData(string, bl2, stat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        byArray = byArray == null ? "null".getBytes() : byArray;
        this.out.println(new String(byArray, StandardCharsets.UTF_8));
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return bl2;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
    }
}

