/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.cli;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliParseException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliWrapperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedPathException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.StatPrinter;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.Stat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetAclCommand() {
        super("getAcl", "[-s] path");
    }

    @Override
    public CliCommand parse(String[] stringArray) throws CliParseException {
        DefaultParser defaultParser = new DefaultParser();
        try {
            this.cl = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new CliParseException(parseException);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<ACL> list;
        String string = this.args[1];
        Stat stat = new Stat();
        try {
            list = this.zk.getACL(string, stat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedPathException(illegalArgumentException.getMessage());
        }
        catch (KeeperException | InterruptedException exception) {
            throw new CliWrapperException(exception);
        }
        for (ACL aCL : list) {
            this.out.println(aCL.getId() + ": " + ZKUtil.getPermString(aCL.getPerms()));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
    }
}

