/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.audit;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.AuditEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.AuditLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.Slf4jAuditLogger;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ServerCnxnFactory;
import java.lang.reflect.Constructor;

public class ZKAuditProvider {
    static final String AUDIT_ENABLE = "zookeeper.audit.enable";
    static final String AUDIT_IMPL_CLASS = "zookeeper.audit.impl.class";
    private static final foe LOG = goe.a(ZKAuditProvider.class);
    private static boolean auditEnabled = Boolean.getBoolean("zookeeper.audit.enable");
    private static AuditLogger auditLogger;

    private static AuditLogger getAuditLogger() {
        String string = System.getProperty(AUDIT_IMPL_CLASS);
        if (string == null) {
            string = Slf4jAuditLogger.class.getName();
        }
        try {
            Constructor<?> constructor = Class.forName(string).getDeclaredConstructor(new Class[0]);
            AuditLogger auditLogger = (AuditLogger)constructor.newInstance(new Object[0]);
            auditLogger.initialize();
            return auditLogger;
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't instantiate " + string, exception);
        }
    }

    public static boolean isAuditEnabled() {
        return auditEnabled;
    }

    public static void log(String string, String string2, String string3, String string4, String string5, String string6, String string7, AuditEvent.Result result) {
        auditLogger.logAuditEvent(ZKAuditProvider.createLogEvent(string, string2, string3, string4, string5, string6, string7, result));
    }

    static AuditEvent createLogEvent(String string, String string2, AuditEvent.Result result) {
        AuditEvent auditEvent = new AuditEvent(result);
        auditEvent.addEntry(AuditEvent.FieldName.USER, string);
        auditEvent.addEntry(AuditEvent.FieldName.OPERATION, string2);
        return auditEvent;
    }

    static AuditEvent createLogEvent(String string, String string2, String string3, String string4, String string5, String string6, String string7, AuditEvent.Result result) {
        AuditEvent auditEvent = new AuditEvent(result);
        auditEvent.addEntry(AuditEvent.FieldName.SESSION, string6);
        auditEvent.addEntry(AuditEvent.FieldName.USER, string);
        auditEvent.addEntry(AuditEvent.FieldName.IP, string7);
        auditEvent.addEntry(AuditEvent.FieldName.OPERATION, string2);
        auditEvent.addEntry(AuditEvent.FieldName.ZNODE, string3);
        auditEvent.addEntry(AuditEvent.FieldName.ZNODE_TYPE, string5);
        auditEvent.addEntry(AuditEvent.FieldName.ACL, string4);
        return auditEvent;
    }

    public static void addZKStartStopAuditLog() {
        if (ZKAuditProvider.isAuditEnabled()) {
            ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "serverStart", AuditEvent.Result.SUCCESS);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "serverStop", AuditEvent.Result.INVOKED)));
        }
    }

    public static void addServerStartFailureAuditLog() {
        if (ZKAuditProvider.isAuditEnabled()) {
            ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "serverStart", AuditEvent.Result.FAILURE);
        }
    }

    private static void log(String string, String string2, AuditEvent.Result result) {
        auditLogger.logAuditEvent(ZKAuditProvider.createLogEvent(string, string2, result));
    }

    public static String getZKUser() {
        return ServerCnxnFactory.getUserName();
    }

    static {
        if (auditEnabled) {
            auditLogger = ZKAuditProvider.getAuditLogger();
            LOG.c("ZooKeeper audit is enabled.");
        } else {
            LOG.c("ZooKeeper audit is disabled.");
        }
    }
}

