/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.audit;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiOperationRecord;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKUtil;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.AuditEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.audit.ZKAuditProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.DataTree;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.Request;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class AuditHelper {
    private static final foe LOG = goe.a(AuditHelper.class);

    public static void addAuditLog(Request request, DataTree.ProcessTxnResult processTxnResult) {
        AuditHelper.addAuditLog(request, processTxnResult, false);
    }

    public static void addAuditLog(Request request, DataTree.ProcessTxnResult processTxnResult, boolean bl2) {
        if (!ZKAuditProvider.isAuditEnabled()) {
            return;
        }
        String string = processTxnResult.path;
        String string2 = null;
        String string3 = null;
        try {
            Object object;
            String string4;
            switch (request.type) {
                case 1: 
                case 15: 
                case 19: {
                    string4 = "create";
                    object = request.readRequestRecord(CreateRequest::new);
                    string3 = AuditHelper.getCreateMode((CreateRequest)object);
                    if (!bl2) break;
                    string = ((CreateRequest)object).getPath();
                    break;
                }
                case 2: 
                case 20: {
                    string4 = "delete";
                    if (!bl2) break;
                    DeleteRequest deleteRequest = request.readRequestRecord(DeleteRequest::new);
                    string = deleteRequest.getPath();
                    break;
                }
                case 5: {
                    string4 = "setData";
                    if (!bl2) break;
                    SetDataRequest setDataRequest = request.readRequestRecord(SetDataRequest::new);
                    string = setDataRequest.getPath();
                    break;
                }
                case 7: {
                    string4 = "setAcl";
                    SetACLRequest setACLRequest = request.readRequestRecord(SetACLRequest::new);
                    string2 = ZKUtil.aclToString(setACLRequest.getAcl());
                    if (!bl2) break;
                    string = setACLRequest.getPath();
                    break;
                }
                case 14: {
                    if (bl2) {
                        string4 = "multiOperation";
                        break;
                    }
                    AuditHelper.logMultiOperation(request, processTxnResult);
                    return;
                }
                case 16: {
                    string4 = "reconfig";
                    break;
                }
                default: {
                    return;
                }
            }
            object = AuditHelper.getResult(processTxnResult, bl2);
            AuditHelper.log(request, string, string4, string2, string3, (AuditEvent.Result)((Object)object));
        }
        catch (Throwable throwable) {
            LOG.e("Failed to audit log request {}", (Object)request.type, (Object)throwable);
        }
    }

    private static AuditEvent.Result getResult(DataTree.ProcessTxnResult processTxnResult, boolean bl2) {
        if (bl2) {
            return AuditEvent.Result.FAILURE;
        }
        return processTxnResult.err == KeeperException.Code.OK.intValue() ? AuditEvent.Result.SUCCESS : AuditEvent.Result.FAILURE;
    }

    private static void logMultiOperation(Request request, DataTree.ProcessTxnResult processTxnResult) throws IOException, KeeperException {
        Map<String, String> map = AuditHelper.getCreateModes(request);
        boolean bl2 = false;
        for (DataTree.ProcessTxnResult processTxnResult2 : processTxnResult.multiResult) {
            switch (processTxnResult2.type) {
                case 1: 
                case 15: 
                case 19: 
                case 21: {
                    AuditHelper.log(request, processTxnResult2.path, "create", null, map.get(processTxnResult2.path), AuditEvent.Result.SUCCESS);
                    break;
                }
                case 2: 
                case 20: {
                    AuditHelper.log(request, processTxnResult2.path, "delete", null, null, AuditEvent.Result.SUCCESS);
                    break;
                }
                case 5: {
                    AuditHelper.log(request, processTxnResult2.path, "setData", null, null, AuditEvent.Result.SUCCESS);
                    break;
                }
                case -1: {
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            AuditHelper.log(request, processTxnResult.path, "multiOperation", null, null, AuditEvent.Result.FAILURE);
        }
    }

    private static void log(Request request, String string, String string2, String string3, String string4, AuditEvent.Result result) {
        AuditHelper.log(request.getUsersForAudit(), string2, string, string3, string4, request.cnxn.getSessionIdHex(), request.cnxn.getHostAddress(), result);
    }

    private static void log(String string, String string2, String string3, String string4, String string5, String string6, String string7, AuditEvent.Result result) {
        ZKAuditProvider.log(string, string2, string3, string4, string5, string6, string7, result);
    }

    private static String getCreateMode(CreateRequest createRequest) throws KeeperException {
        return CreateMode.fromFlag(createRequest.getFlags()).toString().toLowerCase();
    }

    private static Map<String, String> getCreateModes(Request request) throws IOException, KeeperException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!ZKAuditProvider.isAuditEnabled()) {
            return hashMap;
        }
        MultiOperationRecord multiOperationRecord = request.readRequestRecord(MultiOperationRecord::new);
        for (Op op2 : multiOperationRecord) {
            if (op2.getType() != 1 && op2.getType() != 15 && op2.getType() != 19) continue;
            CreateRequest createRequest = (CreateRequest)op2.toRequestRecord();
            hashMap.put(createRequest.getPath(), AuditHelper.getCreateMode(createRequest));
        }
        return hashMap;
    }
}

