/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper.audit;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class AuditEvent {
    private static final char PAIR_SEPARATOR = '\t';
    private static final String KEY_VAL_SEPARATOR = "=";
    private Map<String, String> logEntries = new LinkedHashMap<String, String>();
    private Result result;

    AuditEvent(Result result) {
        this.result = result;
    }

    public Set<Map.Entry<String, String>> getLogEntries() {
        return this.logEntries.entrySet();
    }

    void addEntry(FieldName fieldName, String string) {
        if (string != null) {
            this.logEntries.put(fieldName.name().toLowerCase(), string);
        }
    }

    public String getValue(FieldName fieldName) {
        return this.logEntries.get(fieldName.name().toLowerCase());
    }

    public Result getResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Map.Entry<String, String> entry : this.logEntries.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (null == string2) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append('\t');
            }
            stringBuilder.append(string).append(KEY_VAL_SEPARATOR).append(string2);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\t');
        }
        stringBuilder.append("result").append(KEY_VAL_SEPARATOR).append(this.result.name().toLowerCase());
        return stringBuilder.toString();
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        INVOKED;

    }

    public static enum FieldName {
        USER,
        OPERATION,
        IP,
        ACL,
        ZNODE,
        SESSION,
        ZNODE_TYPE;

    }
}

