/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.admin.ZooKeeperAdmin;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliCommand;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CliException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CommandFactory;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.CommandNotFoundException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.cli.MalformedCommandException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ExitCode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ZooKeeperMain {
    private static final foe LOG = goe.a(ZooKeeperMain.class);
    static final Map<String, String> commandMap = new HashMap<String, String>();
    static final Map<String, CliCommand> commandMapCli = new HashMap<String, CliCommand>();
    protected MyCommandOptions cl = new MyCommandOptions();
    protected HashMap<Integer, String> history = new HashMap();
    protected int commandCount = 0;
    protected boolean printWatches = true;
    protected int exitCode = ExitCode.EXECUTION_FINISHED.getValue();
    protected ZooKeeper zk;
    protected String host = "";
    private CountDownLatch connectLatch = null;

    public boolean getPrintWatches() {
        return this.printWatches;
    }

    static void usage() {
        System.err.println("ZooKeeper -server host:port -client-configuration properties-file cmd args");
        ArrayList<String> arrayList = new ArrayList<String>(commandMap.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            System.err.println("\t" + string + " " + commandMap.get(string));
        }
    }

    protected void addToHistory(int n2, String string) {
        this.history.put(n2, string);
    }

    public static List<String> getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>(commandMap.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    protected String getPrompt() {
        return "[zk: " + this.host + "(" + (Object)((Object)this.zk.getState()) + ") " + this.commandCount + "] ";
    }

    public static void printMessage(String string) {
        System.out.println("\n" + string);
    }

    protected void connectToZK(String string) throws InterruptedException, IOException {
        boolean bl2;
        if (this.zk != null && this.zk.getState().isAlive()) {
            this.zk.close();
        }
        this.host = string;
        boolean bl3 = bl2 = this.cl.getOption("readonly") != null;
        if (this.cl.getOption("secure") != null) {
            System.setProperty("zookeeper.client.secure", "true");
            System.out.println("Secure connection is enabled");
        }
        ZKClientConfig zKClientConfig = null;
        if (this.cl.getOption("client-configuration") != null) {
            try {
                zKClientConfig = new ZKClientConfig(this.cl.getOption("client-configuration"));
            }
            catch (QuorumPeerConfig.ConfigException configException) {
                configException.printStackTrace();
                ServiceUtils.requestSystemExit(ExitCode.INVALID_INVOCATION.getValue());
            }
        }
        if (this.cl.getOption("waitforconnection") != null) {
            this.connectLatch = new CountDownLatch(1);
        }
        int n2 = Integer.parseInt(this.cl.getOption("timeout"));
        this.zk = new ZooKeeperAdmin(this.host, n2, (Watcher)new MyWatcher(), bl2, zKClientConfig);
        if (this.connectLatch != null && !this.connectLatch.await(n2, TimeUnit.MILLISECONDS)) {
            this.zk.close();
            throw new IOException(KeeperException.create(KeeperException.Code.CONNECTIONLOSS));
        }
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        ZooKeeperMain zooKeeperMain = new ZooKeeperMain(stringArray);
        zooKeeperMain.run();
    }

    public ZooKeeperMain(String[] stringArray) throws IOException, InterruptedException {
        this.cl.parseOptions(stringArray);
        System.out.println("Connecting to " + this.cl.getOption("server"));
        this.connectToZK(this.cl.getOption("server"));
    }

    public ZooKeeperMain(ZooKeeper zooKeeper) {
        this.zk = zooKeeper;
    }

    void run() throws IOException, InterruptedException {
        if (this.cl.getCommand() == null) {
            Object object;
            Object object2;
            System.out.println("Welcome to ZooKeeper!");
            boolean bl2 = false;
            try {
                String string;
                object2 = Class.forName("jline.console.ConsoleReader");
                object = Class.forName("XdepsXdatabricksX240X9088.org.apache.zookeeper.JLineZNodeCompleter");
                System.out.println("JLine support is enabled");
                Object obj = ((Class)object2).getConstructor(new Class[0]).newInstance(new Object[0]);
                Object obj2 = ((Class)object).getConstructor(ZooKeeper.class).newInstance(this.zk);
                Method method = ((Class)object2).getMethod("addCompleter", Class.forName("jline.console.completer.Completer"));
                method.invoke(obj, obj2);
                Method method2 = ((Class)object2).getMethod("readLine", String.class);
                while ((string = (String)method2.invoke(obj, this.getPrompt())) != null) {
                    this.executeLine(string);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                LOG.a("Unable to start jline", reflectiveOperationException);
                bl2 = true;
            }
            if (bl2) {
                System.out.println("JLine support is disabled");
                object2 = new BufferedReader(new InputStreamReader(System.in));
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    this.executeLine((String)object);
                }
            }
        } else {
            this.processCmd(this.cl);
        }
        ServiceUtils.requestSystemExit(this.exitCode);
    }

    public void executeLine(String string) throws InterruptedException, IOException {
        if (!string.equals("")) {
            this.cl.parseCommand(string);
            this.addToHistory(this.commandCount, string);
            this.processCmd(this.cl);
            ++this.commandCount;
        }
    }

    protected boolean processCmd(MyCommandOptions myCommandOptions) throws IOException, InterruptedException {
        boolean bl2 = false;
        try {
            bl2 = this.processZKCmd(myCommandOptions);
            this.exitCode = ExitCode.EXECUTION_FINISHED.getValue();
        }
        catch (CliException cliException) {
            this.exitCode = cliException.getExitCode();
            System.err.println(cliException.getMessage());
        }
        return bl2;
    }

    protected boolean processZKCmd(MyCommandOptions myCommandOptions) throws CliException, IOException, InterruptedException {
        Object object;
        String[] stringArray = myCommandOptions.getArgArray();
        String string = myCommandOptions.getCommand();
        if (stringArray.length < 1) {
            ZooKeeperMain.usage();
            throw new MalformedCommandException("No command entered");
        }
        if (!commandMap.containsKey(string)) {
            ZooKeeperMain.usage();
            throw new CommandNotFoundException("Command not found " + string);
        }
        boolean bl2 = false;
        LOG.b("Processing {}", (Object)string);
        if (string.equals("quit")) {
            this.zk.close();
            ServiceUtils.requestSystemExit(this.exitCode);
        } else if (string.equals("redo") && stringArray.length >= 2) {
            object = Integer.decode(stringArray[1]);
            if (this.commandCount <= (Integer)object || (Integer)object < 0) {
                throw new MalformedCommandException("Command index out of range");
            }
            this.cl.parseCommand(this.history.get(object));
            if (this.cl.getCommand().equals("redo")) {
                throw new MalformedCommandException("No redoing redos");
            }
            this.history.put(this.commandCount, this.history.get(object));
            this.processCmd(this.cl);
        } else if (string.equals("history")) {
            for (int i2 = this.commandCount - 10; i2 <= this.commandCount; ++i2) {
                if (i2 < 0) continue;
                System.out.println(i2 + " - " + this.history.get(i2));
            }
        } else if (string.equals("printwatches")) {
            if (stringArray.length == 1) {
                System.out.println("printwatches is " + (this.printWatches ? "on" : "off"));
            } else {
                this.printWatches = stringArray[1].equals("on");
            }
        } else if (string.equals("connect")) {
            if (stringArray.length >= 2) {
                this.connectToZK(stringArray[1]);
            } else {
                this.connectToZK(this.host);
            }
        }
        if (this.zk == null || !this.zk.getState().isAlive()) {
            System.out.println("Not connected");
            return false;
        }
        object = commandMapCli.get(string);
        if (object != null) {
            ((CliCommand)object).setZk(this.zk);
            bl2 = ((CliCommand)object).parse(stringArray).exec();
        } else if (!commandMap.containsKey(string)) {
            ZooKeeperMain.usage();
        }
        return bl2;
    }

    static {
        commandMap.put("connect", "host:port");
        commandMap.put("history", "");
        commandMap.put("redo", "cmdno");
        commandMap.put("printwatches", "on|off");
        commandMap.put("quit", "");
        Stream.of(CommandFactory.Command.values()).map(command -> CommandFactory.getInstance(command)).forEach(cliCommand -> {
            cliCommand.addToMap(commandMapCli);
            commandMap.put(cliCommand.getCmdStr(), cliCommand.getOptionStr());
        });
    }

    static class MyCommandOptions {
        private Map<String, String> options = new HashMap<String, String>();
        private List<String> cmdArgs = null;
        private String command = null;
        public static final Pattern ARGS_PATTERN = Pattern.compile("\\s*([^\"']\\S*|\"[^\"]*\"|'[^']*')\\s*");
        public static final Pattern QUOTED_PATTERN = Pattern.compile("^(['\"])(.*)(\\1)$");

        public MyCommandOptions() {
            this.options.put("server", "localhost:2181");
            this.options.put("timeout", "30000");
        }

        public String getOption(String string) {
            return this.options.get(string);
        }

        public String getCommand() {
            return this.command;
        }

        public String getCmdArgument(int n2) {
            return this.cmdArgs.get(n2);
        }

        public int getNumArguments() {
            return this.cmdArgs.size();
        }

        public String[] getArgArray() {
            return this.cmdArgs.toArray(new String[0]);
        }

        public boolean parseOptions(String[] stringArray) {
            List<String> list = Arrays.asList(stringArray);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                try {
                    if (string.equals("-server")) {
                        this.options.put("server", iterator.next());
                    } else if (string.equals("-timeout")) {
                        this.options.put("timeout", iterator.next());
                    } else if (string.equals("-r")) {
                        this.options.put("readonly", "true");
                    } else if (string.equals("-client-configuration")) {
                        this.options.put("client-configuration", iterator.next());
                    } else if (string.equals("-waitforconnection")) {
                        this.options.put("waitforconnection", "true");
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.err.println("Error: no argument found for option " + string);
                    return false;
                }
                if (string.startsWith("-")) continue;
                this.command = string;
                this.cmdArgs = new ArrayList<String>();
                this.cmdArgs.add(this.command);
                while (iterator.hasNext()) {
                    this.cmdArgs.add(iterator.next());
                }
                return true;
            }
            return true;
        }

        public boolean parseCommand(String string) {
            Matcher matcher = ARGS_PATTERN.matcher(string);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (matcher.find()) {
                String string2 = matcher.group(1);
                if (QUOTED_PATTERN.matcher(string2).matches()) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                linkedList.add(string2);
            }
            if (linkedList.isEmpty()) {
                return false;
            }
            this.command = (String)linkedList.get(0);
            this.cmdArgs = linkedList;
            return true;
        }
    }

    class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent watchedEvent) {
            if (ZooKeeperMain.this.getPrintWatches()) {
                ZooKeeperMain.printMessage("WATCHER::");
                ZooKeeperMain.printMessage(watchedEvent.toString());
            }
            if (ZooKeeperMain.this.connectLatch != null && watchedEvent.getType() == Watcher.Event.EventType.None && watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                ZooKeeperMain.this.connectLatch.countDown();
            }
        }
    }
}

