/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.watch.PathParentIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ZKWatchManager
implements ClientWatchManager {
    private static final foe LOG = goe.a(ZKWatchManager.class);
    private final Map<String, Set<Watcher>> dataWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> existWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> childWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> persistentWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> persistentRecursiveWatches = new HashMap<String, Set<Watcher>>();
    private final boolean disableAutoWatchReset;
    private volatile Watcher defaultWatcher;

    ZKWatchManager(boolean bl2, Watcher watcher) {
        this.disableAutoWatchReset = bl2;
        this.defaultWatcher = watcher;
    }

    void setDefaultWatcher(Watcher watcher) {
        this.defaultWatcher = watcher;
    }

    Watcher getDefaultWatcher() {
        return this.defaultWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDataWatchList() {
        Map<String, Set<Watcher>> map = this.dataWatches;
        synchronized (map) {
            return new ArrayList<String>(this.dataWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getChildWatchList() {
        Map<String, Set<Watcher>> map = this.childWatches;
        synchronized (map) {
            return new ArrayList<String>(this.childWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getExistWatchList() {
        Map<String, Set<Watcher>> map = this.existWatches;
        synchronized (map) {
            return new ArrayList<String>(this.existWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPersistentWatchList() {
        Map<String, Set<Watcher>> map = this.persistentWatches;
        synchronized (map) {
            return new ArrayList<String>(this.persistentWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPersistentRecursiveWatchList() {
        Map<String, Set<Watcher>> map = this.persistentRecursiveWatches;
        synchronized (map) {
            return new ArrayList<String>(this.persistentRecursiveWatches.keySet());
        }
    }

    Map<String, Set<Watcher>> getDataWatches() {
        return this.dataWatches;
    }

    Map<String, Set<Watcher>> getExistWatches() {
        return this.existWatches;
    }

    Map<String, Set<Watcher>> getChildWatches() {
        return this.childWatches;
    }

    Map<String, Set<Watcher>> getPersistentWatches() {
        return this.persistentWatches;
    }

    Map<String, Set<Watcher>> getPersistentRecursiveWatches() {
        return this.persistentRecursiveWatches;
    }

    private void addTo(Set<Watcher> set, Set<Watcher> set2) {
        if (set != null) {
            set2.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Watcher.Event.EventType, Set<Watcher>> removeWatcher(String string, Watcher watcher, Watcher.WatcherType watcherType, boolean bl2, int n2) throws KeeperException {
        this.containsWatcher(string, watcher, watcherType);
        HashMap<Watcher.Event.EventType, Set<Watcher>> hashMap = new HashMap<Watcher.Event.EventType, Set<Watcher>>();
        HashSet<Watcher> hashSet = new HashSet<Watcher>();
        hashMap.put(Watcher.Event.EventType.ChildWatchRemoved, hashSet);
        HashSet<Watcher> hashSet2 = new HashSet<Watcher>();
        hashMap.put(Watcher.Event.EventType.DataWatchRemoved, hashSet2);
        HashSet<Watcher> hashSet3 = new HashSet<Watcher>();
        hashMap.put(Watcher.Event.EventType.PersistentWatchRemoved, hashSet3);
        boolean bl3 = false;
        switch (watcherType) {
            case Children: {
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    bl3 = this.removeWatches(this.childWatches, watcher, string, bl2, n2, hashSet);
                    break;
                }
            }
            case Data: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    bl3 = this.removeWatches(this.dataWatches, watcher, string, bl2, n2, hashSet2);
                }
                map = this.existWatches;
                synchronized (map) {
                    boolean bl4 = this.removeWatches(this.existWatches, watcher, string, bl2, n2, hashSet2);
                    bl3 |= bl4;
                    break;
                }
            }
            case Persistent: {
                Map<String, Set<Watcher>> map = this.persistentWatches;
                synchronized (map) {
                    bl3 = this.removeWatches(this.persistentWatches, watcher, string, bl2, n2, hashSet3);
                    break;
                }
            }
            case PersistentRecursive: {
                Map<String, Set<Watcher>> map = this.persistentRecursiveWatches;
                synchronized (map) {
                    bl3 = this.removeWatches(this.persistentRecursiveWatches, watcher, string, bl2, n2, hashSet3);
                    break;
                }
            }
            case Any: {
                boolean bl5;
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    bl3 = this.removeWatches(this.childWatches, watcher, string, bl2, n2, hashSet);
                }
                map = this.dataWatches;
                synchronized (map) {
                    bl5 = this.removeWatches(this.dataWatches, watcher, string, bl2, n2, hashSet2);
                    bl3 |= bl5;
                }
                map = this.existWatches;
                synchronized (map) {
                    bl5 = this.removeWatches(this.existWatches, watcher, string, bl2, n2, hashSet2);
                    bl3 |= bl5;
                }
                map = this.persistentWatches;
                synchronized (map) {
                    bl5 = this.removeWatches(this.persistentWatches, watcher, string, bl2, n2, hashSet3);
                    bl3 |= bl5;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    bl5 = this.removeWatches(this.persistentRecursiveWatches, watcher, string, bl2, n2, hashSet3);
                    bl3 |= bl5;
                    break;
                }
            }
        }
        if (!bl3) {
            throw new KeeperException.NoWatcherException(string);
        }
        return hashMap;
    }

    private boolean contains(String string, Watcher watcher, Map<String, Set<Watcher>> map) {
        Set<Watcher> set;
        boolean bl2 = true;
        bl2 = map == null || map.size() == 0 ? false : ((set = map.get(string)) == null ? false : (watcher == null ? set.size() > 0 : set.contains(watcher)));
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containsWatcher(String string, Watcher watcher, Watcher.WatcherType watcherType) throws KeeperException.NoWatcherException {
        boolean bl2 = false;
        switch (watcherType) {
            case Children: {
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    bl2 = this.contains(string, watcher, this.childWatches);
                    break;
                }
            }
            case Data: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    bl2 = this.contains(string, watcher, this.dataWatches);
                }
                map = this.existWatches;
                synchronized (map) {
                    boolean bl3 = this.contains(string, watcher, this.existWatches);
                    bl2 |= bl3;
                    break;
                }
            }
            case Persistent: {
                Map<String, Set<Watcher>> map = this.persistentWatches;
                synchronized (map) {
                    bl2 |= this.contains(string, watcher, this.persistentWatches);
                    break;
                }
            }
            case PersistentRecursive: {
                Map<String, Set<Watcher>> map = this.persistentRecursiveWatches;
                synchronized (map) {
                    bl2 |= this.contains(string, watcher, this.persistentRecursiveWatches);
                    break;
                }
            }
            case Any: {
                boolean bl4;
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    bl2 = this.contains(string, watcher, this.childWatches);
                }
                map = this.dataWatches;
                synchronized (map) {
                    bl4 = this.contains(string, watcher, this.dataWatches);
                    bl2 |= bl4;
                }
                map = this.existWatches;
                synchronized (map) {
                    bl4 = this.contains(string, watcher, this.existWatches);
                    bl2 |= bl4;
                }
                map = this.persistentWatches;
                synchronized (map) {
                    bl4 = this.contains(string, watcher, this.persistentWatches);
                    bl2 |= bl4;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    bl4 = this.contains(string, watcher, this.persistentRecursiveWatches);
                    bl2 |= bl4;
                    break;
                }
            }
        }
        if (!bl2) {
            throw new KeeperException.NoWatcherException(string);
        }
    }

    protected boolean removeWatches(Map<String, Set<Watcher>> map, Watcher watcher, String string, boolean bl2, int n2, Set<Watcher> set) throws KeeperException {
        if (!bl2 && n2 != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create(KeeperException.Code.get(n2), string);
        }
        boolean bl3 = false;
        if (n2 == KeeperException.Code.OK.intValue() || bl2 && n2 != KeeperException.Code.OK.intValue()) {
            if (watcher == null) {
                Set<Watcher> set2 = map.remove(string);
                if (set2 != null) {
                    set.addAll(set2);
                    bl3 = true;
                }
            } else {
                Set<Watcher> set3 = map.get(string);
                if (set3 != null && set3.remove(watcher)) {
                    set.add(watcher);
                    if (set3.size() <= 0) {
                        map.remove(string);
                    }
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Watcher> materialize(Watcher.Event.KeeperState keeperState, Watcher.Event.EventType eventType, String string) {
        HashSet<Watcher> hashSet = new HashSet<Watcher>();
        switch (eventType) {
            case None: {
                if (this.defaultWatcher != null) {
                    hashSet.add(this.defaultWatcher);
                }
                boolean bl2 = this.disableAutoWatchReset && keeperState != Watcher.Event.KeeperState.SyncConnected;
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    for (Set<Watcher> set : this.dataWatches.values()) {
                        hashSet.addAll(set);
                    }
                    if (bl2) {
                        this.dataWatches.clear();
                    }
                }
                map = this.existWatches;
                synchronized (map) {
                    for (Set<Watcher> set : this.existWatches.values()) {
                        hashSet.addAll(set);
                    }
                    if (bl2) {
                        this.existWatches.clear();
                    }
                }
                map = this.childWatches;
                synchronized (map) {
                    for (Set<Watcher> set : this.childWatches.values()) {
                        hashSet.addAll(set);
                    }
                    if (bl2) {
                        this.childWatches.clear();
                    }
                }
                map = this.persistentWatches;
                synchronized (map) {
                    for (Set<Watcher> set : this.persistentWatches.values()) {
                        hashSet.addAll(set);
                    }
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    for (Set<Watcher> set : this.persistentRecursiveWatches.values()) {
                        hashSet.addAll(set);
                    }
                }
                return hashSet;
            }
            case NodeDataChanged: 
            case NodeCreated: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    this.addTo(this.dataWatches.remove(string), hashSet);
                }
                map = this.existWatches;
                synchronized (map) {
                    this.addTo(this.existWatches.remove(string), hashSet);
                }
                this.addPersistentWatches(string, eventType, hashSet);
                break;
            }
            case NodeChildrenChanged: {
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    this.addTo(this.childWatches.remove(string), hashSet);
                }
                this.addPersistentWatches(string, eventType, hashSet);
                break;
            }
            case NodeDeleted: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    this.addTo(this.dataWatches.remove(string), hashSet);
                }
                map = this.existWatches;
                synchronized (map) {
                    Set<Watcher> set = this.existWatches.remove(string);
                    if (set != null) {
                        this.addTo(set, hashSet);
                        LOG.d("We are triggering an exists watch for delete! Shouldn't happen!");
                    }
                }
                map = this.childWatches;
                synchronized (map) {
                    this.addTo(this.childWatches.remove(string), hashSet);
                }
                this.addPersistentWatches(string, eventType, hashSet);
                break;
            }
            default: {
                String string2 = String.format("Unhandled watch event type %s with state %s on path %s", new Object[]{eventType, keeperState, string});
                LOG.e(string2);
                throw new RuntimeException(string2);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistentWatches(String string, Watcher.Event.EventType eventType, Set<Watcher> set) {
        Map<String, Set<Watcher>> map = this.persistentWatches;
        synchronized (map) {
            this.addTo(this.persistentWatches.get(string), set);
        }
        if (eventType == Watcher.Event.EventType.NodeChildrenChanged) {
            return;
        }
        map = this.persistentRecursiveWatches;
        synchronized (map) {
            for (String string2 : PathParentIterator.forAll(string).asIterable()) {
                this.addTo(this.persistentRecursiveWatches.get(string2), set);
            }
        }
    }
}

