/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.AsyncCallback;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Op;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class ZKUtil {
    private static final foe LOG = goe.a(ZKUtil.class);
    private static final Map<Integer, String> permCache = new ConcurrentHashMap<Integer, String>();

    public static boolean deleteRecursive(ZooKeeper zooKeeper, String string, int n2) throws InterruptedException, KeeperException {
        PathUtils.validatePath(string);
        List<String> list = ZKUtil.listSubTreeBFS(zooKeeper, string);
        LOG.b("Deleting tree: {}", (Object)list);
        if (n2 > 0) {
            return ZKUtil.deleteInBatch(zooKeeper, list, n2);
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            zooKeeper.delete(list.get(i2), -1);
        }
        return true;
    }

    public static void deleteRecursive(ZooKeeper zooKeeper, String string) throws InterruptedException, KeeperException {
        ZKUtil.deleteRecursive(zooKeeper, string, 0);
    }

    private static boolean deleteInBatch(ZooKeeper zooKeeper, List<String> list2, int n3) throws InterruptedException {
        int n4 = 10;
        ArrayList<Op> arrayList = new ArrayList<Op>();
        BatchedDeleteCbContext batchedDeleteCbContext = new BatchedDeleteCbContext(n4);
        AsyncCallback.MultiCallback multiCallback = (n2, string, object, list) -> {
            if (n2 != KeeperException.Code.OK.intValue()) {
                ((BatchedDeleteCbContext)object).success.set(false);
            }
            ((BatchedDeleteCbContext)object).sem.release();
        };
        for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
            arrayList.add(Op.delete(list2.get(i2), -1));
            if (arrayList.size() != n3 && i2 != 0) continue;
            if (!batchedDeleteCbContext.success.get()) break;
            batchedDeleteCbContext.sem.acquire();
            zooKeeper.multi(arrayList, multiCallback, batchedDeleteCbContext);
            arrayList = new ArrayList();
        }
        batchedDeleteCbContext.sem.acquire(n4);
        return batchedDeleteCbContext.success.get();
    }

    public static void deleteRecursive(ZooKeeper zooKeeper, String string, AsyncCallback.VoidCallback voidCallback, Object object) throws InterruptedException, KeeperException {
        PathUtils.validatePath(string);
        List<String> list = ZKUtil.listSubTreeBFS(zooKeeper, string);
        LOG.b("Deleting tree: {}", (Object)list);
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            zooKeeper.delete(list.get(i2), -1, voidCallback, object);
        }
    }

    public static String validateFileInput(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return "File '" + file.getAbsolutePath() + "' does not exist.";
        }
        if (!file.canRead()) {
            return "Read permission is denied on the file '" + file.getAbsolutePath() + "'";
        }
        if (file.isDirectory()) {
            return "'" + file.getAbsolutePath() + "' is a directory. it must be a file.";
        }
        return null;
    }

    public static List<String> listSubTreeBFS(ZooKeeper zooKeeper, String string) throws KeeperException, InterruptedException {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayDeque.add(string);
        arrayList.add(string);
        while (!arrayDeque.isEmpty()) {
            String string2 = (String)arrayDeque.poll();
            List<String> list = zooKeeper.getChildren(string2, false);
            for (String string3 : list) {
                String string4 = (string2.equals("/") ? "" : string2) + "/" + string3;
                arrayDeque.add(string4);
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public static void visitSubTreeDFS(ZooKeeper zooKeeper, String string, boolean bl2, AsyncCallback.StringCallback stringCallback) throws KeeperException, InterruptedException {
        PathUtils.validatePath(string);
        zooKeeper.getData(string, bl2, null);
        stringCallback.processResult(KeeperException.Code.OK.intValue(), string, null, string);
        ZKUtil.visitSubTreeDFSHelper(zooKeeper, string, bl2, stringCallback);
    }

    private static void visitSubTreeDFSHelper(ZooKeeper zooKeeper, String string, boolean bl2, AsyncCallback.StringCallback stringCallback) throws KeeperException, InterruptedException {
        boolean bl3 = string.length() == 1;
        try {
            String string2;
            List<String> list = zooKeeper.getChildren(string, bl2, null);
            Collections.sort(list);
            for (String string3 : list) {
                string2 = (bl3 ? string : string + "/") + string3;
                stringCallback.processResult(KeeperException.Code.OK.intValue(), string2, null, string3);
            }
            for (String string3 : list) {
                string2 = (bl3 ? string : string + "/") + string3;
                ZKUtil.visitSubTreeDFSHelper(zooKeeper, string2, bl2, stringCallback);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return;
        }
    }

    public static String getPermString(int n3) {
        return permCache.computeIfAbsent(n3, n2 -> ZKUtil.constructPermString(n2));
    }

    private static String constructPermString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 4) != 0) {
            stringBuilder.append('c');
        }
        if ((n2 & 8) != 0) {
            stringBuilder.append('d');
        }
        if ((n2 & 1) != 0) {
            stringBuilder.append('r');
        }
        if ((n2 & 2) != 0) {
            stringBuilder.append('w');
        }
        if ((n2 & 0x10) != 0) {
            stringBuilder.append('a');
        }
        return stringBuilder.toString();
    }

    public static String aclToString(List<ACL> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ACL aCL : list) {
            stringBuilder.append(aCL.getId().getScheme());
            stringBuilder.append(":");
            stringBuilder.append(aCL.getId().getId());
            stringBuilder.append(":");
            stringBuilder.append(ZKUtil.getPermString(aCL.getPerms()));
        }
        return stringBuilder.toString();
    }

    static class BatchedDeleteCbContext {
        public Semaphore sem;
        public AtomicBoolean success;

        public BatchedDeleteCbContext(int n2) {
            this.sem = new Semaphore(n2);
            this.success = new AtomicBoolean(true);
        }
    }
}

