/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class StatsTrack {
    private static final String countStr = "count";
    private static final String countHardLimitStr = "countHardLimit";
    private static final String byteStr = "bytes";
    private static final String byteHardLimitStr = "byteHardLimit";
    private final Map<String, Long> stats = new HashMap<String, Long>();
    private static final Pattern PAIRS_SEPARATOR = Pattern.compile("[,;]+");

    public StatsTrack() {
        this("");
    }

    public StatsTrack(byte[] byArray) {
        this(new String(byArray, StandardCharsets.UTF_8));
    }

    public StatsTrack(String string) {
        String[] stringArray;
        this.stats.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        for (String string2 : stringArray = PAIRS_SEPARATOR.split(string)) {
            String[] stringArray2 = string2.split("=");
            this.stats.put(stringArray2[0], Long.parseLong(StringUtils.isEmpty(stringArray2[1]) ? "-1" : stringArray2[1]));
        }
    }

    public long getCount() {
        return this.getValue(countStr);
    }

    public void setCount(long l2) {
        this.setValue(countStr, l2);
    }

    public long getCountHardLimit() {
        return this.getValue(countHardLimitStr);
    }

    public void setCountHardLimit(long l2) {
        this.setValue(countHardLimitStr, l2);
    }

    public long getBytes() {
        return this.getValue(byteStr);
    }

    public void setBytes(long l2) {
        this.setValue(byteStr, l2);
    }

    public long getByteHardLimit() {
        return this.getValue(byteHardLimitStr);
    }

    public void setByteHardLimit(long l2) {
        this.setValue(byteHardLimitStr, l2);
    }

    private long getValue(String string) {
        Long l2 = this.stats.get(string);
        return l2 == null ? -1L : l2;
    }

    private void setValue(String string, long l2) {
        this.stats.put(string, l2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.stats.keySet());
        arrayList.remove(countStr);
        arrayList.remove(byteStr);
        stringBuilder.append(countStr);
        stringBuilder.append("=");
        stringBuilder.append(this.getCount());
        stringBuilder.append(",");
        stringBuilder.append(byteStr);
        stringBuilder.append("=");
        stringBuilder.append(this.getBytes());
        if (!arrayList.isEmpty()) {
            stringBuilder.append("=");
            Collections.sort(arrayList);
            for (String string : arrayList) {
                stringBuilder.append(";");
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(this.stats.get(string));
            }
        }
        return stringBuilder.toString();
    }

    public byte[] getStatsBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StatsTrack statsTrack = (StatsTrack)object;
        return Objects.equals(this.stats, statsTrack.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }
}

