/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateMode;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.CreateOptions;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.PathUtils;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.data.ACL;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CheckVersionRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateTTLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.DeleteRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.EphemeralType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class Op {
    private int type;
    private String path;
    private OpKind opKind;

    private Op(int n2, String string, OpKind opKind) {
        this.type = n2;
        this.path = string;
        this.opKind = opKind;
    }

    public static Op create(String string, byte[] byArray, List<ACL> list, int n2) {
        return new Create(string, byArray, list, n2);
    }

    public static Op create(String string, byte[] byArray, List<ACL> list, int n2, long l2) {
        CreateMode createMode = CreateMode.fromFlag(n2, CreateMode.PERSISTENT);
        if (createMode.isTTL()) {
            return new CreateTTL(string, byArray, list, createMode, l2);
        }
        return new Create(string, byArray, list, n2);
    }

    public static Op create(String string, byte[] byArray, List<ACL> list, CreateMode createMode) {
        return new Create(string, byArray, list, createMode);
    }

    public static Op create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, long l2) {
        if (createMode.isTTL()) {
            return new CreateTTL(string, byArray, list, createMode, l2);
        }
        return new Create(string, byArray, list, createMode);
    }

    static Op create(String string, byte[] byArray, CreateOptions createOptions, int n2) {
        if (createOptions.getCreateMode().isTTL()) {
            return new CreateTTL(string, byArray, createOptions.getAcl(), createOptions.getCreateMode(), createOptions.getTtl());
        }
        return new Create(string, byArray, createOptions.getAcl(), createOptions.getCreateMode(), n2);
    }

    public static Op create(String string, byte[] byArray, CreateOptions createOptions) {
        return Op.create(string, byArray, createOptions, 15);
    }

    public static Op delete(String string, int n2) {
        return new Delete(string, n2);
    }

    public static Op setData(String string, byte[] byArray, int n2) {
        return new SetData(string, byArray, n2);
    }

    public static Op check(String string, int n2) {
        return new Check(string, n2);
    }

    public static Op getChildren(String string) {
        return new GetChildren(string);
    }

    public static Op getData(String string) {
        return new GetData(string);
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public OpKind getKind() {
        return this.opKind;
    }

    public abstract mme toRequestRecord();

    abstract Op withChroot(String var1);

    void validate() throws KeeperException {
        PathUtils.validatePath(this.path);
    }

    public static class GetData
    extends Op {
        GetData(String string) {
            super(4, string, OpKind.READ);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof GetData)) {
                return false;
            }
            GetData getData = (GetData)object;
            return this.getType() == getData.getType() && this.getPath().equals(getData.getPath());
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode();
        }

        @Override
        public mme toRequestRecord() {
            return new GetDataRequest(this.getPath(), false);
        }

        @Override
        Op withChroot(String string) {
            return new GetData(string);
        }
    }

    public static class GetChildren
    extends Op {
        GetChildren(String string) {
            super(8, string, OpKind.READ);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof GetChildren)) {
                return false;
            }
            GetChildren getChildren = (GetChildren)object;
            return this.getType() == getChildren.getType() && this.getPath().equals(getChildren.getPath());
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode();
        }

        @Override
        public mme toRequestRecord() {
            return new GetChildrenRequest(this.getPath(), false);
        }

        @Override
        Op withChroot(String string) {
            return new GetChildren(string);
        }
    }

    public static class Check
    extends Op {
        private int version;

        private Check(String string, int n2) {
            super(13, string, OpKind.TRANSACTION);
            this.version = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Check)) {
                return false;
            }
            Check check = (Check)object;
            return this.getType() == check.getType() && this.getPath().equals(check.getPath()) && this.version == check.version;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public mme toRequestRecord() {
            return new CheckVersionRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String string) {
            return new Check(string, this.version);
        }
    }

    public static class SetData
    extends Op {
        private byte[] data;
        private int version;

        private SetData(String string, byte[] byArray, int n2) {
            super(5, string, OpKind.TRANSACTION);
            this.data = byArray;
            this.version = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SetData)) {
                return false;
            }
            SetData setData = (SetData)object;
            return this.getType() == setData.getType() && this.version == setData.version && this.getPath().equals(setData.getPath()) && Arrays.equals(this.data, setData.data);
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data) + this.version;
        }

        @Override
        public mme toRequestRecord() {
            return new SetDataRequest(this.getPath(), this.data, this.version);
        }

        @Override
        Op withChroot(String string) {
            return new SetData(string, this.data, this.version);
        }
    }

    public static class Delete
    extends Op {
        private int version;

        private Delete(String string, int n2) {
            super(2, string, OpKind.TRANSACTION);
            this.version = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Delete)) {
                return false;
            }
            Delete delete = (Delete)object;
            return this.getType() == delete.getType() && this.version == delete.version && this.getPath().equals(delete.getPath());
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public mme toRequestRecord() {
            return new DeleteRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String string) {
            return new Delete(string, this.version);
        }
    }

    public static class CreateTTL
    extends Create {
        private final long ttl;

        private CreateTTL(String string, byte[] byArray, List<ACL> list, int n2, long l2) {
            super(string, byArray, list, n2);
            this.ttl = l2;
        }

        private CreateTTL(String string, byte[] byArray, List<ACL> list, CreateMode createMode, long l2) {
            super(string, byArray, list, createMode);
            this.ttl = l2;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof CreateTTL && this.ttl == ((CreateTTL)object).ttl;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (int)(this.ttl ^ this.ttl >>> 32);
        }

        @Override
        public mme toRequestRecord() {
            return new CreateTTLRequest(this.getPath(), this.data, this.acl, this.flags, this.ttl);
        }

        @Override
        Op withChroot(String string) {
            return new CreateTTL(string, this.data, (List<ACL>)this.acl, this.flags, this.ttl);
        }

        @Override
        void validate() throws KeeperException {
            CreateMode createMode = CreateMode.fromFlag(this.flags);
            PathUtils.validatePath(this.getPath(), createMode.isSequential());
            EphemeralType.validateTTL(createMode, this.ttl);
        }
    }

    public static class Create
    extends Op {
        protected byte[] data;
        protected List<ACL> acl;
        protected int flags;

        private Create(String string, byte[] byArray, List<ACL> list, int n2) {
            this(string, byArray, list, n2, 1);
        }

        private Create(String string, byte[] byArray, List<ACL> list, int n2, int n3) {
            super(Create.getOpcode(CreateMode.fromFlag(n2, CreateMode.PERSISTENT), n3), string, OpKind.TRANSACTION);
            this.data = byArray;
            this.acl = list;
            this.flags = n2;
        }

        private static int getOpcode(CreateMode createMode, int n2) {
            if (createMode.isTTL()) {
                return 21;
            }
            return createMode.isContainer() ? 19 : n2;
        }

        private Create(String string, byte[] byArray, List<ACL> list, CreateMode createMode) {
            this(string, byArray, list, createMode, 1);
        }

        private Create(String string, byte[] byArray, List<ACL> list, CreateMode createMode, int n2) {
            super(Create.getOpcode(createMode, n2), string, OpKind.TRANSACTION);
            this.data = byArray;
            this.acl = list;
            this.flags = createMode.toFlag();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Create)) {
                return false;
            }
            Create create = (Create)object;
            boolean bl2 = true;
            Iterator<ACL> iterator = create.acl.iterator();
            for (ACL aCL : create.acl) {
                boolean bl3 = iterator.hasNext();
                if (!bl3) {
                    bl2 = false;
                    break;
                }
                ACL aCL2 = iterator.next();
                if (aCL.equals(aCL2)) continue;
                bl2 = false;
                break;
            }
            return !iterator.hasNext() && this.getType() == create.getType() && Arrays.equals(this.data, create.data) && this.flags == create.flags && bl2;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data);
        }

        @Override
        public mme toRequestRecord() {
            return new CreateRequest(this.getPath(), this.data, this.acl, this.flags);
        }

        @Override
        Op withChroot(String string) {
            return new Create(string, this.data, this.acl, this.flags);
        }

        @Override
        void validate() throws KeeperException {
            CreateMode createMode = CreateMode.fromFlag(this.flags);
            PathUtils.validatePath(this.getPath(), createMode.isSequential());
            EphemeralType.validateTTL(createMode, -1L);
        }
    }

    public static enum OpKind {
        TRANSACTION,
        READ;

    }
}

