/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XdepsXdatabricksX240X9088.org.apache.zookeeper.OpResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class KeeperException
extends Exception {
    private List<OpResult> results;
    private Code code;
    private String path;

    public static KeeperException create(Code code, String string) {
        KeeperException keeperException = KeeperException.create(code);
        keeperException.path = string;
        return keeperException;
    }

    public static KeeperException create(int n2, String string) {
        KeeperException keeperException = KeeperException.create(Code.get(n2));
        keeperException.path = string;
        return keeperException;
    }

    public static KeeperException create(int n2) {
        return KeeperException.create(Code.get(n2));
    }

    public static KeeperException create(Code code) {
        switch (code) {
            case SYSTEMERROR: {
                return new SystemErrorException();
            }
            case RUNTIMEINCONSISTENCY: {
                return new RuntimeInconsistencyException();
            }
            case DATAINCONSISTENCY: {
                return new DataInconsistencyException();
            }
            case CONNECTIONLOSS: {
                return new ConnectionLossException();
            }
            case MARSHALLINGERROR: {
                return new MarshallingErrorException();
            }
            case UNIMPLEMENTED: {
                return new UnimplementedException();
            }
            case OPERATIONTIMEOUT: {
                return new OperationTimeoutException();
            }
            case NEWCONFIGNOQUORUM: {
                return new NewConfigNoQuorum();
            }
            case RECONFIGINPROGRESS: {
                return new ReconfigInProgress();
            }
            case BADARGUMENTS: {
                return new BadArgumentsException();
            }
            case APIERROR: {
                return new APIErrorException();
            }
            case NONODE: {
                return new NoNodeException();
            }
            case NOAUTH: {
                return new NoAuthException();
            }
            case BADVERSION: {
                return new BadVersionException();
            }
            case NOCHILDRENFOREPHEMERALS: {
                return new NoChildrenForEphemeralsException();
            }
            case NODEEXISTS: {
                return new NodeExistsException();
            }
            case INVALIDACL: {
                return new InvalidACLException();
            }
            case AUTHFAILED: {
                return new AuthFailedException();
            }
            case NOTEMPTY: {
                return new NotEmptyException();
            }
            case SESSIONEXPIRED: {
                return new SessionExpiredException();
            }
            case INVALIDCALLBACK: {
                return new InvalidCallbackException();
            }
            case SESSIONMOVED: {
                return new SessionMovedException();
            }
            case NOTREADONLY: {
                return new NotReadOnlyException();
            }
            case EPHEMERALONLOCALSESSION: {
                return new EphemeralOnLocalSessionException();
            }
            case NOWATCHER: {
                return new NoWatcherException();
            }
            case RECONFIGDISABLED: {
                return new ReconfigDisabledException();
            }
            case SESSIONCLOSEDREQUIRESASLAUTH: {
                return new SessionClosedRequireAuthException();
            }
            case REQUESTTIMEOUT: {
                return new RequestTimeoutException();
            }
            case QUOTAEXCEEDED: {
                return new QuotaExceededException();
            }
            case THROTTLEDOP: {
                return new ThrottledOpException();
            }
        }
        throw new IllegalArgumentException("Invalid exception code:" + code.code);
    }

    public void setCode(int n2) {
        this.code = Code.get(n2);
    }

    static String getCodeMessage(Code code) {
        switch (code) {
            case OK: {
                return "ok";
            }
            case SYSTEMERROR: {
                return "SystemError";
            }
            case RUNTIMEINCONSISTENCY: {
                return "RuntimeInconsistency";
            }
            case DATAINCONSISTENCY: {
                return "DataInconsistency";
            }
            case CONNECTIONLOSS: {
                return "ConnectionLoss";
            }
            case MARSHALLINGERROR: {
                return "MarshallingError";
            }
            case NEWCONFIGNOQUORUM: {
                return "NewConfigNoQuorum";
            }
            case RECONFIGINPROGRESS: {
                return "ReconfigInProgress";
            }
            case UNIMPLEMENTED: {
                return "Unimplemented";
            }
            case OPERATIONTIMEOUT: {
                return "OperationTimeout";
            }
            case BADARGUMENTS: {
                return "BadArguments";
            }
            case APIERROR: {
                return "APIError";
            }
            case NONODE: {
                return "NoNode";
            }
            case NOAUTH: {
                return "NoAuth";
            }
            case BADVERSION: {
                return "BadVersion";
            }
            case NOCHILDRENFOREPHEMERALS: {
                return "NoChildrenForEphemerals";
            }
            case NODEEXISTS: {
                return "NodeExists";
            }
            case INVALIDACL: {
                return "InvalidACL";
            }
            case AUTHFAILED: {
                return "AuthFailed";
            }
            case NOTEMPTY: {
                return "Directory not empty";
            }
            case SESSIONEXPIRED: {
                return "Session expired";
            }
            case INVALIDCALLBACK: {
                return "Invalid callback";
            }
            case SESSIONMOVED: {
                return "Session moved";
            }
            case NOTREADONLY: {
                return "Not a read-only call";
            }
            case EPHEMERALONLOCALSESSION: {
                return "Ephemeral node on local session";
            }
            case NOWATCHER: {
                return "No such watcher";
            }
            case RECONFIGDISABLED: {
                return "Reconfig is disabled";
            }
            case SESSIONCLOSEDREQUIRESASLAUTH: {
                return "Session closed because client failed to authenticate";
            }
            case QUOTAEXCEEDED: {
                return "Quota has exceeded";
            }
            case THROTTLEDOP: {
                return "Op throttled due to high load";
            }
        }
        return "Unknown error " + code;
    }

    public KeeperException(Code code) {
        this.code = code;
    }

    KeeperException(Code code, String string) {
        this.code = code;
        this.path = string;
    }

    public int getCode() {
        return this.code.code;
    }

    public Code code() {
        return this.code;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getMessage() {
        if (this.path == null || this.path.isEmpty()) {
            return "KeeperErrorCode = " + KeeperException.getCodeMessage(this.code);
        }
        return "KeeperErrorCode = " + KeeperException.getCodeMessage(this.code) + " for " + this.path;
    }

    void setMultiResults(List<OpResult> list) {
        this.results = list;
    }

    public List<OpResult> getResults() {
        return this.results != null ? new ArrayList<OpResult>(this.results) : null;
    }

    public static class ThrottledOpException
    extends KeeperException {
        public ThrottledOpException() {
            super(Code.THROTTLEDOP);
        }
    }

    public static class QuotaExceededException
    extends KeeperException {
        public QuotaExceededException() {
            super(Code.QUOTAEXCEEDED);
        }

        public QuotaExceededException(String string) {
            super(Code.QUOTAEXCEEDED, string);
        }
    }

    public static class RequestTimeoutException
    extends KeeperException {
        public RequestTimeoutException() {
            super(Code.REQUESTTIMEOUT);
        }
    }

    public static class SessionClosedRequireAuthException
    extends KeeperException {
        public SessionClosedRequireAuthException() {
            super(Code.SESSIONCLOSEDREQUIRESASLAUTH);
        }

        public SessionClosedRequireAuthException(String string) {
            super(Code.SESSIONCLOSEDREQUIRESASLAUTH, string);
        }
    }

    public static class ReconfigDisabledException
    extends KeeperException {
        public ReconfigDisabledException() {
            super(Code.RECONFIGDISABLED);
        }

        public ReconfigDisabledException(String string) {
            super(Code.RECONFIGDISABLED, string);
        }
    }

    public static class NoWatcherException
    extends KeeperException {
        public NoWatcherException() {
            super(Code.NOWATCHER);
        }

        public NoWatcherException(String string) {
            super(Code.NOWATCHER, string);
        }
    }

    public static class UnimplementedException
    extends KeeperException {
        public UnimplementedException() {
            super(Code.UNIMPLEMENTED);
        }
    }

    public static class SystemErrorException
    extends KeeperException {
        public SystemErrorException() {
            super(Code.SYSTEMERROR);
        }
    }

    public static class EphemeralOnLocalSessionException
    extends KeeperException {
        public EphemeralOnLocalSessionException() {
            super(Code.EPHEMERALONLOCALSESSION);
        }
    }

    public static class NotReadOnlyException
    extends KeeperException {
        public NotReadOnlyException() {
            super(Code.NOTREADONLY);
        }
    }

    public static class SessionMovedException
    extends KeeperException {
        public SessionMovedException() {
            super(Code.SESSIONMOVED);
        }
    }

    public static class UnknownSessionException
    extends KeeperException {
        public UnknownSessionException() {
            super(Code.UNKNOWNSESSION);
        }
    }

    public static class SessionExpiredException
    extends KeeperException {
        public SessionExpiredException() {
            super(Code.SESSIONEXPIRED);
        }
    }

    public static class RuntimeInconsistencyException
    extends KeeperException {
        public RuntimeInconsistencyException() {
            super(Code.RUNTIMEINCONSISTENCY);
        }
    }

    public static class OperationTimeoutException
    extends KeeperException {
        public OperationTimeoutException() {
            super(Code.OPERATIONTIMEOUT);
        }
    }

    public static class NotEmptyException
    extends KeeperException {
        public NotEmptyException() {
            super(Code.NOTEMPTY);
        }

        public NotEmptyException(String string) {
            super(Code.NOTEMPTY, string);
        }
    }

    public static class NoNodeException
    extends KeeperException {
        public NoNodeException() {
            super(Code.NONODE);
        }

        public NoNodeException(String string) {
            super(Code.NONODE, string);
        }
    }

    public static class NodeExistsException
    extends KeeperException {
        public NodeExistsException() {
            super(Code.NODEEXISTS);
        }

        public NodeExistsException(String string) {
            super(Code.NODEEXISTS, string);
        }
    }

    public static class NoChildrenForEphemeralsException
    extends KeeperException {
        public NoChildrenForEphemeralsException() {
            super(Code.NOCHILDRENFOREPHEMERALS);
        }

        public NoChildrenForEphemeralsException(String string) {
            super(Code.NOCHILDRENFOREPHEMERALS, string);
        }
    }

    public static class ReconfigInProgress
    extends KeeperException {
        public ReconfigInProgress() {
            super(Code.RECONFIGINPROGRESS);
        }
    }

    public static class NewConfigNoQuorum
    extends KeeperException {
        public NewConfigNoQuorum() {
            super(Code.NEWCONFIGNOQUORUM);
        }
    }

    public static class NoAuthException
    extends KeeperException {
        public NoAuthException() {
            super(Code.NOAUTH);
        }
    }

    public static class MarshallingErrorException
    extends KeeperException {
        public MarshallingErrorException() {
            super(Code.MARSHALLINGERROR);
        }
    }

    public static class InvalidCallbackException
    extends KeeperException {
        public InvalidCallbackException() {
            super(Code.INVALIDCALLBACK);
        }
    }

    public static class InvalidACLException
    extends KeeperException {
        public InvalidACLException() {
            super(Code.INVALIDACL);
        }

        public InvalidACLException(String string) {
            super(Code.INVALIDACL, string);
        }
    }

    public static class DataInconsistencyException
    extends KeeperException {
        public DataInconsistencyException() {
            super(Code.DATAINCONSISTENCY);
        }
    }

    public static class ConnectionLossException
    extends KeeperException {
        public ConnectionLossException() {
            super(Code.CONNECTIONLOSS);
        }
    }

    public static class BadVersionException
    extends KeeperException {
        public BadVersionException() {
            super(Code.BADVERSION);
        }

        public BadVersionException(String string) {
            super(Code.BADVERSION, string);
        }
    }

    public static class BadArgumentsException
    extends KeeperException {
        public BadArgumentsException() {
            super(Code.BADARGUMENTS);
        }

        public BadArgumentsException(String string) {
            super(Code.BADARGUMENTS, string);
        }
    }

    public static class AuthFailedException
    extends KeeperException {
        public AuthFailedException() {
            super(Code.AUTHFAILED);
        }
    }

    public static class APIErrorException
    extends KeeperException {
        public APIErrorException() {
            super(Code.APIERROR);
        }
    }

    public static enum Code implements CodeDeprecated
    {
        OK(0),
        SYSTEMERROR(-1),
        RUNTIMEINCONSISTENCY(-2),
        DATAINCONSISTENCY(-3),
        CONNECTIONLOSS(-4),
        MARSHALLINGERROR(-5),
        UNIMPLEMENTED(-6),
        OPERATIONTIMEOUT(-7),
        BADARGUMENTS(-8),
        NEWCONFIGNOQUORUM(-13),
        RECONFIGINPROGRESS(-14),
        UNKNOWNSESSION(-12),
        APIERROR(-100),
        NONODE(-101),
        NOAUTH(-102),
        BADVERSION(-103),
        NOCHILDRENFOREPHEMERALS(-108),
        NODEEXISTS(-110),
        NOTEMPTY(-111),
        SESSIONEXPIRED(-112),
        INVALIDCALLBACK(-113),
        INVALIDACL(-114),
        AUTHFAILED(-115),
        SESSIONMOVED(-118),
        NOTREADONLY(-119),
        EPHEMERALONLOCALSESSION(-120),
        NOWATCHER(-121),
        REQUESTTIMEOUT(-122),
        RECONFIGDISABLED(-123),
        SESSIONCLOSEDREQUIRESASLAUTH(-124),
        QUOTAEXCEEDED(-125),
        THROTTLEDOP(-127);

        private static final Map<Integer, Code> lookup;
        private final int code;

        private Code(int n3) {
            this.code = n3;
        }

        public int intValue() {
            return this.code;
        }

        public static Code get(int n2) {
            Code code = lookup.get(n2);
            if (code == null) {
                throw new IllegalArgumentException("The current client version cannot lookup this code:" + n2);
            }
            return code;
        }

        static {
            lookup = new HashMap<Integer, Code>();
            for (Code code : EnumSet.allOf(Code.class)) {
                lookup.put(code.code, code);
            }
        }
    }

    public static interface CodeDeprecated {
        public static final int Ok = 0;
        public static final int SystemError = -1;
        public static final int RuntimeInconsistency = -2;
        public static final int DataInconsistency = -3;
        public static final int ConnectionLoss = -4;
        public static final int MarshallingError = -5;
        public static final int Unimplemented = -6;
        public static final int OperationTimeout = -7;
        public static final int BadArguments = -8;
        public static final int UnknownSession = -12;
        public static final int NewConfigNoQuorum = -13;
        public static final int ReconfigInProgress = -14;
        public static final int APIError = -100;
        public static final int NoNode = -101;
        public static final int NoAuth = -102;
        public static final int BadVersion = -103;
        public static final int NoChildrenForEphemerals = -108;
        public static final int NodeExists = -110;
        public static final int NotEmpty = -111;
        public static final int SessionExpired = -112;
        public static final int InvalidCallback = -113;
        public static final int InvalidACL = -114;
        public static final int AuthFailed = -115;
        public static final int EphemeralOnLocalSession = -120;
    }
}

