/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxn;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.compat.ProtocolManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ConnectResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;

abstract class ClientCnxnSocket {
    private static final foe LOG = goe.a(ClientCnxnSocket.class);
    private final ProtocolManager protocolManager = new ProtocolManager();
    protected boolean initialized;
    protected final ByteBuffer lenBuffer;
    protected ByteBuffer incomingBuffer = this.lenBuffer = ByteBuffer.allocateDirect(4);
    protected final AtomicLong sentCount = new AtomicLong(0L);
    protected final AtomicLong recvCount = new AtomicLong(0L);
    protected long lastHeard;
    protected long lastSend;
    protected long now;
    protected ClientCnxn.SendThread sendThread;
    protected LinkedBlockingDeque<ClientCnxn.Packet> outgoingQueue;
    protected ZKClientConfig clientConfig;
    private int packetLen = 1048575;
    protected long sessionId;

    ClientCnxnSocket() {
    }

    void introduce(ClientCnxn.SendThread sendThread, long l2, LinkedBlockingDeque<ClientCnxn.Packet> linkedBlockingDeque) {
        this.sendThread = sendThread;
        this.sessionId = l2;
        this.outgoingQueue = linkedBlockingDeque;
    }

    void updateNow() {
        this.now = Time.currentElapsedTime();
    }

    int getIdleRecv() {
        return (int)(this.now - this.lastHeard);
    }

    int getIdleSend() {
        return (int)(this.now - this.lastSend);
    }

    long getSentCount() {
        return this.sentCount.get();
    }

    long getRecvCount() {
        return this.recvCount.get();
    }

    void updateLastHeard() {
        this.lastHeard = this.now;
    }

    void updateLastSend() {
        this.lastSend = this.now;
    }

    void updateLastSendAndHeard() {
        this.lastSend = this.now;
        this.lastHeard = this.now;
    }

    void readLength() throws IOException {
        int n2 = this.incomingBuffer.getInt();
        if (n2 < 0 || n2 > this.packetLen) {
            throw new IOException("Packet len " + n2 + " is out of range!");
        }
        this.incomingBuffer = ByteBuffer.allocate(n2);
    }

    void readConnectResult() throws IOException {
        Object object;
        if (LOG.b()) {
            object = new StringBuilder("0x[");
            for (byte by2 : this.incomingBuffer.array()) {
                ((StringBuilder)object).append(Integer.toHexString(by2)).append(",");
            }
            ((StringBuilder)object).append("]");
            if (LOG.b()) {
                LOG.a("readConnectResult {} {}", (Object)this.incomingBuffer.remaining(), object);
            }
        }
        object = new ByteBufferInputStream(this.incomingBuffer);
        hme hme2 = hme.a((InputStream)object);
        ConnectResponse connectResponse = this.protocolManager.deserializeConnectResponse(hme2);
        if (!this.protocolManager.isReadonlyAvailable()) {
            LOG.d("Connected to an old server; r-o mode will be unavailable");
        }
        this.sessionId = connectResponse.getSessionId();
        this.sendThread.onConnected(connectResponse.getTimeOut(), this.sessionId, connectResponse.getPasswd(), connectResponse.getReadOnly());
    }

    abstract boolean isConnected();

    abstract void connect(InetSocketAddress var1) throws IOException;

    abstract SocketAddress getRemoteSocketAddress();

    abstract SocketAddress getLocalSocketAddress();

    abstract void cleanup();

    abstract void packetAdded();

    abstract void onClosing();

    abstract void saslCompleted();

    abstract void connectionPrimed();

    abstract void doTransport(int var1, Queue<ClientCnxn.Packet> var2, ClientCnxn var3) throws IOException, InterruptedException;

    abstract void testableCloseSocket() throws IOException;

    abstract void close();

    abstract void sendPacket(ClientCnxn.Packet var1) throws IOException;

    protected void initProperties() throws IOException {
        try {
            this.packetLen = this.clientConfig.getInt("jute.maxbuffer", 1048575);
            LOG.c("{} value is {} Bytes", (Object)"jute.maxbuffer", (Object)this.packetLen);
        }
        catch (NumberFormatException numberFormatException) {
            String string = MessageFormat.format("Configured value {0} for property {1} can not be parsed to int", this.clientConfig.getProperty("jute.maxbuffer"), "jute.maxbuffer");
            LOG.e(string);
            throw new IOException(string);
        }
    }
}

