/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.org.apache.zookeeper;

import XcoreXdatabricksX240X9088.foe;
import XcoreXdatabricksX240X9088.goe;
import XcoreXdatabricksX240X9088.hme;
import XcoreXdatabricksX240X9088.hoe;
import XcoreXdatabricksX240X9088.ime;
import XcoreXdatabricksX240X9088.mme;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.AsyncCallback;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ClientCnxnSocket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.KeeperException;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Login;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.MultiResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.OpResult;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.SaslServerPrincipal;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchDeregistration;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.WatchedEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.Watcher;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZKWatchManager;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.ZooKeeper;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.HostProvider;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZKClientConfig;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.client.ZooKeeperSaslClient;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.common.Time;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.AuthPacket;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ConnectRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.Create2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.CreateResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ExistsResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetAllChildrenNumberResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildren2Response;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetChildrenResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetEphemeralsResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.GetSASLRequest;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.ReplyHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.RequestHeader;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetACLResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetDataResponse;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetWatches;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.SetWatches2;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.proto.WatcherEvent;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ByteBufferInputStream;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooKeeperThread;
import XdepsXdatabricksX240X9088.org.apache.zookeeper.server.ZooTrace;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;

public class ClientCnxn {
    private static final foe LOG = goe.a(ClientCnxn.class);
    private static final int SET_WATCHES_MAX_LENGTH = 131072;
    public static final int NOTIFICATION_XID = -1;
    public static final int PING_XID = -2;
    public static final int AUTHPACKET_XID = -4;
    public static final int SET_WATCHES_XID = -8;
    private final CopyOnWriteArraySet<AuthData> authInfo = new CopyOnWriteArraySet();
    private final Queue<Packet> pendingQueue = new ArrayDeque<Packet>();
    private final LinkedBlockingDeque<Packet> outgoingQueue = new LinkedBlockingDeque();
    private int connectTimeout;
    private volatile int negotiatedSessionTimeout;
    private int readTimeout;
    private final int sessionTimeout;
    private final ZKWatchManager watchManager;
    private long sessionId;
    private byte[] sessionPasswd;
    private boolean readOnly;
    final String chrootPath;
    final SendThread sendThread;
    final EventThread eventThread;
    private volatile boolean closing = false;
    private final HostProvider hostProvider;
    volatile boolean seenRwServerBefore = false;
    private final ZKClientConfig clientConfig;
    private long requestTimeout;
    private Object eventOfDeath = new Object();
    private volatile long lastZxid;
    protected int xid = 1;
    volatile ZooKeeper.States state = ZooKeeper.States.NOT_CONNECTED;

    ZKWatchManager getWatcherManager() {
        return this.watchManager;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionPasswd() {
        return this.sessionPasswd;
    }

    public int getSessionTimeout() {
        return this.negotiatedSessionTimeout;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SocketAddress socketAddress = this.sendThread.getClientCnxnSocket().getLocalSocketAddress();
        SocketAddress socketAddress2 = this.sendThread.getClientCnxnSocket().getRemoteSocketAddress();
        stringBuilder.append("sessionid:0x").append(Long.toHexString(this.getSessionId())).append(" local:").append(socketAddress).append(" remoteserver:").append(socketAddress2).append(" lastZxid:").append(this.lastZxid).append(" xid:").append(this.xid).append(" sent:").append(this.sendThread.getClientCnxnSocket().getSentCount()).append(" recv:").append(this.sendThread.getClientCnxnSocket().getRecvCount()).append(" queuedpkts:").append(this.outgoingQueue.size()).append(" pendingresp:").append(this.pendingQueue.size()).append(" queuedevents:").append(this.eventThread.waitingEvents.size());
        return stringBuilder.toString();
    }

    public ClientCnxn(String string, HostProvider hostProvider, int n2, ZKClientConfig zKClientConfig, Watcher watcher, ClientCnxnSocket clientCnxnSocket, boolean bl2) throws IOException {
        this(string, hostProvider, n2, zKClientConfig, watcher, clientCnxnSocket, 0L, new byte[16], bl2);
    }

    public ClientCnxn(String string, HostProvider hostProvider, int n2, ZKClientConfig zKClientConfig, Watcher watcher, ClientCnxnSocket clientCnxnSocket, long l2, byte[] byArray, boolean bl2) throws IOException {
        this.chrootPath = string;
        this.hostProvider = hostProvider;
        this.sessionTimeout = n2;
        this.clientConfig = zKClientConfig;
        this.sessionId = l2;
        this.sessionPasswd = byArray;
        this.readOnly = bl2;
        this.watchManager = new ZKWatchManager(zKClientConfig.getBoolean("zookeeper.disableAutoWatchReset"), watcher);
        this.connectTimeout = n2 / hostProvider.size();
        this.readTimeout = n2 * 2 / 3;
        this.sendThread = new SendThread(clientCnxnSocket);
        this.eventThread = new EventThread();
        this.initRequestTimeout();
    }

    public void start() {
        this.sendThread.start();
        this.eventThread.start();
    }

    private static String makeThreadName(String string) {
        String string2 = Thread.currentThread().getName().replaceAll("-EventThread", "");
        return string2 + string;
    }

    public static boolean isInEventThread() {
        return Thread.currentThread() instanceof EventThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishPacket(Packet packet) {
        Object object;
        int n2 = packet.replyHeader.getErr();
        if (packet.watchRegistration != null) {
            packet.watchRegistration.register(n2);
        }
        if (packet.watchDeregistration != null) {
            object = null;
            try {
                object = packet.watchDeregistration.unregister(n2);
                for (Map.Entry entry : object.entrySet()) {
                    Set set = (Set)entry.getValue();
                    if (set.size() <= 0) continue;
                    this.queueEvent(packet.watchDeregistration.getClientPath(), n2, set, (Watcher.Event.EventType)((Object)entry.getKey()));
                    packet.replyHeader.setErr(KeeperException.Code.OK.intValue());
                }
            }
            catch (KeeperException.NoWatcherException noWatcherException) {
                packet.replyHeader.setErr(noWatcherException.code().intValue());
            }
            catch (KeeperException keeperException) {
                packet.replyHeader.setErr(keeperException.code().intValue());
            }
        }
        if (packet.cb == null) {
            object = packet;
            synchronized (object) {
                packet.finished = true;
                packet.notifyAll();
            }
        } else {
            packet.finished = true;
            this.eventThread.queuePacket(packet);
        }
    }

    void queueEvent(String string, int n2, Set<Watcher> set, Watcher.Event.EventType eventType) {
        Watcher.Event.KeeperState keeperState = Watcher.Event.KeeperState.SyncConnected;
        if (KeeperException.Code.SESSIONEXPIRED.intValue() == n2 || KeeperException.Code.CONNECTIONLOSS.intValue() == n2) {
            keeperState = Watcher.Event.KeeperState.Disconnected;
        }
        WatchedEvent watchedEvent = new WatchedEvent(eventType, keeperState, string);
        this.eventThread.queueEvent(watchedEvent, set);
    }

    void queueCallback(AsyncCallback asyncCallback, int n2, String string, Object object) {
        this.eventThread.queueCallback(asyncCallback, n2, string, object);
    }

    protected void onConnecting(InetSocketAddress inetSocketAddress) {
    }

    private void conLossPacket(Packet packet) {
        if (packet.replyHeader == null) {
            return;
        }
        switch (this.state) {
            case AUTH_FAILED: {
                packet.replyHeader.setErr(KeeperException.Code.AUTHFAILED.intValue());
                break;
            }
            case CLOSED: {
                packet.replyHeader.setErr(KeeperException.Code.SESSIONEXPIRED.intValue());
                break;
            }
            default: {
                packet.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
            }
        }
        this.finishPacket(packet);
    }

    public long getLastZxid() {
        return this.lastZxid;
    }

    public void disconnect() {
        LOG.b("Disconnecting client for session: 0x{}", (Object)Long.toHexString(this.getSessionId()));
        this.sendThread.close();
        try {
            this.sendThread.join();
        }
        catch (InterruptedException interruptedException) {
            LOG.c("Got interrupted while waiting for the sender thread to close", interruptedException);
        }
        this.eventThread.queueEventOfDeath();
    }

    public void close() throws IOException {
        LOG.b("Closing client for session: 0x{}", (Object)Long.toHexString(this.getSessionId()));
        try {
            RequestHeader requestHeader = new RequestHeader();
            requestHeader.setType(-11);
            this.submitRequest(requestHeader, null, null, null);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.disconnect();
        }
    }

    public synchronized int getXid() {
        if (this.xid == Integer.MAX_VALUE) {
            this.xid = 1;
        }
        return this.xid++;
    }

    public ReplyHeader submitRequest(RequestHeader requestHeader, mme mme2, mme mme3, ZooKeeper.WatchRegistration watchRegistration) throws InterruptedException {
        return this.submitRequest(requestHeader, mme2, mme3, watchRegistration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyHeader submitRequest(RequestHeader requestHeader, mme mme2, mme mme3, ZooKeeper.WatchRegistration watchRegistration, WatchDeregistration watchDeregistration) throws InterruptedException {
        Packet packet;
        ReplyHeader replyHeader = new ReplyHeader();
        Packet packet2 = packet = this.queuePacket(requestHeader, replyHeader, mme2, mme3, null, null, null, null, watchRegistration, watchDeregistration);
        synchronized (packet2) {
            if (this.requestTimeout > 0L) {
                this.waitForPacketFinish(replyHeader, packet);
            } else {
                while (!packet.finished) {
                    packet.wait();
                }
            }
        }
        if (replyHeader.getErr() == KeeperException.Code.REQUESTTIMEOUT.intValue()) {
            this.sendThread.cleanAndNotifyState();
        }
        return replyHeader;
    }

    private void waitForPacketFinish(ReplyHeader replyHeader, Packet packet) throws InterruptedException {
        long l2 = Time.currentElapsedTime();
        while (!packet.finished) {
            packet.wait(this.requestTimeout);
            if (packet.finished || Time.currentElapsedTime() - l2 < this.requestTimeout) continue;
            LOG.e("Timeout error occurred for the packet '{}'.", (Object)packet);
            replyHeader.setErr(KeeperException.Code.REQUESTTIMEOUT.intValue());
            break;
        }
    }

    public void saslCompleted() {
        this.sendThread.getClientCnxnSocket().saslCompleted();
    }

    public void sendPacket(mme mme2, mme mme3, AsyncCallback asyncCallback, int n2) throws IOException {
        int n3 = this.getXid();
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setXid(n3);
        requestHeader.setType(n2);
        ReplyHeader replyHeader = new ReplyHeader();
        replyHeader.setXid(n3);
        Packet packet = new Packet(requestHeader, replyHeader, mme2, mme3, null);
        packet.cb = asyncCallback;
        this.sendThread.sendPacket(packet);
    }

    public Packet queuePacket(RequestHeader requestHeader, ReplyHeader replyHeader, mme mme2, mme mme3, AsyncCallback asyncCallback, String string, String string2, Object object, ZooKeeper.WatchRegistration watchRegistration) {
        return this.queuePacket(requestHeader, replyHeader, mme2, mme3, asyncCallback, string, string2, object, watchRegistration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet queuePacket(RequestHeader requestHeader, ReplyHeader replyHeader, mme mme2, mme mme3, AsyncCallback asyncCallback, String string, String string2, Object object, ZooKeeper.WatchRegistration watchRegistration, WatchDeregistration watchDeregistration) {
        Packet packet = null;
        packet = new Packet(requestHeader, replyHeader, mme2, mme3, watchRegistration);
        packet.cb = asyncCallback;
        packet.ctx = object;
        packet.clientPath = string;
        packet.serverPath = string2;
        packet.watchDeregistration = watchDeregistration;
        LinkedBlockingDeque<Packet> linkedBlockingDeque = this.outgoingQueue;
        synchronized (linkedBlockingDeque) {
            if (!this.state.isAlive() || this.closing) {
                this.conLossPacket(packet);
            } else {
                if (requestHeader.getType() == -11) {
                    this.closing = true;
                }
                this.outgoingQueue.add(packet);
            }
        }
        this.sendThread.getClientCnxnSocket().packetAdded();
        return packet;
    }

    public void addAuthInfo(String string, byte[] byArray) {
        if (!this.state.isAlive()) {
            return;
        }
        this.authInfo.add(new AuthData(string, byArray));
        this.queuePacket(new RequestHeader(-4, 100), null, new AuthPacket(0, string, byArray), null, null, null, null, null, null);
    }

    ZooKeeper.States getState() {
        return this.state;
    }

    private void initRequestTimeout() {
        try {
            this.requestTimeout = this.clientConfig.getLong("zookeeper.request.timeout", 0L);
            LOG.c("{} value is {}. feature enabled={}", "zookeeper.request.timeout", this.requestTimeout, this.requestTimeout > 0L);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.e("Configured value {} for property {} can not be parsed to long.", (Object)this.clientConfig.getProperty("zookeeper.request.timeout"), (Object)"zookeeper.request.timeout");
            throw numberFormatException;
        }
    }

    public ZooKeeperSaslClient getZooKeeperSaslClient() {
        return this.sendThread.getZooKeeperSaslClient();
    }

    static /* synthetic */ byte[] access$1602(ClientCnxn clientCnxn, byte[] byArray) {
        clientCnxn.sessionPasswd = byArray;
        return byArray;
    }

    static class LocalCallback {
        private final AsyncCallback cb;
        private final int rc;
        private final String path;
        private final Object ctx;

        public LocalCallback(AsyncCallback asyncCallback, int n2, String string, Object object) {
            this.cb = asyncCallback;
            this.rc = n2;
            this.path = string;
            this.ctx = object;
        }
    }

    class SendThread
    extends ZooKeeperThread {
        private long lastPingSentNs;
        private final ClientCnxnSocket clientCnxnSocket;
        private boolean isFirstConnect;
        private volatile ZooKeeperSaslClient zooKeeperSaslClient;
        private final AtomicReference<Login> loginRef;
        private InetSocketAddress rwServerAddress;
        private static final int minPingRwTimeout = 100;
        private static final int maxPingRwTimeout = 60000;
        private int pingRwTimeout;
        private boolean saslLoginFailed;

        private String stripChroot(String string) {
            if (string.startsWith(ClientCnxn.this.chrootPath)) {
                if (string.length() == ClientCnxn.this.chrootPath.length()) {
                    return "/";
                }
                return string.substring(ClientCnxn.this.chrootPath.length());
            }
            if (string.startsWith("/zookeeper/")) {
                return string;
            }
            LOG.d("Got server path {} which is not descendant of chroot path {}.", (Object)string, (Object)ClientCnxn.this.chrootPath);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readResponse(ByteBuffer byteBuffer) throws IOException {
            Packet packet;
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(byteBuffer);
            hme hme2 = hme.a(byteBufferInputStream);
            ReplyHeader replyHeader = new ReplyHeader();
            replyHeader.deserialize(hme2, "header");
            switch (replyHeader.getXid()) {
                case -2: {
                    LOG.b("Got ping response for session id: 0x{} after {}ms.", (Object)Long.toHexString(ClientCnxn.this.sessionId), (Object)((System.nanoTime() - this.lastPingSentNs) / 1000000L));
                    return;
                }
                case -4: {
                    LOG.b("Got auth session id: 0x{}", (Object)Long.toHexString(ClientCnxn.this.sessionId));
                    if (replyHeader.getErr() == KeeperException.Code.AUTHFAILED.intValue()) {
                        this.changeZkState(ZooKeeper.States.AUTH_FAILED);
                        ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
                        ClientCnxn.this.eventThread.queueEventOfDeath();
                    }
                    return;
                }
                case -1: {
                    Object object;
                    LOG.b("Got notification session id: 0x{}", (Object)Long.toHexString(ClientCnxn.this.sessionId));
                    WatcherEvent watcherEvent = new WatcherEvent();
                    watcherEvent.deserialize(hme2, "response");
                    if (ClientCnxn.this.chrootPath != null) {
                        object = watcherEvent.getPath();
                        String string = this.stripChroot((String)object);
                        watcherEvent.setPath(string);
                    }
                    object = new WatchedEvent(watcherEvent, replyHeader.getZxid());
                    LOG.b("Got {} for session id 0x{}", object, (Object)Long.toHexString(ClientCnxn.this.sessionId));
                    ClientCnxn.this.eventThread.queueEvent((WatchedEvent)object);
                    return;
                }
            }
            if (this.tunnelAuthInProgress()) {
                GetSASLRequest getSASLRequest = new GetSASLRequest();
                getSASLRequest.deserialize(hme2, "token");
                this.zooKeeperSaslClient.respondToServer(getSASLRequest.getToken(), ClientCnxn.this);
                return;
            }
            Queue queue = ClientCnxn.this.pendingQueue;
            synchronized (queue) {
                if (ClientCnxn.this.pendingQueue.size() == 0) {
                    throw new IOException("Nothing in the queue, but got " + replyHeader.getXid());
                }
                packet = (Packet)ClientCnxn.this.pendingQueue.remove();
            }
            try {
                if (packet.requestHeader.getXid() != replyHeader.getXid()) {
                    packet.replyHeader.setErr(KeeperException.Code.CONNECTIONLOSS.intValue());
                    throw new IOException("Xid out of order. Got Xid " + replyHeader.getXid() + " with err " + replyHeader.getErr() + " expected Xid " + packet.requestHeader.getXid() + " for a packet with details: " + packet);
                }
                packet.replyHeader.setXid(replyHeader.getXid());
                packet.replyHeader.setErr(replyHeader.getErr());
                packet.replyHeader.setZxid(replyHeader.getZxid());
                if (replyHeader.getZxid() > 0L) {
                    ClientCnxn.this.lastZxid = replyHeader.getZxid();
                }
                if (packet.response != null && replyHeader.getErr() == 0) {
                    packet.response.deserialize(hme2, "response");
                }
                LOG.b("Reading reply session id: 0x{}, packet:: {}", (Object)Long.toHexString(ClientCnxn.this.sessionId), (Object)packet);
            }
            finally {
                ClientCnxn.this.finishPacket(packet);
            }
        }

        SendThread(ClientCnxnSocket clientCnxnSocket) throws IOException {
            super(ClientCnxn.makeThreadName("-SendThread()"));
            this.isFirstConnect = true;
            this.loginRef = new AtomicReference();
            this.rwServerAddress = null;
            this.pingRwTimeout = 100;
            this.saslLoginFailed = false;
            this.changeZkState(ZooKeeper.States.CONNECTING);
            this.clientCnxnSocket = clientCnxnSocket;
            this.setDaemon(true);
        }

        synchronized ZooKeeper.States getZkState() {
            return ClientCnxn.this.state;
        }

        synchronized void changeZkState(ZooKeeper.States states) throws IOException {
            if (!ClientCnxn.this.state.isAlive() && states == ZooKeeper.States.CONNECTING) {
                throw new IOException("Connection has already been closed and reconnection is not allowed");
            }
            ClientCnxn.this.state = states;
        }

        ClientCnxnSocket getClientCnxnSocket() {
            return this.clientCnxnSocket;
        }

        void primeConnection() throws IOException {
            LOG.c("Socket connection established, initiating session, client: {}, server: {}", (Object)this.clientCnxnSocket.getLocalSocketAddress(), (Object)this.clientCnxnSocket.getRemoteSocketAddress());
            this.isFirstConnect = false;
            long l2 = ClientCnxn.this.seenRwServerBefore ? ClientCnxn.this.sessionId : 0L;
            ConnectRequest connectRequest = new ConnectRequest(0, ClientCnxn.this.lastZxid, ClientCnxn.this.sessionTimeout, l2, ClientCnxn.this.sessionPasswd, ClientCnxn.this.readOnly);
            if (!ClientCnxn.this.clientConfig.getBoolean("zookeeper.disableAutoWatchReset")) {
                List<String> list = ClientCnxn.this.watchManager.getDataWatchList();
                Object object = ClientCnxn.this.watchManager.getExistWatchList();
                List<String> list2 = ClientCnxn.this.watchManager.getChildWatchList();
                List<String> list3 = ClientCnxn.this.watchManager.getPersistentWatchList();
                List<String> list4 = ClientCnxn.this.watchManager.getPersistentRecursiveWatchList();
                if (!(list.isEmpty() && object.isEmpty() && list2.isEmpty() && list3.isEmpty() && list4.isEmpty())) {
                    Iterator<String> iterator = this.prependChroot(list).iterator();
                    Iterator<String> iterator2 = this.prependChroot((List<String>)object).iterator();
                    Iterator<String> iterator3 = this.prependChroot(list2).iterator();
                    Iterator<String> iterator4 = this.prependChroot(list3).iterator();
                    Iterator<String> iterator5 = this.prependChroot(list4).iterator();
                    long l3 = ClientCnxn.this.lastZxid;
                    while (iterator.hasNext() || iterator2.hasNext() || iterator3.hasNext() || iterator4.hasNext() || iterator5.hasNext()) {
                        int n2;
                        Object object2;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        ArrayList<String> arrayList4 = new ArrayList<String>();
                        ArrayList<String> arrayList5 = new ArrayList<String>();
                        for (int i2 = 0; i2 < 131072; i2 += ((String)object2).length()) {
                            if (iterator.hasNext()) {
                                object2 = iterator.next();
                                arrayList.add((String)object2);
                                continue;
                            }
                            if (iterator2.hasNext()) {
                                object2 = iterator2.next();
                                arrayList2.add((String)object2);
                                continue;
                            }
                            if (iterator3.hasNext()) {
                                object2 = iterator3.next();
                                arrayList3.add((String)object2);
                                continue;
                            }
                            if (iterator4.hasNext()) {
                                object2 = iterator4.next();
                                arrayList4.add((String)object2);
                                continue;
                            }
                            if (!iterator5.hasNext()) break;
                            object2 = iterator5.next();
                            arrayList5.add((String)object2);
                        }
                        if (arrayList4.isEmpty() && arrayList5.isEmpty()) {
                            object2 = new SetWatches(l3, arrayList, arrayList2, arrayList3);
                            n2 = 101;
                        } else {
                            object2 = new SetWatches2(l3, arrayList, arrayList2, arrayList3, arrayList4, arrayList5);
                            n2 = 105;
                        }
                        RequestHeader requestHeader = new RequestHeader(-8, n2);
                        Packet packet = new Packet(requestHeader, new ReplyHeader(), (mme)object2, null, null);
                        ClientCnxn.this.outgoingQueue.addFirst(packet);
                    }
                }
            }
            for (Object object : ClientCnxn.this.authInfo) {
                ClientCnxn.this.outgoingQueue.addFirst(new Packet(new RequestHeader(-4, 100), null, new AuthPacket(0, ((AuthData)object).scheme, ((AuthData)object).data), null, null));
            }
            ClientCnxn.this.outgoingQueue.addFirst(new Packet(null, null, connectRequest, null, null));
            this.clientCnxnSocket.connectionPrimed();
            LOG.b("Session establishment request sent on {}", (Object)this.clientCnxnSocket.getRemoteSocketAddress());
        }

        private List<String> prependChroot(List<String> list) {
            if (ClientCnxn.this.chrootPath != null && !list.isEmpty()) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string = list.get(i2);
                    String string2 = string.length() == 1 ? ClientCnxn.this.chrootPath : ClientCnxn.this.chrootPath + string;
                    list.set(i2, string2);
                }
            }
            return list;
        }

        private void sendPing() {
            this.lastPingSentNs = System.nanoTime();
            RequestHeader requestHeader = new RequestHeader(-2, 11);
            ClientCnxn.this.queuePacket(requestHeader, null, null, null, null, null, null, null, null);
        }

        private void startConnect(InetSocketAddress inetSocketAddress) throws IOException {
            this.saslLoginFailed = false;
            if (!this.isFirstConnect) {
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                }
                catch (InterruptedException interruptedException) {
                    LOG.c("Unexpected exception", interruptedException);
                }
            }
            this.changeZkState(ZooKeeper.States.CONNECTING);
            String string = inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
            hoe.a("myid", string);
            this.setName(this.getName().replaceAll("\\(.*\\)", "(" + string + ")"));
            if (ClientCnxn.this.clientConfig.isSaslClientEnabled()) {
                try {
                    this.zooKeeperSaslClient = new ZooKeeperSaslClient(SaslServerPrincipal.getServerPrincipal(inetSocketAddress, ClientCnxn.this.clientConfig), ClientCnxn.this.clientConfig, this.loginRef);
                }
                catch (LoginException loginException) {
                    LOG.c("SASL configuration failed. Will continue connection to Zookeeper server without SASL authentication, if Zookeeper server allows it.", loginException);
                    ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
                    this.saslLoginFailed = true;
                }
            }
            this.logStartConnect(inetSocketAddress);
            this.clientCnxnSocket.connect(inetSocketAddress);
        }

        private void logStartConnect(InetSocketAddress inetSocketAddress) {
            LOG.c("Opening socket connection to server {}.", (Object)inetSocketAddress);
            if (this.zooKeeperSaslClient != null) {
                LOG.c("SASL config status: {}", (Object)this.zooKeeperSaslClient.getConfigStatus());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.clientCnxnSocket.introduce(this, ClientCnxn.this.sessionId, ClientCnxn.this.outgoingQueue);
            this.clientCnxnSocket.updateNow();
            this.clientCnxnSocket.updateLastSendAndHeard();
            long l2 = Time.currentElapsedTime();
            int n2 = 10000;
            InetSocketAddress inetSocketAddress = null;
            while (ClientCnxn.this.state.isAlive()) {
                try {
                    int n3;
                    int n4;
                    if (!this.clientCnxnSocket.isConnected()) {
                        if (ClientCnxn.this.closing) break;
                        if (this.rwServerAddress != null) {
                            inetSocketAddress = this.rwServerAddress;
                            this.rwServerAddress = null;
                        } else {
                            inetSocketAddress = ClientCnxn.this.hostProvider.next(1000L);
                        }
                        ClientCnxn.this.onConnecting(inetSocketAddress);
                        this.startConnect(inetSocketAddress);
                        this.clientCnxnSocket.updateNow();
                        this.clientCnxnSocket.updateLastSendAndHeard();
                    }
                    if (ClientCnxn.this.state.isConnected()) {
                        if (this.zooKeeperSaslClient != null) {
                            Watcher.Event.KeeperState keeperState;
                            n4 = 0;
                            if (this.zooKeeperSaslClient.getSaslState() == ZooKeeperSaslClient.SaslState.INITIAL) {
                                try {
                                    this.zooKeeperSaslClient.initialize(ClientCnxn.this);
                                }
                                catch (SaslException saslException) {
                                    LOG.d("SASL authentication with Zookeeper Quorum member failed.", saslException);
                                    this.changeZkState(ZooKeeper.States.AUTH_FAILED);
                                    n4 = 1;
                                }
                            }
                            if ((keeperState = this.zooKeeperSaslClient.getKeeperState()) != null) {
                                if (keeperState == Watcher.Event.KeeperState.AuthFailed) {
                                    this.changeZkState(ZooKeeper.States.AUTH_FAILED);
                                    n4 = 1;
                                } else if (keeperState == Watcher.Event.KeeperState.SaslAuthenticated) {
                                    n4 = 1;
                                }
                            }
                            if (n4 != 0) {
                                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, keeperState, null));
                                if (ClientCnxn.this.state == ZooKeeper.States.AUTH_FAILED) {
                                    ClientCnxn.this.eventThread.queueEventOfDeath();
                                }
                            }
                        }
                        n3 = ClientCnxn.this.readTimeout - this.clientCnxnSocket.getIdleRecv();
                    } else {
                        n3 = ClientCnxn.this.connectTimeout - this.clientCnxnSocket.getIdleRecv();
                    }
                    if (n3 <= 0) {
                        String string = String.format("Client session timed out, have not heard from server in %dms for session id 0x%s", this.clientCnxnSocket.getIdleRecv(), Long.toHexString(ClientCnxn.this.sessionId));
                        LOG.d(string);
                        throw new SessionTimeoutException(string);
                    }
                    if (ClientCnxn.this.state.isConnected()) {
                        n4 = ClientCnxn.this.readTimeout / 2 - this.clientCnxnSocket.getIdleSend() - (this.clientCnxnSocket.getIdleSend() > 1000 ? 1000 : 0);
                        if (n4 <= 0 || this.clientCnxnSocket.getIdleSend() > 10000) {
                            this.sendPing();
                            this.clientCnxnSocket.updateLastSend();
                        } else if (n4 < n3) {
                            n3 = n4;
                        }
                    }
                    if (ClientCnxn.this.state == ZooKeeper.States.CONNECTEDREADONLY) {
                        long l3 = Time.currentElapsedTime();
                        int n5 = (int)(l3 - l2);
                        if (n5 >= this.pingRwTimeout) {
                            l2 = l3;
                            n5 = 0;
                            this.pingRwTimeout = Math.min(2 * this.pingRwTimeout, 60000);
                            this.pingRwServer();
                        }
                        n3 = Math.min(n3, this.pingRwTimeout - n5);
                    }
                    this.clientCnxnSocket.doTransport(n3, ClientCnxn.this.pendingQueue, ClientCnxn.this);
                }
                catch (Throwable throwable) {
                    if (ClientCnxn.this.closing) {
                        if (!LOG.c()) break;
                        LOG.b("An exception was thrown while closing send thread for session 0x{}.", (Object)Long.toHexString(ClientCnxn.this.getSessionId()), (Object)throwable);
                        break;
                    }
                    LOG.d("Session 0x{} for server {}, Closing socket connection. Attempting reconnect except it is a SessionExpiredException.", Long.toHexString(ClientCnxn.this.getSessionId()), inetSocketAddress, throwable);
                    this.cleanAndNotifyState();
                }
            }
            Object object = ClientCnxn.this.outgoingQueue;
            synchronized (object) {
                this.cleanup();
            }
            this.clientCnxnSocket.close();
            if (ClientCnxn.this.state.isAlive()) {
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
            }
            ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Closed, null));
            object = this.loginRef.getAndSet(null);
            if (object != null) {
                ((Login)object).shutdown();
            }
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SendThread exited loop for session: 0x" + Long.toHexString(ClientCnxn.this.getSessionId()));
        }

        private void cleanAndNotifyState() {
            this.cleanup();
            if (ClientCnxn.this.state.isAlive()) {
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
            }
            this.clientCnxnSocket.updateNow();
            this.clientCnxnSocket.updateLastSendAndHeard();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pingRwServer() throws RWServerFoundException {
            String string = null;
            InetSocketAddress inetSocketAddress = ClientCnxn.this.hostProvider.next(0L);
            LOG.c("Checking server {} for being r/w. Timeout {}", (Object)inetSocketAddress, (Object)this.pingRwTimeout);
            Socket socket = null;
            BufferedReader bufferedReader = null;
            try {
                socket = new Socket(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
                socket.setSoLinger(false, -1);
                socket.setSoTimeout(1000);
                socket.setTcpNoDelay(true);
                socket.getOutputStream().write("isro".getBytes());
                socket.getOutputStream().flush();
                socket.shutdownOutput();
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                string = bufferedReader.readLine();
            }
            catch (ConnectException connectException) {
            }
            catch (IOException iOException) {
                LOG.c("Exception while seeking for r/w server.", iOException);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        LOG.c("Unexpected exception", iOException);
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        LOG.c("Unexpected exception", iOException);
                    }
                }
            }
            if ("rw".equals(string)) {
                this.pingRwTimeout = 100;
                this.rwServerAddress = inetSocketAddress;
                throw new RWServerFoundException("Majority server found at " + inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            this.clientCnxnSocket.cleanup();
            Object object = ClientCnxn.this.pendingQueue;
            synchronized (object) {
                for (Packet packet : ClientCnxn.this.pendingQueue) {
                    ClientCnxn.this.conLossPacket(packet);
                }
                ClientCnxn.this.pendingQueue.clear();
            }
            object = ClientCnxn.this.outgoingQueue.iterator();
            while (object.hasNext()) {
                Packet packet = (Packet)object.next();
                ClientCnxn.this.conLossPacket(packet);
                object.remove();
            }
        }

        void onConnected(int n2, long l2, byte[] byArray, boolean bl2) throws IOException {
            ClientCnxn.this.negotiatedSessionTimeout = n2;
            if (ClientCnxn.this.negotiatedSessionTimeout <= 0) {
                this.changeZkState(ZooKeeper.States.CLOSED);
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
                ClientCnxn.this.eventThread.queueEventOfDeath();
                String string = String.format("Unable to reconnect to ZooKeeper service, session 0x%s has expired", Long.toHexString(ClientCnxn.this.sessionId));
                LOG.d(string);
                throw new SessionExpiredException(string);
            }
            if (!ClientCnxn.this.readOnly && bl2) {
                LOG.e("Read/write client got connected to read-only server");
            }
            ClientCnxn.this.readTimeout = ClientCnxn.this.negotiatedSessionTimeout * 2 / 3;
            ClientCnxn.this.connectTimeout = ClientCnxn.this.negotiatedSessionTimeout / ClientCnxn.this.hostProvider.size();
            ClientCnxn.this.hostProvider.onConnected();
            ClientCnxn.this.sessionId = l2;
            ClientCnxn.access$1602(ClientCnxn.this, byArray);
            this.changeZkState(bl2 ? ZooKeeper.States.CONNECTEDREADONLY : ZooKeeper.States.CONNECTED);
            ClientCnxn.this.seenRwServerBefore = ClientCnxn.this.seenRwServerBefore | !bl2;
            LOG.c("Session establishment complete on server {}, session id = 0x{}, negotiated timeout = {}{}", this.clientCnxnSocket.getRemoteSocketAddress(), Long.toHexString(ClientCnxn.this.sessionId), ClientCnxn.this.negotiatedSessionTimeout, bl2 ? " (READ-ONLY mode)" : "");
            Watcher.Event.KeeperState keeperState = bl2 ? Watcher.Event.KeeperState.ConnectedReadOnly : Watcher.Event.KeeperState.SyncConnected;
            ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, keeperState, null));
        }

        void close() {
            try {
                this.changeZkState(ZooKeeper.States.CLOSED);
            }
            catch (IOException iOException) {
                LOG.d("Connection close fails when migrates state from {} to CLOSED", (Object)this.getZkState());
            }
            this.clientCnxnSocket.onClosing();
        }

        void testableCloseSocket() throws IOException {
            this.clientCnxnSocket.testableCloseSocket();
        }

        public boolean tunnelAuthInProgress() {
            if (!ClientCnxn.this.clientConfig.isSaslClientEnabled()) {
                return false;
            }
            if (this.saslLoginFailed) {
                return false;
            }
            if (this.zooKeeperSaslClient == null) {
                return true;
            }
            return this.zooKeeperSaslClient.clientTunneledAuthenticationInProgress();
        }

        public void sendPacket(Packet packet) throws IOException {
            this.clientCnxnSocket.sendPacket(packet);
        }

        public ZooKeeperSaslClient getZooKeeperSaslClient() {
            return this.zooKeeperSaslClient;
        }

        Login getLogin() {
            return this.loginRef.get();
        }
    }

    static class RWServerFoundException
    extends IOException {
        private static final long serialVersionUID = 90431199887158758L;

        public RWServerFoundException(String string) {
            super(string);
        }
    }

    static class SessionExpiredException
    extends IOException {
        private static final long serialVersionUID = -1388816932076193249L;

        public SessionExpiredException(String string) {
            super(string);
        }
    }

    static class SessionTimeoutException
    extends IOException {
        private static final long serialVersionUID = 824482094072071178L;

        public SessionTimeoutException(String string) {
            super(string);
        }
    }

    static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -5438877188796231422L;

        public EndOfStreamException(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    class EventThread
    extends ZooKeeperThread {
        private final LinkedBlockingQueue<Object> waitingEvents;
        private volatile Watcher.Event.KeeperState sessionState;
        private volatile boolean wasKilled;
        private volatile boolean isRunning;

        EventThread() {
            super(ClientCnxn.makeThreadName("-EventThread"));
            this.waitingEvents = new LinkedBlockingQueue();
            this.sessionState = Watcher.Event.KeeperState.Disconnected;
            this.wasKilled = false;
            this.isRunning = false;
            this.setDaemon(true);
        }

        public void queueEvent(WatchedEvent watchedEvent) {
            this.queueEvent(watchedEvent, null);
        }

        private void queueEvent(WatchedEvent watchedEvent, Set<Watcher> set) {
            if (watchedEvent.getType() == Watcher.Event.EventType.None && this.sessionState == watchedEvent.getState()) {
                return;
            }
            this.sessionState = watchedEvent.getState();
            Set<Watcher> set2 = set == null ? ClientCnxn.this.watchManager.materialize(watchedEvent.getState(), watchedEvent.getType(), watchedEvent.getPath()) : new HashSet<Watcher>(set);
            WatcherSetEventPair watcherSetEventPair = new WatcherSetEventPair(set2, watchedEvent);
            this.waitingEvents.add(watcherSetEventPair);
        }

        public void queueCallback(AsyncCallback asyncCallback, int n2, String string, Object object) {
            this.waitingEvents.add(new LocalCallback(asyncCallback, n2, string, object));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queuePacket(Packet packet) {
            if (this.wasKilled) {
                LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                synchronized (linkedBlockingQueue) {
                    if (this.isRunning) {
                        this.waitingEvents.add(packet);
                    } else {
                        this.processEvent(packet);
                    }
                }
            } else {
                this.waitingEvents.add(packet);
            }
        }

        public void queueEventOfDeath() {
            this.waitingEvents.add(ClientCnxn.this.eventOfDeath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.isRunning = true;
                while (true) {
                    Object object;
                    if ((object = this.waitingEvents.take()) == ClientCnxn.this.eventOfDeath) {
                        this.wasKilled = true;
                    } else {
                        this.processEvent(object);
                    }
                    if (!this.wasKilled) continue;
                    LinkedBlockingQueue<Object> linkedBlockingQueue = this.waitingEvents;
                    synchronized (linkedBlockingQueue) {
                        if (this.waitingEvents.isEmpty()) {
                            this.isRunning = false;
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.d("Event thread exiting due to interruption", interruptedException);
            }
            LOG.c("EventThread shut down for session: 0x{}", (Object)Long.toHexString(ClientCnxn.this.getSessionId()));
        }

        private void processEvent(Object object) {
            try {
                if (object instanceof WatcherSetEventPair) {
                    WatcherSetEventPair watcherSetEventPair = (WatcherSetEventPair)object;
                    for (Watcher watcher : watcherSetEventPair.watchers) {
                        try {
                            watcher.process(watcherSetEventPair.event);
                        }
                        catch (Throwable throwable) {
                            LOG.d("Error while calling watcher.", throwable);
                        }
                    }
                } else if (object instanceof LocalCallback) {
                    LocalCallback localCallback = (LocalCallback)object;
                    if (localCallback.cb instanceof AsyncCallback.StatCallback) {
                        ((AsyncCallback.StatCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null);
                    } else if (localCallback.cb instanceof AsyncCallback.DataCallback) {
                        ((AsyncCallback.DataCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null, null);
                    } else if (localCallback.cb instanceof AsyncCallback.ACLCallback) {
                        ((AsyncCallback.ACLCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null, null);
                    } else if (localCallback.cb instanceof AsyncCallback.ChildrenCallback) {
                        ((AsyncCallback.ChildrenCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null);
                    } else if (localCallback.cb instanceof AsyncCallback.Children2Callback) {
                        ((AsyncCallback.Children2Callback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null, null);
                    } else if (localCallback.cb instanceof AsyncCallback.StringCallback) {
                        ((AsyncCallback.StringCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, null);
                    } else if (localCallback.cb instanceof AsyncCallback.EphemeralsCallback) {
                        ((AsyncCallback.EphemeralsCallback)localCallback.cb).processResult(localCallback.rc, localCallback.ctx, null);
                    } else if (localCallback.cb instanceof AsyncCallback.AllChildrenNumberCallback) {
                        ((AsyncCallback.AllChildrenNumberCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, -1);
                    } else if (localCallback.cb instanceof AsyncCallback.MultiCallback) {
                        ((AsyncCallback.MultiCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx, Collections.emptyList());
                    } else {
                        ((AsyncCallback.VoidCallback)localCallback.cb).processResult(localCallback.rc, localCallback.path, localCallback.ctx);
                    }
                } else {
                    Packet packet = (Packet)object;
                    int n2 = 0;
                    String string = packet.clientPath;
                    if (packet.replyHeader.getErr() != 0) {
                        n2 = packet.replyHeader.getErr();
                    }
                    if (packet.cb == null) {
                        LOG.d("Somehow a null cb got to EventThread!");
                    } else if (packet.response instanceof ExistsResponse || packet.response instanceof SetDataResponse || packet.response instanceof SetACLResponse) {
                        AsyncCallback.StatCallback statCallback = (AsyncCallback.StatCallback)packet.cb;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            if (packet.response instanceof ExistsResponse) {
                                statCallback.processResult(n2, string, packet.ctx, ((ExistsResponse)packet.response).getStat());
                            } else if (packet.response instanceof SetDataResponse) {
                                statCallback.processResult(n2, string, packet.ctx, ((SetDataResponse)packet.response).getStat());
                            } else if (packet.response instanceof SetACLResponse) {
                                statCallback.processResult(n2, string, packet.ctx, ((SetACLResponse)packet.response).getStat());
                            }
                        } else {
                            statCallback.processResult(n2, string, packet.ctx, null);
                        }
                    } else if (packet.response instanceof GetDataResponse) {
                        AsyncCallback.DataCallback dataCallback = (AsyncCallback.DataCallback)packet.cb;
                        GetDataResponse getDataResponse = (GetDataResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            dataCallback.processResult(n2, string, packet.ctx, getDataResponse.getData(), getDataResponse.getStat());
                        } else {
                            dataCallback.processResult(n2, string, packet.ctx, null, null);
                        }
                    } else if (packet.response instanceof GetACLResponse) {
                        AsyncCallback.ACLCallback aCLCallback = (AsyncCallback.ACLCallback)packet.cb;
                        GetACLResponse getACLResponse = (GetACLResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            aCLCallback.processResult(n2, string, packet.ctx, getACLResponse.getAcl(), getACLResponse.getStat());
                        } else {
                            aCLCallback.processResult(n2, string, packet.ctx, null, null);
                        }
                    } else if (packet.response instanceof GetChildrenResponse) {
                        AsyncCallback.ChildrenCallback childrenCallback = (AsyncCallback.ChildrenCallback)packet.cb;
                        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            childrenCallback.processResult(n2, string, packet.ctx, getChildrenResponse.getChildren());
                        } else {
                            childrenCallback.processResult(n2, string, packet.ctx, null);
                        }
                    } else if (packet.response instanceof GetAllChildrenNumberResponse) {
                        AsyncCallback.AllChildrenNumberCallback allChildrenNumberCallback = (AsyncCallback.AllChildrenNumberCallback)packet.cb;
                        GetAllChildrenNumberResponse getAllChildrenNumberResponse = (GetAllChildrenNumberResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            allChildrenNumberCallback.processResult(n2, string, packet.ctx, getAllChildrenNumberResponse.getTotalNumber());
                        } else {
                            allChildrenNumberCallback.processResult(n2, string, packet.ctx, -1);
                        }
                    } else if (packet.response instanceof GetChildren2Response) {
                        AsyncCallback.Children2Callback children2Callback = (AsyncCallback.Children2Callback)packet.cb;
                        GetChildren2Response getChildren2Response = (GetChildren2Response)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            children2Callback.processResult(n2, string, packet.ctx, getChildren2Response.getChildren(), getChildren2Response.getStat());
                        } else {
                            children2Callback.processResult(n2, string, packet.ctx, null, null);
                        }
                    } else if (packet.response instanceof CreateResponse) {
                        AsyncCallback.StringCallback stringCallback = (AsyncCallback.StringCallback)packet.cb;
                        CreateResponse createResponse = (CreateResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            stringCallback.processResult(n2, string, packet.ctx, ClientCnxn.this.chrootPath == null ? createResponse.getPath() : createResponse.getPath().substring(ClientCnxn.this.chrootPath.length()));
                        } else {
                            stringCallback.processResult(n2, string, packet.ctx, null);
                        }
                    } else if (packet.response instanceof Create2Response) {
                        AsyncCallback.Create2Callback create2Callback = (AsyncCallback.Create2Callback)packet.cb;
                        Create2Response create2Response = (Create2Response)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            create2Callback.processResult(n2, string, packet.ctx, ClientCnxn.this.chrootPath == null ? create2Response.getPath() : create2Response.getPath().substring(ClientCnxn.this.chrootPath.length()), create2Response.getStat());
                        } else {
                            create2Callback.processResult(n2, string, packet.ctx, null, null);
                        }
                    } else if (packet.response instanceof MultiResponse) {
                        AsyncCallback.MultiCallback multiCallback = (AsyncCallback.MultiCallback)packet.cb;
                        MultiResponse multiResponse = (MultiResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            List<OpResult> list = multiResponse.getResultList();
                            int n3 = n2;
                            for (OpResult opResult : list) {
                                if (!(opResult instanceof OpResult.ErrorResult)) continue;
                                n3 = ((OpResult.ErrorResult)opResult).getErr();
                                if (KeeperException.Code.OK.intValue() == n3) continue;
                                break;
                            }
                            multiCallback.processResult(n3, string, packet.ctx, list);
                        } else {
                            multiCallback.processResult(n2, string, packet.ctx, null);
                        }
                    } else if (packet.response instanceof GetEphemeralsResponse) {
                        AsyncCallback.EphemeralsCallback ephemeralsCallback = (AsyncCallback.EphemeralsCallback)packet.cb;
                        GetEphemeralsResponse getEphemeralsResponse = (GetEphemeralsResponse)packet.response;
                        if (n2 == KeeperException.Code.OK.intValue()) {
                            ephemeralsCallback.processResult(n2, packet.ctx, getEphemeralsResponse.getEphemerals());
                        } else {
                            ephemeralsCallback.processResult(n2, packet.ctx, null);
                        }
                    } else if (packet.cb instanceof AsyncCallback.VoidCallback) {
                        AsyncCallback.VoidCallback voidCallback = (AsyncCallback.VoidCallback)packet.cb;
                        voidCallback.processResult(n2, string, packet.ctx);
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.d("Unexpected throwable", throwable);
            }
        }
    }

    static class WatcherSetEventPair {
        private final Set<Watcher> watchers;
        private final WatchedEvent event;

        public WatcherSetEventPair(Set<Watcher> set, WatchedEvent watchedEvent) {
            this.watchers = set;
            this.event = watchedEvent;
        }
    }

    public static class Packet {
        RequestHeader requestHeader;
        ReplyHeader replyHeader;
        mme request;
        mme response;
        ByteBuffer bb;
        String clientPath;
        String serverPath;
        boolean finished;
        AsyncCallback cb;
        Object ctx;
        ZooKeeper.WatchRegistration watchRegistration;
        WatchDeregistration watchDeregistration;

        Packet(RequestHeader requestHeader, ReplyHeader replyHeader, mme mme2, mme mme3, ZooKeeper.WatchRegistration watchRegistration) {
            this.requestHeader = requestHeader;
            this.replyHeader = replyHeader;
            this.request = mme2;
            this.response = mme3;
            this.watchRegistration = watchRegistration;
        }

        public void createBB() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ime ime2 = ime.a(byteArrayOutputStream);
                ime2.a(-1, "len");
                if (this.requestHeader != null) {
                    this.requestHeader.serialize(ime2, "header");
                }
                if (this.request instanceof ConnectRequest) {
                    this.request.serialize(ime2, "connect");
                } else if (this.request != null) {
                    this.request.serialize(ime2, "request");
                }
                byteArrayOutputStream.close();
                this.bb = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                this.bb.putInt(this.bb.capacity() - 4);
                this.bb.rewind();
            }
            catch (IOException iOException) {
                LOG.c("Unexpected exception", iOException);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("clientPath:" + this.clientPath);
            stringBuilder.append(" serverPath:" + this.serverPath);
            stringBuilder.append(" finished:" + this.finished);
            stringBuilder.append(" header:: " + this.requestHeader);
            stringBuilder.append(" replyHeader:: " + this.replyHeader);
            stringBuilder.append(" request:: " + this.request);
            stringBuilder.append(" response:: " + this.response);
            return stringBuilder.toString().replaceAll("\r*\n+", " ");
        }
    }

    static class AuthData {
        String scheme;
        byte[] data;

        AuthData(String string, byte[] byArray) {
            this.scheme = string;
            this.data = byArray;
        }
    }
}

