/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.traffic;

import XdepsXdatabricksX240X9088.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.traffic.GlobalChannelTrafficCounter;
import XdepsXdatabricksX240X9088.io.netty.handler.traffic.TrafficCounter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    volatile long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        ObjectUtil.checkNotNullWithIAE((Object)scheduledExecutorService, (String)"executor");
        GlobalChannelTrafficCounter globalChannelTrafficCounter = new GlobalChannelTrafficCounter(this, scheduledExecutorService, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter(globalChannelTrafficCounter);
        ((TrafficCounter)globalChannelTrafficCounter).start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 3;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5, long l6, long l7) {
        super(l2, l3, l6, l7);
        this.createGlobalTrafficCounter(scheduledExecutorService);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5, long l6) {
        super(l2, l3, l6);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5) {
        super(l2, l3);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2) {
        super(l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService) {
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    public void setMaxDeviation(float f2, float f3, float f4) {
        if (f2 > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        ObjectUtil.checkPositiveOrZero((float)f3, (String)"slowDownFactor");
        if (f4 > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = f2;
        this.accelerationFactor = 1.0f + f4;
        this.slowDownFactor = 1.0f + f3;
    }

    private void computeDeviationCumulativeBytes() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MAX_VALUE;
        for (PerChannel perChannel : this.channelQueues.values()) {
            long l6 = perChannel.channelTrafficCounter.cumulativeWrittenBytes();
            if (l2 < l6) {
                l2 = l6;
            }
            if (l4 > l6) {
                l4 = l6;
            }
            if (l3 < (l6 = perChannel.channelTrafficCounter.cumulativeReadBytes())) {
                l3 = l6;
            }
            if (l5 <= l6) continue;
            l5 = l6;
        }
        boolean bl2 = this.channelQueues.size() > 1;
        this.readDeviationActive = bl2 && l5 < l3 / 2L;
        this.writeDeviationActive = bl2 && l4 < l2 / 2L;
        this.cumulativeWrittenBytes.set(l2);
        this.cumulativeReadBytes.set(l3);
    }

    @Override
    protected void doAccounting(TrafficCounter trafficCounter) {
        this.computeDeviationCumulativeBytes();
        super.doAccounting(trafficCounter);
    }

    private long computeBalancedWait(float f2, float f3, long l2) {
        if (f3 == 0.0f) {
            return l2;
        }
        float f4 = f2 / f3;
        if (f4 > this.maxDeviation) {
            if (f4 < 1.0f - this.maxDeviation) {
                return l2;
            }
            f4 = this.slowDownFactor;
            if (l2 < 10L) {
                l2 = 10L;
            }
        } else {
            f4 = this.accelerationFactor;
        }
        return (long)((float)l2 * f4);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l2) {
        this.maxGlobalWriteSize = ObjectUtil.checkPositive((long)l2, (String)"maxGlobalWriteSize");
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public void configureChannel(long l2, long l3) {
        this.writeChannelLimit = l2;
        this.readChannelLimit = l3;
        long l4 = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(l4);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    public void setWriteChannelLimit(long l2) {
        this.writeChannelLimit = l2;
        long l3 = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(l3);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    public void setReadChannelLimit(long l2) {
        this.readChannelLimit = l2;
        long l3 = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(l3);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel == null) {
            perChannel = new PerChannel();
            perChannel.messagesQueue = new ArrayDeque();
            perChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n2, perChannel);
        }
        return perChannel;
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.getOrSetPerChannel(channelHandlerContext);
        this.trafficCounter.resetCumulativeTime();
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.trafficCounter.resetCumulativeTime();
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(n2);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                if (channel.isActive()) {
                    for (ToSend toSend : perChannel.messagesQueue) {
                        long l2 = this.calculateSize(toSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l2);
                        perChannel.channelTrafficCounter.bytesRealWriteFlowControl(l2);
                        perChannel.queueSize -= l2;
                        this.queuesSize.addAndGet(-l2);
                        channelHandlerContext.write(toSend.toSend, toSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-perChannel.queueSize);
                    for (ToSend toSend : perChannel.messagesQueue) {
                        if (!(toSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)toSend.toSend).release();
                    }
                }
                perChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        long l2 = this.calculateSize(object);
        long l3 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l4 = this.trafficCounter.readTimeToWait(l2, this.getReadLimit(), this.maxTime, l3);
            Integer n2 = channelHandlerContext.channel().hashCode();
            PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
            long l5 = 0L;
            if (perChannel != null) {
                l5 = perChannel.channelTrafficCounter.readTimeToWait(l2, this.readChannelLimit, this.maxTime, l3);
                if (this.readDeviationActive) {
                    long l6 = perChannel.channelTrafficCounter.cumulativeReadBytes();
                    long l7 = this.cumulativeReadBytes.get();
                    if (l6 <= 0L) {
                        l6 = 0L;
                    }
                    if (l7 < l6) {
                        l7 = l6;
                    }
                    l5 = this.computeBalancedWait(l6, l7, l5);
                }
            }
            if (l5 < l4) {
                l5 = l4;
            }
            if ((l5 = this.checkWaitReadTime(channelHandlerContext, l5, l3)) >= 10L) {
                Channel channel = channelHandlerContext.channel();
                ChannelConfig channelConfig = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read Suspend: " + l5 + ':' + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set((Object)true);
                    Attribute attribute = channel.attr(REOPEN_TASK);
                    Runnable runnable = (Runnable)attribute.get();
                    if (runnable == null) {
                        runnable = new AbstractTrafficShapingHandler.ReopenReadTimerTask(channelHandlerContext);
                        attribute.set((Object)runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l5, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l5);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l3);
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    protected long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l3) {
        Integer n2 = channelHandlerContext.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel != null && l2 > this.maxTime && l3 + l2 - perChannel.lastReadTimestamp > this.maxTime) {
            l2 = this.maxTime;
        }
        return l2;
    }

    @Override
    protected void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
        Integer n2 = channelHandlerContext.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel != null) {
            perChannel.lastReadTimestamp = l2;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new AbstractCollection<TrafficCounter>(){

            @Override
            public Iterator<TrafficCounter> iterator() {
                return new Iterator<TrafficCounter>(){
                    final Iterator<PerChannel> iter;
                    {
                        this.iter = GlobalChannelTrafficShapingHandler.this.channelQueues.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public TrafficCounter next() {
                        return this.iter.next().channelTrafficCounter;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return GlobalChannelTrafficShapingHandler.this.channelQueues.size();
            }
        };
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        long l2 = this.calculateSize(object);
        long l3 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l4 = this.trafficCounter.writeTimeToWait(l2, this.getWriteLimit(), this.maxTime, l3);
            Integer n2 = channelHandlerContext.channel().hashCode();
            PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
            long l5 = 0L;
            if (perChannel != null) {
                l5 = perChannel.channelTrafficCounter.writeTimeToWait(l2, this.writeChannelLimit, this.maxTime, l3);
                if (this.writeDeviationActive) {
                    long l6 = perChannel.channelTrafficCounter.cumulativeWrittenBytes();
                    long l7 = this.cumulativeWrittenBytes.get();
                    if (l6 <= 0L) {
                        l6 = 0L;
                    }
                    if (l7 < l6) {
                        l7 = l6;
                    }
                    l5 = this.computeBalancedWait(l6, l7, l5);
                }
            }
            if (l5 < l4) {
                l5 = l4;
            }
            if (l5 >= 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + l5 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                this.submitWrite(channelHandlerContext, object, l2, l5, l3, channelPromise);
                return;
            }
        }
        this.submitWrite(channelHandlerContext, object, l2, 0L, l3, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submitWrite(final ChannelHandlerContext channelHandlerContext, Object object, long l2, long l3, long l4, ChannelPromise channelPromise) {
        ToSend toSend;
        Channel channel = channelHandlerContext.channel();
        Integer n2 = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(n2);
        if (perChannel == null) {
            perChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l5 = l3;
        boolean bl2 = false;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            if (l3 == 0L && perChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                perChannel.channelTrafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                perChannel.lastWriteTimestamp = l4;
                return;
            }
            if (l5 > this.maxTime && l4 + l5 - perChannel.lastWriteTimestamp > this.maxTime) {
                l5 = this.maxTime;
            }
            toSend = new ToSend(l5 + l4, object, l2, channelPromise);
            perChannel.messagesQueue.addLast(toSend);
            perChannel.queueSize += l2;
            this.queuesSize.addAndGet(l2);
            this.checkWriteSuspend(channelHandlerContext, l5, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        final long l6 = toSend.relativeTimeAction;
        final PerChannel perChannel3 = perChannel;
        channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                GlobalChannelTrafficShapingHandler.this.sendAllValid(channelHandlerContext, perChannel3, l6);
            }
        }, l5, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, PerChannel perChannel, long l2) {
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            ToSend toSend = perChannel.messagesQueue.pollFirst();
            while (toSend != null) {
                long l3;
                if (toSend.relativeTimeAction <= l2) {
                    l3 = toSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l3);
                    perChannel.channelTrafficCounter.bytesRealWriteFlowControl(l3);
                    perChannel.queueSize -= l3;
                } else {
                    perChannel.messagesQueue.addFirst(toSend);
                    break;
                }
                this.queuesSize.addAndGet(-l3);
                channelHandlerContext.write(toSend.toSend, toSend.promise);
                perChannel.lastWriteTimestamp = l2;
                toSend = perChannel.messagesQueue.pollFirst();
            }
            if (perChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final ChannelPromise promise;
        final long size;

        private ToSend(long l2, Object object, long l3, ChannelPromise channelPromise) {
            this.relativeTimeAction = l2;
            this.toSend = object;
            this.size = l3;
            this.promise = channelPromise;
        }
    }

    static final class PerChannel {
        ArrayDeque<ToSend> messagesQueue;
        TrafficCounter channelTrafficCounter;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        PerChannel() {
        }
    }
}

