/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.traffic;

import XdepsXdatabricksX240X9088.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.traffic.TrafficCounter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ArrayDeque<ToSend> messagesQueue = new ArrayDeque();
    private long queueSize;

    public ChannelTrafficShapingHandler(long l2, long l3, long l4, long l5) {
        super(l2, l3, l4, l5);
    }

    public ChannelTrafficShapingHandler(long l2, long l3, long l4) {
        super(l2, l3, l4);
    }

    public ChannelTrafficShapingHandler(long l2, long l3) {
        super(l2, l3);
    }

    public ChannelTrafficShapingHandler(long l2) {
        super(l2);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        TrafficCounter trafficCounter = new TrafficCounter(this, (ScheduledExecutorService)channelHandlerContext.executor(), "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.trafficCounter.stop();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (channelHandlerContext.channel().isActive()) {
                for (ToSend toSend : this.messagesQueue) {
                    long l2 = this.calculateSize(toSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    this.queueSize -= l2;
                    channelHandlerContext.write(toSend.toSend, toSend.promise);
                }
            } else {
                for (ToSend toSend : this.messagesQueue) {
                    if (!(toSend.toSend instanceof ByteBuf)) continue;
                    ((ByteBuf)toSend.toSend).release();
                }
            }
            this.messagesQueue.clear();
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void submitWrite(final ChannelHandlerContext channelHandlerContext, Object object, long l2, long l3, long l4, ChannelPromise channelPromise) {
        ToSend toSend;
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (l3 == 0L && this.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                return;
            }
            toSend = new ToSend(l3 + l4, object, channelPromise);
            this.messagesQueue.addLast(toSend);
            this.queueSize += l2;
            this.checkWriteSuspend(channelHandlerContext, l3, this.queueSize);
        }
        final long l5 = toSend.relativeTimeAction;
        channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                ChannelTrafficShapingHandler.this.sendAllValid(channelHandlerContext, l5);
            }
        }, l3, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, long l2) {
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            ToSend toSend = this.messagesQueue.pollFirst();
            while (toSend != null) {
                if (toSend.relativeTimeAction <= l2) {
                    long l3 = this.calculateSize(toSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l3);
                    this.queueSize -= l3;
                } else {
                    this.messagesQueue.addFirst(toSend);
                    break;
                }
                channelHandlerContext.write(toSend.toSend, toSend.promise);
                toSend = this.messagesQueue.pollFirst();
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    public long queueSize() {
        return this.queueSize;
    }

    static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final ChannelPromise promise;

        private ToSend(long l2, Object object, ChannelPromise channelPromise) {
            this.relativeTimeAction = l2;
            this.toSend = object;
            this.promise = channelPromise;
        }
    }
}

