/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.traffic;

import XdepsXdatabricksX240X9088.io.netty.handler.traffic.TrafficCounter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTrafficShapingHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_TIME = 15000L;
    static final long DEFAULT_MAX_SIZE = 0x400000L;
    static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private volatile long writeLimit;
    private volatile long readLimit;
    protected volatile long maxTime = 15000L;
    protected volatile long checkInterval = 1000L;
    static final AttributeKey<Boolean> READ_SUSPENDED = AttributeKey.valueOf((String)(AbstractTrafficShapingHandler.class.getName() + ".READ_SUSPENDED"));
    static final AttributeKey<Runnable> REOPEN_TASK = AttributeKey.valueOf((String)(AbstractTrafficShapingHandler.class.getName() + ".REOPEN_TASK"));
    volatile long maxWriteDelay = 4000L;
    volatile long maxWriteSize = 0x400000L;
    final int userDefinedWritabilityIndex;
    static final int CHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 1;
    static final int GLOBAL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 2;
    static final int GLOBALCHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 3;

    void setTrafficCounter(TrafficCounter trafficCounter) {
        this.trafficCounter = trafficCounter;
    }

    protected int userDefinedWritabilityIndex() {
        return 1;
    }

    protected AbstractTrafficShapingHandler(long l2, long l3, long l4, long l5) {
        this.maxTime = ObjectUtil.checkPositive((long)l5, (String)"maxTime");
        this.userDefinedWritabilityIndex = this.userDefinedWritabilityIndex();
        this.writeLimit = l2;
        this.readLimit = l3;
        this.checkInterval = l4;
    }

    protected AbstractTrafficShapingHandler(long l2, long l3, long l4) {
        this(l2, l3, l4, 15000L);
    }

    protected AbstractTrafficShapingHandler(long l2, long l3) {
        this(l2, l3, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler() {
        this(0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(long l2) {
        this(0L, 0L, l2, 15000L);
    }

    public void configure(long l2, long l3, long l4) {
        this.configure(l2, l3);
        this.configure(l4);
    }

    public void configure(long l2, long l3) {
        this.writeLimit = l2;
        this.readLimit = l3;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public void configure(long l2) {
        this.checkInterval = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(long l2) {
        this.writeLimit = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(long l2) {
        this.readLimit = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long l2) {
        this.checkInterval = l2;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(l2);
        }
    }

    public void setMaxTimeWait(long l2) {
        this.maxTime = ObjectUtil.checkPositive((long)l2, (String)"maxTime");
    }

    public long getMaxTimeWait() {
        return this.maxTime;
    }

    public long getMaxWriteDelay() {
        return this.maxWriteDelay;
    }

    public void setMaxWriteDelay(long l2) {
        this.maxWriteDelay = ObjectUtil.checkPositive((long)l2, (String)"maxWriteDelay");
    }

    public long getMaxWriteSize() {
        return this.maxWriteSize;
    }

    public void setMaxWriteSize(long l2) {
        this.maxWriteSize = l2;
    }

    protected void doAccounting(TrafficCounter trafficCounter) {
    }

    void releaseReadSuspended(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        channel.attr(READ_SUSPENDED).set((Object)false);
        channel.config().setAutoRead(true);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        long l2 = this.calculateSize(object);
        long l3 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l4 = this.trafficCounter.readTimeToWait(l2, this.readLimit, this.maxTime, l3);
            if ((l4 = this.checkWaitReadTime(channelHandlerContext, l4, l3)) >= 10L) {
                Channel channel = channelHandlerContext.channel();
                ChannelConfig channelConfig = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read suspend: " + l4 + ':' + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set((Object)true);
                    Attribute attribute = channel.attr(REOPEN_TASK);
                    Runnable runnable = (Runnable)attribute.get();
                    if (runnable == null) {
                        runnable = new ReopenReadTimerTask(channelHandlerContext);
                        attribute.set((Object)runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l4, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l4);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l3);
        channelHandlerContext.fireChannelRead(object);
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        Channel channel = channelHandlerContext.channel();
        if (channel.hasAttr(REOPEN_TASK)) {
            channel.attr(REOPEN_TASK).set(null);
        }
        super.handlerRemoved(channelHandlerContext);
    }

    long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l2, long l3) {
        return l2;
    }

    void informReadOperation(ChannelHandlerContext channelHandlerContext, long l2) {
    }

    protected static boolean isHandlerActive(ChannelHandlerContext channelHandlerContext) {
        Boolean bl2 = (Boolean)channelHandlerContext.channel().attr(READ_SUSPENDED).get();
        return bl2 == null || Boolean.FALSE.equals(bl2);
    }

    public void read(ChannelHandlerContext channelHandlerContext) {
        if (AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
            channelHandlerContext.read();
        }
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        long l2;
        long l3 = this.calculateSize(object);
        long l4 = TrafficCounter.milliSecondFromNano();
        if (l3 > 0L && (l2 = this.trafficCounter.writeTimeToWait(l3, this.writeLimit, this.maxTime, l4)) >= 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Write suspend: " + l2 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(channelHandlerContext));
            }
            this.submitWrite(channelHandlerContext, object, l3, l2, l4, channelPromise);
            return;
        }
        this.submitWrite(channelHandlerContext, object, l3, 0L, l4, channelPromise);
    }

    protected void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, ChannelPromise channelPromise) {
        this.submitWrite(channelHandlerContext, object, this.calculateSize(object), l2, TrafficCounter.milliSecondFromNano(), channelPromise);
    }

    abstract void submitWrite(ChannelHandlerContext var1, Object var2, long var3, long var5, long var7, ChannelPromise var9);

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.setUserDefinedWritability(channelHandlerContext, true);
        super.channelRegistered(channelHandlerContext);
    }

    void setUserDefinedWritability(ChannelHandlerContext channelHandlerContext, boolean bl2) {
        ChannelOutboundBuffer channelOutboundBuffer = channelHandlerContext.channel().unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.setUserDefinedWritability(this.userDefinedWritabilityIndex, bl2);
        }
    }

    void checkWriteSuspend(ChannelHandlerContext channelHandlerContext, long l2, long l3) {
        if (l3 > this.maxWriteSize || l2 > this.maxWriteDelay) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
    }

    void releaseWriteSuspended(ChannelHandlerContext channelHandlerContext) {
        this.setUserDefinedWritability(channelHandlerContext, true);
    }

    public TrafficCounter trafficCounter() {
        return this.trafficCounter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(290).append("TrafficShaping with Write Limit: ").append(this.writeLimit).append(" Read Limit: ").append(this.readLimit).append(" CheckInterval: ").append(this.checkInterval).append(" maxDelay: ").append(this.maxWriteDelay).append(" maxSize: ").append(this.maxWriteSize).append(" and Counter: ");
        if (this.trafficCounter != null) {
            stringBuilder.append(this.trafficCounter);
        } else {
            stringBuilder.append("none");
        }
        return stringBuilder.toString();
    }

    protected long calculateSize(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        return -1L;
    }

    static final class ReopenReadTimerTask
    implements Runnable {
        final ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        @Override
        public void run() {
            Channel channel = this.ctx.channel();
            ChannelConfig channelConfig = channel.config();
            if (!channelConfig.isAutoRead() && AbstractTrafficShapingHandler.isHandlerActive(this.ctx)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not unsuspend: " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                }
                channel.attr(READ_SUSPENDED).set((Object)false);
            } else {
                if (logger.isDebugEnabled()) {
                    if (channelConfig.isAutoRead() && !AbstractTrafficShapingHandler.isHandlerActive(this.ctx)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unsuspend: " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Normal unsuspend: " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                    }
                }
                channel.attr(READ_SUSPENDED).set((Object)false);
                channelConfig.setAutoRead(true);
                channel.read();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Unsuspend final status => " + channelConfig.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
            }
        }
    }
}

