/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.timeout;

import XdepsXdatabricksX240X9088.io.netty.handler.timeout.IdleState;
import XdepsXdatabricksX240X9088.io.netty.handler.timeout.IdleStateEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            IdleStateHandler.this.lastWriteTime = IdleStateHandler.this.ticksInNanos();
            IdleStateHandler.this.firstWriterIdleEvent = (IdleStateHandler.this.firstAllIdleEvent = true);
        }
    };
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private Future<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private Future<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private Future<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private static final byte ST_INITIALIZED = 1;
    private static final byte ST_DESTROYED = 2;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    public IdleStateHandler(int n2, int n3, int n4) {
        this(n2, n3, n4, TimeUnit.SECONDS);
    }

    public IdleStateHandler(long l2, long l3, long l4, TimeUnit timeUnit) {
        this(false, l2, l3, l4, timeUnit);
    }

    public IdleStateHandler(boolean bl2, long l2, long l3, long l4, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull((Object)((Object)timeUnit), (String)"unit");
        this.observeOutput = bl2;
        this.readerIdleTimeNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = l3 <= 0L ? 0L : Math.max(timeUnit.toNanos(l3), MIN_TIMEOUT_NANOS);
        this.allIdleTimeNanos = l4 <= 0L ? 0L : Math.max(timeUnit.toNanos(l4), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.channel().isActive() && channelHandlerContext.channel().isRegistered()) {
            this.initialize(channelHandlerContext);
        }
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (channelHandlerContext.channel().isActive()) {
            this.initialize(channelHandlerContext);
        }
        super.channelRegistered(channelHandlerContext);
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.initialize(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.destroy();
        super.channelInactive(channelHandlerContext);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            this.firstAllIdleEvent = true;
            this.firstReaderIdleEvent = true;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            channelHandlerContext.write(object, channelPromise.unvoid()).addListener((GenericFutureListener)this.writeListener);
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    public void resetReadTimeout() {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
    }

    public void resetWriteTimeout() {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastWriteTime = this.ticksInNanos();
        }
    }

    private void initialize(ChannelHandlerContext channelHandlerContext) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(channelHandlerContext);
        this.lastReadTime = this.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(channelHandlerContext, new ReaderIdleTimeoutTask(channelHandlerContext), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(channelHandlerContext, new WriterIdleTimeoutTask(channelHandlerContext), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = this.schedule(channelHandlerContext, new AllIdleTimeoutTask(channelHandlerContext), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    Future<?> schedule(ChannelHandlerContext channelHandlerContext, Runnable runnable, long l2, TimeUnit timeUnit) {
        return channelHandlerContext.executor().schedule(runnable, l2, timeUnit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext channelHandlerContext, IdleStateEvent idleStateEvent) throws Exception {
        channelHandlerContext.fireUserEventTriggered((Object)idleStateEvent);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState idleState, boolean bl2) {
        switch (idleState) {
            case ALL_IDLE: {
                return bl2 ? IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT : IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                return bl2 ? IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT : IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                return bl2 ? IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT : IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + (Object)((Object)idleState) + ", first=" + bl2);
    }

    private void initOutputChanged(ChannelHandlerContext channelHandlerContext) {
        Channel channel;
        Channel.Unsafe unsafe;
        ChannelOutboundBuffer channelOutboundBuffer;
        if (this.observeOutput && (channelOutboundBuffer = (unsafe = (channel = channelHandlerContext.channel()).unsafe()).outboundBuffer()) != null) {
            this.lastMessageHashCode = System.identityHashCode(channelOutboundBuffer.current());
            this.lastPendingWriteBytes = channelOutboundBuffer.totalPendingWriteBytes();
            this.lastFlushProgress = channelOutboundBuffer.currentProgress();
        }
    }

    private boolean hasOutputChanged(ChannelHandlerContext channelHandlerContext, boolean bl2) {
        if (this.observeOutput) {
            Channel channel;
            Channel.Unsafe unsafe;
            ChannelOutboundBuffer channelOutboundBuffer;
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!bl2) {
                    return true;
                }
            }
            if ((channelOutboundBuffer = (unsafe = (channel = channelHandlerContext.channel()).unsafe()).outboundBuffer()) != null) {
                long l2;
                int n2 = System.identityHashCode(channelOutboundBuffer.current());
                long l3 = channelOutboundBuffer.totalPendingWriteBytes();
                if (n2 != this.lastMessageHashCode || l3 != this.lastPendingWriteBytes) {
                    this.lastMessageHashCode = n2;
                    this.lastPendingWriteBytes = l3;
                    if (!bl2) {
                        return true;
                    }
                }
                if ((l2 = channelOutboundBuffer.currentProgress()) != this.lastFlushProgress) {
                    this.lastFlushProgress = l2;
                    return !bl2;
                }
            }
        }
        return false;
    }

    final class AllIdleTimeoutTask
    extends AbstractIdleTask {
        AllIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected void run(ChannelHandlerContext channelHandlerContext) {
            long l2 = IdleStateHandler.this.allIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                l2 -= IdleStateHandler.this.ticksInNanos() - Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime);
            }
            if (l2 <= 0L) {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, IdleStateHandler.this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl2 = IdleStateHandler.this.firstAllIdleEvent;
                IdleStateHandler.this.firstAllIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(channelHandlerContext, bl2)) {
                        return;
                    }
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.ALL_IDLE, bl2);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                }
            } else {
                IdleStateHandler.this.allIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l2, TimeUnit.NANOSECONDS);
            }
        }
    }

    final class WriterIdleTimeoutTask
    extends AbstractIdleTask {
        WriterIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected void run(ChannelHandlerContext channelHandlerContext) {
            long l2 = IdleStateHandler.this.lastWriteTime;
            long l3 = IdleStateHandler.this.writerIdleTimeNanos - (IdleStateHandler.this.ticksInNanos() - l2);
            if (l3 <= 0L) {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, IdleStateHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl2 = IdleStateHandler.this.firstWriterIdleEvent;
                IdleStateHandler.this.firstWriterIdleEvent = false;
                try {
                    if (IdleStateHandler.this.hasOutputChanged(channelHandlerContext, bl2)) {
                        return;
                    }
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.WRITER_IDLE, bl2);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                }
            } else {
                IdleStateHandler.this.writerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l3, TimeUnit.NANOSECONDS);
            }
        }
    }

    final class ReaderIdleTimeoutTask
    extends AbstractIdleTask {
        ReaderIdleTimeoutTask(ChannelHandlerContext channelHandlerContext) {
            super(channelHandlerContext);
        }

        @Override
        protected void run(ChannelHandlerContext channelHandlerContext) {
            long l2 = IdleStateHandler.this.readerIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                l2 -= IdleStateHandler.this.ticksInNanos() - IdleStateHandler.this.lastReadTime;
            }
            if (l2 <= 0L) {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, IdleStateHandler.this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean bl2 = IdleStateHandler.this.firstReaderIdleEvent;
                IdleStateHandler.this.firstReaderIdleEvent = false;
                try {
                    IdleStateEvent idleStateEvent = IdleStateHandler.this.newIdleStateEvent(IdleState.READER_IDLE, bl2);
                    IdleStateHandler.this.channelIdle(channelHandlerContext, idleStateEvent);
                }
                catch (Throwable throwable) {
                    channelHandlerContext.fireExceptionCaught(throwable);
                }
            } else {
                IdleStateHandler.this.readerIdleTimeout = IdleStateHandler.this.schedule(channelHandlerContext, this, l2, TimeUnit.NANOSECONDS);
            }
        }
    }

    static abstract class AbstractIdleTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AbstractIdleTask(ChannelHandlerContext channelHandlerContext) {
            this.ctx = channelHandlerContext;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            this.run(this.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

