/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.stream;

import XdepsXdatabricksX240X9088.io.netty.handler.stream.ChunkedInput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;

public class ChunkedNioFile
implements ChunkedInput<ByteBuf> {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedNioFile(File file) throws IOException {
        this(new RandomAccessFile(file, "r").getChannel());
    }

    public ChunkedNioFile(File file, int n2) throws IOException {
        this(new RandomAccessFile(file, "r").getChannel(), n2);
    }

    public ChunkedNioFile(FileChannel fileChannel) throws IOException {
        this(fileChannel, 8192);
    }

    public ChunkedNioFile(FileChannel fileChannel, int n2) throws IOException {
        this(fileChannel, 0L, fileChannel.size(), n2);
    }

    public ChunkedNioFile(FileChannel fileChannel, long l2, long l3, int n2) throws IOException {
        ObjectUtil.checkNotNull((Object)fileChannel, (String)"in");
        ObjectUtil.checkPositiveOrZero((long)l2, (String)"offset");
        ObjectUtil.checkPositiveOrZero((long)l3, (String)"length");
        ObjectUtil.checkPositive((int)n2, (String)"chunkSize");
        if (!fileChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        this.in = fileChannel;
        this.chunkSize = n2;
        this.offset = this.startOffset = l2;
        this.endOffset = l2 + l3;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset >= this.endOffset || !this.in.isOpen();
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n2 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        ByteBuf byteBuf = byteBufAllocator.buffer(n2);
        boolean bl2 = true;
        try {
            int n3;
            int n4 = 0;
            while ((n3 = byteBuf.writeBytes(this.in, l2 + (long)n4, n2 - n4)) >= 0 && (n4 += n3) != n2) {
            }
            this.offset += (long)n4;
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

