/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl.util;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.util.FingerprintTrustManagerFactoryBuilder;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private final FastThreadLocal<MessageDigest> tlmd;
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted("client", x509CertificateArray);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted("server", x509CertificateArray);
        }

        private void checkTrusted(String string, X509Certificate[] x509CertificateArray) throws CertificateException {
            X509Certificate x509Certificate = x509CertificateArray[0];
            byte[] byArray = this.fingerprint(x509Certificate);
            boolean bl2 = false;
            for (byte[] byArray2 : FingerprintTrustManagerFactory.this.fingerprints) {
                if (!Arrays.equals(byArray, byArray2)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new CertificateException(string + " certificate with unknown fingerprint: " + x509Certificate.getSubjectDN());
            }
        }

        private byte[] fingerprint(X509Certificate x509Certificate) throws CertificateEncodingException {
            MessageDigest messageDigest = (MessageDigest)FingerprintTrustManagerFactory.this.tlmd.get();
            messageDigest.reset();
            return messageDigest.digest(x509Certificate.getEncoded());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    private final byte[][] fingerprints;

    public static FingerprintTrustManagerFactoryBuilder builder(String string) {
        return new FingerprintTrustManagerFactoryBuilder(string);
    }

    public FingerprintTrustManagerFactory(Iterable<String> iterable) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray(iterable));
    }

    public FingerprintTrustManagerFactory(String ... stringArray) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(stringArray)));
    }

    public FingerprintTrustManagerFactory(byte[] ... byArray) {
        this("SHA1", byArray);
    }

    FingerprintTrustManagerFactory(final String string, byte[][] byArray) {
        MessageDigest messageDigest;
        ObjectUtil.checkNotNull((Object)string, (String)"algorithm");
        ObjectUtil.checkNotNull((Object)byArray, (String)"fingerprints");
        if (byArray.length == 0) {
            throw new IllegalArgumentException("No fingerprints provided");
        }
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", string), noSuchAlgorithmException);
        }
        int n2 = messageDigest.getDigestLength();
        ArrayList<Object> arrayList = new ArrayList<Object>(byArray.length);
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) break;
            if (byArray2.length != n2) {
                throw new IllegalArgumentException(String.format("malformed fingerprint (length is %d but expected %d): %s", byArray2.length, n2, ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])byArray2))));
            }
            arrayList.add(byArray2.clone());
        }
        this.tlmd = new FastThreadLocal<MessageDigest>(){

            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance(string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", string), noSuchAlgorithmException);
                }
            }
        };
        this.fingerprints = (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    static byte[][] toFingerprintArray(Iterable<String> iterable) {
        ObjectUtil.checkNotNull(iterable, (String)"fingerprints");
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (String string : iterable) {
            if (string == null) break;
            if (!FINGERPRINT_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + string);
            }
            string = FINGERPRINT_STRIP_PATTERN.matcher(string).replaceAll("");
            arrayList.add(StringUtil.decodeHexDump((CharSequence)string));
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

